/*
 * Decompiled with CFR 0.152.
 */
package com.jauntsdn.netty.handler.codec.http.websocketx;

import com.jauntsdn.netty.handler.codec.http.websocketx.WebSocketCallbacksFrameEncoder;
import com.jauntsdn.netty.handler.codec.http.websocketx.WebSocketFrameFactory;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty.util.internal.PlatformDependent;
import java.nio.charset.StandardCharsets;

final class MaskingWebSocketEncoder
extends ChannelOutboundHandlerAdapter
implements WebSocketCallbacksFrameEncoder {
    static final MaskingWebSocketEncoder INSTANCE = new MaskingWebSocketEncoder();

    private MaskingWebSocketEncoder() {
    }

    public boolean isSharable() {
        return true;
    }

    @Override
    public WebSocketFrameFactory frameFactory(ChannelHandlerContext ctx) {
        ctx.pipeline().remove((ChannelHandler)this);
        return FrameFactory.INSTANCE;
    }

    static class FrameFactory
    implements WebSocketFrameFactory,
    WebSocketFrameFactory.Encoder,
    WebSocketFrameFactory.BulkEncoder {
        static final int PREFIX_SIZE_SMALL = 6;
        static final int BINARY_FRAME_SMALL = 33408;
        static final int TEXT_FRAME_SMALL = 33152;
        static final int BINARY_FRAGMENT_START_SMALL = 640;
        static final int TEXT_FRAGMENT_START_SMALL = 384;
        static final int DATA_FRAGMENT_CONTINUATION_SMALL = 128;
        static final int DATA_FRAGMENT_CONTINUATION_END_SMALL = 32896;
        static final int CLOSE_FRAME = 34944;
        static final int PING_FRAME = 35200;
        static final int PONG_FRAME = 35456;
        static final int PREFIX_SIZE_MEDIUM = 8;
        static final int BINARY_FRAME_MEDIUM = -2097283072;
        static final int TEXT_FRAME_MEDIUM = -2114060288;
        static final int BINARY_FRAGMENT_START_MEDIUM = 50200576;
        static final int TEXT_FRAGMENT_START_MEDIUM = 33423360;
        static final int DATA_FRAGMENT_CONTINUATION_MEDIUM = 0xFE0000;
        static final int DATA_FRAGMENT_CONTINUATION_END_MEDIUM = -2130837504;
        static final WebSocketFrameFactory INSTANCE = new FrameFactory();

        FrameFactory() {
        }

        static ByteBuf createDataFrame(ByteBufAllocator allocator, int payloadSize, int prefixSmall, int prefixMedium) {
            if (payloadSize <= 125) {
                return allocator.buffer(6 + payloadSize).writeShort(prefixSmall | payloadSize).readerIndex(2).writeInt(FrameFactory.mask());
            }
            if (payloadSize <= 65535) {
                return allocator.buffer(8 + payloadSize).writeLong((long)(prefixMedium | payloadSize) << 32 | (long)FrameFactory.mask()).readerIndex(4);
            }
            throw new IllegalArgumentException(FrameFactory.payloadSizeLimit(payloadSize, 65535));
        }

        @Override
        public ByteBuf createBinaryFrame(ByteBufAllocator allocator, int payloadSize) {
            return FrameFactory.createDataFrame(allocator, payloadSize, 33408, -2097283072);
        }

        @Override
        public ByteBuf createTextFrame(ByteBufAllocator allocator, int payloadSize) {
            return FrameFactory.createDataFrame(allocator, payloadSize, 33152, -2114060288);
        }

        @Override
        public ByteBuf createBinaryFragmentStart(ByteBufAllocator allocator, int binaryDataSize) {
            return FrameFactory.createDataFrame(allocator, binaryDataSize, 640, 50200576);
        }

        @Override
        public ByteBuf createTextFragmentStart(ByteBufAllocator allocator, int textDataSize) {
            return FrameFactory.createDataFrame(allocator, textDataSize, 384, 33423360);
        }

        @Override
        public ByteBuf createContinuationFragment(ByteBufAllocator allocator, int dataSize) {
            return FrameFactory.createDataFrame(allocator, dataSize, 128, 0xFE0000);
        }

        @Override
        public ByteBuf createContinuationFragmentEnd(ByteBufAllocator allocator, int dataSize) {
            return FrameFactory.createDataFrame(allocator, dataSize, 32896, -2130837504);
        }

        @Override
        public ByteBuf createCloseFrame(ByteBufAllocator allocator, int statusCode, String reason) {
            int payloadSize;
            if (!WebSocketCloseStatus.isValidStatusCode((int)statusCode)) {
                throw new IllegalArgumentException("incorrect close status code: " + statusCode);
            }
            if (reason == null) {
                reason = "";
            }
            if ((payloadSize = 2 + ByteBufUtil.utf8Bytes((CharSequence)reason)) <= 125) {
                ByteBuf frame = allocator.buffer(6 + payloadSize).writeShort(0x8880 | payloadSize).readerIndex(2).writeInt(FrameFactory.mask()).writeShort(statusCode);
                if (!reason.isEmpty()) {
                    frame.writeCharSequence((CharSequence)reason, StandardCharsets.UTF_8);
                }
                return frame;
            }
            throw new IllegalArgumentException(FrameFactory.payloadSizeLimit(payloadSize, 125));
        }

        @Override
        public ByteBuf createPingFrame(ByteBufAllocator allocator, int payloadSize) {
            if (payloadSize <= 125) {
                return allocator.buffer(6 + payloadSize).writeShort(0x8980 | payloadSize).readerIndex(2).writeInt(FrameFactory.mask());
            }
            throw new IllegalArgumentException(FrameFactory.payloadSizeLimit(payloadSize, 125));
        }

        @Override
        public ByteBuf createPongFrame(ByteBufAllocator allocator, int payloadSize) {
            if (payloadSize <= 125) {
                return allocator.buffer(6 + payloadSize).writeShort(0x8A80 | payloadSize).readerIndex(2).writeInt(FrameFactory.mask());
            }
            throw new IllegalArgumentException(FrameFactory.payloadSizeLimit(payloadSize, 125));
        }

        @Override
        public ByteBuf mask(ByteBuf frame) {
            int maskIndex = frame.readerIndex();
            int mask = frame.getInt(maskIndex);
            FrameFactory.mask(mask, frame, maskIndex + 4, frame.writerIndex());
            return frame.readerIndex(0);
        }

        @Override
        public WebSocketFrameFactory.Encoder encoder() {
            return this;
        }

        @Override
        public WebSocketFrameFactory.BulkEncoder bulkEncoder() {
            return this;
        }

        @Override
        public ByteBuf encodeBinaryFrame(ByteBuf binaryFrame) {
            return FrameFactory.encodeDataFrame(binaryFrame, 33408, -2097283072);
        }

        @Override
        public ByteBuf encodeTextFrame(ByteBuf textFrame) {
            return FrameFactory.encodeDataFrame(textFrame, 33152, -2114060288);
        }

        @Override
        public ByteBuf encodeBinaryFragmentStart(ByteBuf fragmentFrame) {
            return FrameFactory.encodeDataFrame(fragmentFrame, 640, 50200576);
        }

        @Override
        public ByteBuf encodeTextFragmentStart(ByteBuf fragmentFrame) {
            return FrameFactory.encodeDataFrame(fragmentFrame, 384, 33423360);
        }

        @Override
        public ByteBuf encodeContinuationFragment(ByteBuf fragmentFrame) {
            return FrameFactory.encodeDataFrame(fragmentFrame, 128, 0xFE0000);
        }

        @Override
        public ByteBuf encodeContinuationFragmentEnd(ByteBuf fragmentFrame) {
            return FrameFactory.encodeDataFrame(fragmentFrame, 32896, -2130837504);
        }

        @Override
        public int sizeofFragment(int payloadSize) {
            return FrameFactory.sizeOfDataFrame(payloadSize);
        }

        static ByteBuf encodeDataFrame(ByteBuf binaryFrame, int prefixSmall, int prefixMedium) {
            int smallPrefixSize;
            int frameSize = binaryFrame.readableBytes();
            if (frameSize <= 125 + (smallPrefixSize = 6)) {
                int payloadSize = frameSize - smallPrefixSize;
                binaryFrame.setShort(0, prefixSmall | payloadSize);
                int mask = FrameFactory.mask();
                binaryFrame.setInt(2, mask);
                return FrameFactory.mask(mask, binaryFrame, smallPrefixSize, binaryFrame.writerIndex());
            }
            int mediumPrefixSize = 8;
            if (frameSize <= 65535 + mediumPrefixSize) {
                int payloadSize = frameSize - mediumPrefixSize;
                int mask = FrameFactory.mask();
                binaryFrame.setLong(0, ((long)prefixMedium | (long)payloadSize) << 32 | (long)mask);
                return FrameFactory.mask(mask, binaryFrame, mediumPrefixSize, binaryFrame.writerIndex());
            }
            int payloadSize = frameSize - 12;
            throw new IllegalArgumentException(FrameFactory.payloadSizeLimit(payloadSize, 65535));
        }

        @Override
        public int encodeBinaryFramePrefix(ByteBuf byteBuf, int payloadSize) {
            return FrameFactory.encodeDataFramePrefix(byteBuf, payloadSize, 33408, -2097283072);
        }

        @Override
        public int encodeTextFramePrefix(ByteBuf byteBuf, int textPayloadSize) {
            return FrameFactory.encodeDataFramePrefix(byteBuf, textPayloadSize, 33152, -2114060288);
        }

        static int encodeDataFramePrefix(ByteBuf byteBuf, int payloadSize, int prefixSmall, int prefixMedium) {
            if (payloadSize <= 125) {
                byteBuf.writeShort(prefixSmall | payloadSize);
                int mask = FrameFactory.mask();
                byteBuf.writeInt(mask);
                return mask;
            }
            if (payloadSize <= 65535) {
                int mask = FrameFactory.mask();
                byteBuf.writeLong(((long)prefixMedium | (long)payloadSize) << 32 | (long)mask);
                return mask;
            }
            throw new IllegalArgumentException(FrameFactory.payloadSizeLimit(payloadSize, 65535));
        }

        @Override
        public ByteBuf maskBinaryFrame(ByteBuf byteBuf, int mask, int payloadSize) {
            return FrameFactory.maskDataFrame(byteBuf, mask, payloadSize);
        }

        @Override
        public ByteBuf maskTextFrame(ByteBuf byteBuf, int mask, int textPayloadSize) {
            return FrameFactory.maskDataFrame(byteBuf, mask, textPayloadSize);
        }

        static ByteBuf maskDataFrame(ByteBuf byteBuf, int mask, int payloadSize) {
            int end = byteBuf.writerIndex();
            int start = end - payloadSize;
            return FrameFactory.mask(mask, byteBuf, start, end);
        }

        @Override
        public int sizeofBinaryFrame(int payloadSize) {
            return FrameFactory.sizeOfDataFrame(payloadSize);
        }

        @Override
        public int sizeofTextFrame(int textPayloadSize) {
            return FrameFactory.sizeOfDataFrame(textPayloadSize);
        }

        static int sizeOfDataFrame(int payloadSize) {
            if (payloadSize <= 125) {
                return payloadSize + 6;
            }
            if (payloadSize < 65535) {
                return payloadSize + 8;
            }
            throw new IllegalArgumentException(FrameFactory.payloadSizeLimit(payloadSize, 65535));
        }

        static ByteBuf mask(int mask, ByteBuf frame, int start, int end) {
            int cur = start;
            if (end - cur >= 8) {
                long longMask = (long)mask & 0xFFFFFFFFL;
                longMask |= longMask << 32;
                while (cur < end - 7) {
                    frame.setLong(cur, frame.getLong(cur) ^ longMask);
                    cur += 8;
                }
            }
            if (end - cur >= 4) {
                frame.setInt(cur, frame.getInt(cur) ^ mask);
                cur += 4;
            }
            int maskOffset = 0;
            while (cur < end) {
                byte bytePayload = frame.getByte(cur);
                frame.setByte(cur, bytePayload ^ FrameFactory.byteAtIndex(mask, maskOffset++ & 3));
                ++cur;
            }
            return frame;
        }

        static int byteAtIndex(int mask, int index) {
            return mask >> 8 * (3 - index) & 0xFF;
        }

        static int mask() {
            return PlatformDependent.threadLocalRandom().nextInt(Integer.MAX_VALUE);
        }

        static String payloadSizeLimit(int payloadSize, int limit) {
            return "payloadSize: " + payloadSize + " exceeds supported limit: " + limit;
        }
    }
}

