/*
 * Decompiled with CFR 0.152.
 */
package com.jauntsdn.netty.handler.codec.http.websocketx;

import com.jauntsdn.netty.handler.codec.http.websocketx.WebSocketCallbacksFrameEncoder;
import com.jauntsdn.netty.handler.codec.http.websocketx.WebSocketFrameFactory;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import java.nio.charset.StandardCharsets;

final class NonMaskingWebSocketEncoder
extends ChannelOutboundHandlerAdapter
implements WebSocketCallbacksFrameEncoder {
    static final NonMaskingWebSocketEncoder INSTANCE = new NonMaskingWebSocketEncoder();

    private NonMaskingWebSocketEncoder() {
    }

    public boolean isSharable() {
        return true;
    }

    @Override
    public WebSocketFrameFactory frameFactory(ChannelHandlerContext ctx) {
        ctx.pipeline().remove((ChannelHandler)this);
        return FrameFactory.INSTANCE;
    }

    static class FrameFactory
    implements WebSocketFrameFactory,
    WebSocketFrameFactory.Encoder,
    WebSocketFrameFactory.BulkEncoder {
        static final int PREFIX_SIZE_SMALL = 2;
        static final int BINARY_FRAME_SMALL = 33280;
        static final int TEXT_FRAME_SMALL = 33024;
        static final int BINARY_FRAGMENT_START_SMALL = 512;
        static final int TEXT_FRAGMENT_START_SMALL = 256;
        static final int DATA_FRAGMENT_CONTINUATION_SMALL = 0;
        static final int DATA_FRAGMENT_CONTINUATION_END_SMALL = 32768;
        static final int CLOSE_FRAME = 34816;
        static final int PING_FRAME = 35072;
        static final int PONG_FRAME = 35328;
        static final int PREFIX_SIZE_MEDIUM = 4;
        static final int BINARY_FRAME_MEDIUM = -2105671680;
        static final int TEXT_FRAME_MEDIUM = -2122448896;
        static final int BINARY_FRAGMENT_START_MEDIUM = 41811968;
        static final int TEXT_FRAGMENT_START_MEDIUM = 25034752;
        static final int DATA_FRAGMENT_CONTINUATION_MEDIUM = 0x7E0000;
        static final int DATA_FRAGMENT_CONTINUATION_END_MEDIUM = -2139226112;
        static final WebSocketFrameFactory INSTANCE = new FrameFactory();

        FrameFactory() {
        }

        static ByteBuf createDataFrame(ByteBufAllocator allocator, int payloadSize, int prefixSmall, int prefixMedium) {
            if (payloadSize <= 125) {
                return allocator.buffer(2 + payloadSize).writeShort(prefixSmall | payloadSize);
            }
            if (payloadSize <= 65535) {
                return allocator.buffer(4 + payloadSize).writeInt(prefixMedium | payloadSize);
            }
            throw new IllegalArgumentException(FrameFactory.payloadSizeLimit(payloadSize, 65535));
        }

        @Override
        public ByteBuf createBinaryFrame(ByteBufAllocator allocator, int payloadSize) {
            return FrameFactory.createDataFrame(allocator, payloadSize, 33280, -2105671680);
        }

        @Override
        public ByteBuf createTextFrame(ByteBufAllocator allocator, int textDataSize) {
            return FrameFactory.createDataFrame(allocator, textDataSize, 33024, -2122448896);
        }

        @Override
        public ByteBuf createBinaryFragmentStart(ByteBufAllocator allocator, int binaryDataSize) {
            return FrameFactory.createDataFrame(allocator, binaryDataSize, 512, 41811968);
        }

        @Override
        public ByteBuf createTextFragmentStart(ByteBufAllocator allocator, int textDataSize) {
            return FrameFactory.createDataFrame(allocator, textDataSize, 256, 25034752);
        }

        @Override
        public ByteBuf createContinuationFragment(ByteBufAllocator allocator, int dataSize) {
            return FrameFactory.createDataFrame(allocator, dataSize, 0, 0x7E0000);
        }

        @Override
        public ByteBuf createContinuationFragmentEnd(ByteBufAllocator allocator, int dataSize) {
            return FrameFactory.createDataFrame(allocator, dataSize, 32768, -2139226112);
        }

        @Override
        public ByteBuf createCloseFrame(ByteBufAllocator allocator, int statusCode, String reason) {
            int payloadSize;
            if (!WebSocketCloseStatus.isValidStatusCode((int)statusCode)) {
                throw new IllegalArgumentException("Incorrect close status code: " + statusCode);
            }
            if (reason == null) {
                reason = "";
            }
            if ((payloadSize = 2 + ByteBufUtil.utf8Bytes((CharSequence)reason)) <= 125) {
                ByteBuf frame = allocator.buffer(2 + payloadSize);
                frame.writeInt((0x8800 | payloadSize) << 16 | statusCode);
                if (!reason.isEmpty()) {
                    frame.writeCharSequence((CharSequence)reason, StandardCharsets.UTF_8);
                }
                return frame;
            }
            throw new IllegalArgumentException(FrameFactory.payloadSizeLimit(payloadSize, 125));
        }

        @Override
        public ByteBuf createPingFrame(ByteBufAllocator allocator, int payloadSize) {
            if (payloadSize <= 125) {
                return allocator.buffer(2 + payloadSize).writeShort(0x8900 | payloadSize);
            }
            throw new IllegalArgumentException(FrameFactory.payloadSizeLimit(payloadSize, 125));
        }

        @Override
        public ByteBuf createPongFrame(ByteBufAllocator allocator, int payloadSize) {
            if (payloadSize <= 125) {
                return allocator.buffer(2 + payloadSize).writeShort(0x8A00 | payloadSize);
            }
            throw new IllegalArgumentException(FrameFactory.payloadSizeLimit(payloadSize, 125));
        }

        @Override
        public ByteBuf mask(ByteBuf frame) {
            return frame;
        }

        @Override
        public WebSocketFrameFactory.Encoder encoder() {
            return this;
        }

        @Override
        public WebSocketFrameFactory.BulkEncoder bulkEncoder() {
            return this;
        }

        @Override
        public ByteBuf encodeBinaryFrame(ByteBuf binaryFrame) {
            return FrameFactory.encodeDataFrame(binaryFrame, 33280, -2105671680);
        }

        @Override
        public ByteBuf encodeTextFrame(ByteBuf textFrame) {
            return FrameFactory.encodeDataFrame(textFrame, 33024, -2122448896);
        }

        @Override
        public ByteBuf encodeBinaryFragmentStart(ByteBuf fragmentFrame) {
            return FrameFactory.encodeDataFrame(fragmentFrame, 512, 41811968);
        }

        @Override
        public ByteBuf encodeTextFragmentStart(ByteBuf fragmentFrame) {
            return FrameFactory.encodeDataFrame(fragmentFrame, 256, 25034752);
        }

        @Override
        public ByteBuf encodeContinuationFragment(ByteBuf fragmentFrame) {
            return FrameFactory.encodeDataFrame(fragmentFrame, 0, 0x7E0000);
        }

        @Override
        public ByteBuf encodeContinuationFragmentEnd(ByteBuf fragmentFrame) {
            return FrameFactory.encodeDataFrame(fragmentFrame, 32768, -2139226112);
        }

        @Override
        public int sizeofFragment(int payloadSize) {
            return FrameFactory.sizeOfDataFrame(payloadSize);
        }

        static ByteBuf encodeDataFrame(ByteBuf binaryFrame, int prefixSmall, int prefixMedium) {
            int smallPrefixSize;
            int frameSize = binaryFrame.readableBytes();
            if (frameSize <= 125 + (smallPrefixSize = 2)) {
                int payloadSize = frameSize - smallPrefixSize;
                return binaryFrame.setShort(0, prefixSmall | payloadSize);
            }
            int mediumPrefixSize = 4;
            if (frameSize <= 65535 + mediumPrefixSize) {
                int payloadSize = frameSize - mediumPrefixSize;
                return binaryFrame.setInt(0, prefixMedium | payloadSize);
            }
            int payloadSize = frameSize - 8;
            throw new IllegalArgumentException(FrameFactory.payloadSizeLimit(payloadSize, 65535));
        }

        @Override
        public int encodeBinaryFramePrefix(ByteBuf byteBuf, int payloadSize) {
            return FrameFactory.encodeDataFramePrefix(byteBuf, payloadSize, 33280, -2105671680);
        }

        @Override
        public int encodeTextFramePrefix(ByteBuf byteBuf, int textPayloadSize) {
            return FrameFactory.encodeDataFramePrefix(byteBuf, textPayloadSize, 33024, -2122448896);
        }

        static int encodeDataFramePrefix(ByteBuf byteBuf, int payloadSize, int prefixSmall, int prefixMedium) {
            if (payloadSize <= 125) {
                byteBuf.writeShort(prefixSmall | payloadSize);
            } else if (payloadSize <= 65535) {
                byteBuf.writeInt(prefixMedium | payloadSize);
            } else {
                throw new IllegalArgumentException(FrameFactory.payloadSizeLimit(payloadSize, 65535));
            }
            return -1;
        }

        @Override
        public ByteBuf maskBinaryFrame(ByteBuf byteBuf, int mask, int payloadSize) {
            return byteBuf;
        }

        @Override
        public ByteBuf maskTextFrame(ByteBuf byteBuf, int mask, int textPayloadSize) {
            return byteBuf;
        }

        @Override
        public int sizeofBinaryFrame(int payloadSize) {
            return FrameFactory.sizeOfDataFrame(payloadSize);
        }

        @Override
        public int sizeofTextFrame(int textPayloadSize) {
            return FrameFactory.sizeOfDataFrame(textPayloadSize);
        }

        static int sizeOfDataFrame(int payloadSize) {
            if (payloadSize <= 125) {
                return payloadSize + 2;
            }
            if (payloadSize < 65535) {
                return payloadSize + 4;
            }
            throw new IllegalArgumentException(FrameFactory.payloadSizeLimit(payloadSize, 65535));
        }

        static String payloadSizeLimit(int payloadSize, int limit) {
            return "payloadSize: " + payloadSize + " exceeds supported limit: " + limit;
        }
    }
}

