/*
 * Decompiled with CFR 0.152.
 */
package com.jauntsdn.netty.handler.codec.http.websocketx;

import com.jauntsdn.netty.handler.codec.http.websocketx.MaskingWebSocketEncoder;
import com.jauntsdn.netty.handler.codec.http.websocketx.NonMaskingWebSocketEncoder;
import com.jauntsdn.netty.handler.codec.http.websocketx.WebSocketDecoder;
import com.jauntsdn.netty.handler.codec.http.websocketx.WebSocketFrameFactory;
import com.jauntsdn.netty.handler.codec.http.websocketx.WebSocketProtocol;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;

abstract class SmallWebSocketDecoder
extends WebSocketDecoder {
    static final int MAX_FRAME_PAYLOAD_LENGTH = 125;
    int encodedState = SmallWebSocketDecoder.encodeFragmentedLength(0, -1);
    ByteBuf partialPayload;

    SmallWebSocketDecoder() {
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ByteBuf partPayload = this.partialPayload;
        if (partPayload != null) {
            partPayload.release();
        }
        super.channelInactive(ctx);
    }

    @Override
    void decode(ChannelHandlerContext ctx, ByteBuf in) {
        int encodedSt = this.encodedState;
        int st = SmallWebSocketDecoder.decodeState(encodedSt);
        int readableBytes = in.readableBytes();
        block6: while (readableBytes > 0) {
            switch (st) {
                case 0: {
                    boolean maskFlag;
                    if (readableBytes == 1) {
                        st = 1;
                        encodedSt = SmallWebSocketDecoder.encodePartialPrefix(encodedSt, in.readByte());
                        readableBytes = 0;
                        continue block6;
                    }
                    int prefix = in.readShort();
                    readableBytes -= 2;
                    int flagsAndOpcode = prefix >> 8;
                    int flags = flagsAndOpcode & 0xF0;
                    int code = flagsAndOpcode & 0xF;
                    int length = prefix & 0x7F;
                    boolean bl = maskFlag = (prefix & 0x80) == 128;
                    if (maskFlag) {
                        WebSocketProtocol.close(ctx, this, WebSocketCloseStatus.NORMAL_CLOSURE, "frames masking is not supported");
                        return;
                    }
                    boolean finFlag = prefix < 0;
                    int result = WebSocketProtocol.validate(ctx, this, flags, code, length, SmallWebSocketDecoder.decodeFragmentedLength(encodedSt), 125);
                    if (result == -128) {
                        return;
                    }
                    encodedSt = SmallWebSocketDecoder.encodeFragmentedLength(encodedSt, result);
                    if (readableBytes >= length) {
                        ByteBuf payload = in.readRetainedSlice(length);
                        readableBytes -= length;
                        this.onFrameRead(ctx, finFlag, code, payload);
                        continue block6;
                    }
                    encodedSt = SmallWebSocketDecoder.encodeFlags(encodedSt, code, finFlag);
                    this.partialPayload = SmallWebSocketDecoder.partialPayload(ctx, in, length);
                    readableBytes = 0;
                    st = 3;
                    continue block6;
                }
                case 1: {
                    boolean finFlag;
                    int prefix = SmallWebSocketDecoder.decodePartialPrefix(encodedSt) | in.readByte();
                    --readableBytes;
                    int flagsAndOpcode = prefix >> 8;
                    int flags = flagsAndOpcode & 0xF0;
                    int code = flagsAndOpcode & 0xF;
                    int length = prefix & 0x7F;
                    boolean maskFlag = (prefix & 0x80) == 128;
                    boolean bl = finFlag = (short)prefix < 0;
                    if (maskFlag) {
                        WebSocketProtocol.close(ctx, this, WebSocketCloseStatus.NORMAL_CLOSURE, "frames masking is not supported");
                        return;
                    }
                    int fragmentedTotalLength = SmallWebSocketDecoder.decodeFragmentedLength(encodedSt);
                    int result = WebSocketProtocol.validate(ctx, this, flags, code, length, fragmentedTotalLength, 125);
                    if (result == -128) {
                        return;
                    }
                    fragmentedTotalLength = result;
                    encodedSt = SmallWebSocketDecoder.encodeFragmentedLength(encodedSt, fragmentedTotalLength);
                    if (readableBytes >= length) {
                        ByteBuf payload = in.readRetainedSlice(length);
                        readableBytes -= length;
                        st = 0;
                        this.onFrameRead(ctx, finFlag, code, payload);
                        continue block6;
                    }
                    encodedSt = SmallWebSocketDecoder.encodeFlags(encodedSt, code, finFlag);
                    this.partialPayload = SmallWebSocketDecoder.partialPayload(ctx, in, length);
                    readableBytes = 0;
                    st = 3;
                    continue block6;
                }
                case 3: {
                    ByteBuf partial = this.partialPayload;
                    int remaining = partial.capacity() - partial.writerIndex();
                    int toRead = Math.min(readableBytes, remaining);
                    partial.writeBytes(in, toRead);
                    readableBytes -= toRead;
                    if ((remaining -= toRead) != 0) continue block6;
                    this.partialPayload = null;
                    int opcodeFin = SmallWebSocketDecoder.decodeFlags(encodedSt);
                    int opcode = SmallWebSocketDecoder.decodeFlagOpcode(opcodeFin);
                    boolean fin = SmallWebSocketDecoder.decodeFlagFin(opcodeFin);
                    this.onFrameRead(ctx, fin, opcode, partial);
                    st = 0;
                    continue block6;
                }
                case 4: {
                    continue block6;
                }
            }
            throw new IllegalStateException("unexpected decoding state: " + st);
        }
        this.encodedState = SmallWebSocketDecoder.encodeState(encodedSt, st);
    }

    @Override
    void closeInbound() {
        this.encodedState = SmallWebSocketDecoder.encodeState(this.encodedState, 4);
    }

    static ByteBuf partialPayload(ChannelHandlerContext ctx, ByteBuf in, int length) {
        ByteBuf partial = ctx.alloc().buffer(length);
        partial.writeBytes(in);
        return partial;
    }

    static int encodeState(int encodedState, int state) {
        return encodedState & 0xFFFFFFFC | state;
    }

    static int decodeState(int encodedState) {
        return encodedState & 3;
    }

    static int encodeFlags(int encodedState, int opcode, boolean fin) {
        int flags = (fin ? 1 : 0) << 6 | opcode << 2;
        return encodedState & 0xFFFFFFF3 | flags;
    }

    static int decodeFlags(int encodedState) {
        return (encodedState & 0xFC) >> 2;
    }

    static int decodeFlagOpcode(int flags) {
        return flags & 0xF;
    }

    static boolean decodeFlagFin(int flags) {
        return (flags & 0x10) == 16;
    }

    static int encodePartialPrefix(int encodedState, byte partialPrefix) {
        return encodedState & 0xFFFF00FF | partialPrefix << 8 & 0xFFFF;
    }

    static int decodePartialPrefix(int encodedState) {
        return encodedState & 0xFF00;
    }

    static int encodeFragmentedLength(int encodedState, int fragmentedTotalLength) {
        return encodedState & 0xFFFF | fragmentedTotalLength << 16;
    }

    static int decodeFragmentedLength(int encodedState) {
        return (byte)((encodedState & 0xFF0000) >> 16);
    }

    static final class WithNonMaskingEncoder
    extends SmallWebSocketDecoder {
        WithNonMaskingEncoder() {
        }

        @Override
        WebSocketFrameFactory frameFactory() {
            return NonMaskingWebSocketEncoder.FrameFactory.INSTANCE;
        }
    }

    static final class WithMaskingEncoder
    extends SmallWebSocketDecoder {
        WithMaskingEncoder() {
        }

        @Override
        WebSocketFrameFactory frameFactory() {
            return MaskingWebSocketEncoder.FrameFactory.INSTANCE;
        }
    }
}

