/*
 * Decompiled with CFR 0.152.
 */
package com.jauntsdn.netty.handler.codec.http.websocketx;

import com.jauntsdn.netty.handler.codec.http.websocketx.WebSocketCallbacksFrameDecoder;
import com.jauntsdn.netty.handler.codec.http.websocketx.WebSocketCallbacksFrameEncoder;
import com.jauntsdn.netty.handler.codec.http.websocketx.WebSocketFrameFactory;
import com.jauntsdn.netty.handler.codec.http.websocketx.WebSocketFrameListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.util.internal.ObjectUtil;

public interface WebSocketCallbacksHandler {
    public WebSocketFrameListener exchange(ChannelHandlerContext var1, WebSocketFrameFactory var2);

    public static WebSocketFrameFactory exchange(ChannelHandlerContext ctx, WebSocketCallbacksHandler webSocketCallbacksHandler) {
        ObjectUtil.checkNotNull((Object)ctx, (String)"ctx");
        ObjectUtil.checkNotNull((Object)webSocketCallbacksHandler, (String)"webSocketFrameListener");
        ChannelPipeline p = ctx.pipeline();
        ChannelHandlerContext frameFactoryCtx = p.context(WebSocketCallbacksFrameEncoder.class);
        if (frameFactoryCtx == null) {
            throw new IllegalStateException("WebSocketCallbacksFrameEncoder is not present in channel pipeline");
        }
        WebSocketCallbacksFrameEncoder encoder = (WebSocketCallbacksFrameEncoder)frameFactoryCtx.handler();
        ChannelHandlerContext decoderCtx = p.context(WebSocketCallbacksFrameDecoder.class);
        if (decoderCtx == null) {
            throw new IllegalStateException("WebSocketCallbacksFrameDecoder is not present in channel pipeline");
        }
        WebSocketCallbacksFrameDecoder decoder = (WebSocketCallbacksFrameDecoder)decoderCtx.handler();
        WebSocketFrameFactory frameFactory = encoder.frameFactory(ctx);
        WebSocketFrameListener webSocketFrameListener = webSocketCallbacksHandler.exchange(ctx, frameFactory);
        decoder.frameListener(ctx, webSocketFrameListener, frameFactory);
        webSocketFrameListener.onOpen(ctx);
        return frameFactory;
    }
}

