/*
 * Decompiled with CFR 0.152.
 */
package com.jauntsdn.netty.handler.codec.http.websocketx;

import com.jauntsdn.netty.handler.codec.http.websocketx.WebSocketCallbacksFrameDecoder;
import com.jauntsdn.netty.handler.codec.http.websocketx.WebSocketCallbacksFrameEncoder;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker13;
import io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.net.URI;
import java.util.Objects;

public final class WebSocketClientHandshaker
extends WebSocketClientHandshaker13 {
    private final boolean performMasking;
    private final boolean expectMaskedFrames;
    private final boolean allowMaskMismatch;

    public WebSocketClientHandshaker(URI webSocketURL, String subprotocol, HttpHeaders customHeaders, int maxFramePayloadLength, boolean performMasking, boolean expectMaskedFrames, boolean allowMaskMismatch) {
        super(Objects.requireNonNull(webSocketURL, "webSocketURL"), WebSocketVersion.V13, subprotocol, false, customHeaders, maxFramePayloadLength, performMasking, allowMaskMismatch, -1L);
        this.performMasking = performMasking;
        this.expectMaskedFrames = expectMaskedFrames;
        this.allowMaskMismatch = allowMaskMismatch;
    }

    protected WebSocketFrameDecoder newWebsocketDecoder() {
        return WebSocketCallbacksFrameDecoder.frameDecoder(this.performMasking, this.maxFramePayloadLength(), this.expectMaskedFrames, this.allowMaskMismatch);
    }

    protected WebSocketFrameEncoder newWebSocketEncoder() {
        return WebSocketCallbacksFrameEncoder.frameEncoder(this.performMasking);
    }
}

