/*
 * Decompiled with CFR 0.152.
 */
package com.jauntsdn.netty.handler.codec.http.websocketx;

import com.jauntsdn.netty.handler.codec.http.websocketx.WebSocketCallbacksHandler;
import com.jauntsdn.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import com.jauntsdn.netty.handler.codec.http.websocketx.WebSocketProtocol;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.ScheduledFuture;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.ClosedChannelException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public final class WebSocketClientProtocolHandler
extends ChannelInboundHandlerAdapter {
    private final String address;
    private final String path;
    private final String subprotocol;
    private final HttpHeaders headers;
    private final boolean mask;
    private final boolean expectMaskedFrames;
    private final boolean allowMaskMismatch;
    private final int maxFramePayloadLength;
    private final long handshakeTimeoutMillis;
    private final WebSocketCallbacksHandler webSocketHandler;
    private WebSocketClientHandshaker handshaker;
    private ScheduledFuture<?> handshakeTimeoutFuture;
    private ChannelPromise handshakeCompleted;

    private WebSocketClientProtocolHandler(String address, String path, String subprotocol, HttpHeaders headers, boolean mask, boolean expectMaskedFrames, boolean allowMaskMismatch, int maxFramePayloadLength, long handshakeTimeoutMillis, @Nullable WebSocketCallbacksHandler webSocketHandler) {
        this.address = address;
        this.path = path;
        this.subprotocol = subprotocol;
        this.headers = headers;
        this.mask = mask;
        this.expectMaskedFrames = expectMaskedFrames;
        this.allowMaskMismatch = allowMaskMismatch;
        this.maxFramePayloadLength = maxFramePayloadLength;
        this.handshakeTimeoutMillis = handshakeTimeoutMillis;
        this.webSocketHandler = webSocketHandler;
    }

    public static Builder create() {
        return new Builder();
    }

    public <T extends WebSocketCallbacksHandler> T webSocketHandler() {
        return (T)this.webSocketHandler;
    }

    public ChannelFuture handshakeCompleted() {
        ChannelPromise completed = this.handshakeCompleted;
        if (completed == null) {
            throw new IllegalStateException("handshakeCompleted() must be called after handlerAdded()");
        }
        return completed;
    }

    public boolean isSharable() {
        return false;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.handshakeCompleted = ctx.newPromise();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        WebSocketClientHandshaker h = this.handshaker = new WebSocketClientHandshaker(WebSocketClientProtocolHandler.uri(ctx, this.address, this.path), this.subprotocol, this.headers, this.maxFramePayloadLength, this.mask, this.expectMaskedFrames, this.allowMaskMismatch);
        this.startHandshakeTimeout(ctx, this.handshakeTimeoutMillis);
        h.handshake(ctx.channel()).addListener(future -> {
            Throwable cause = future.cause();
            if (cause != null) {
                this.handshakeCompleted.tryFailure(cause);
                ctx.fireExceptionCaught(cause);
                this.cancelHandshakeTimeout();
            } else {
                ctx.fireUserEventTriggered((Object)WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_ISSUED);
            }
        });
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.cancelHandshakeTimeout();
        ChannelPromise completed = this.handshakeCompleted;
        if (!completed.isDone()) {
            completed.tryFailure((Throwable)new ClosedChannelException());
        }
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ctx.close();
        super.exceptionCaught(ctx, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpResponse) {
            FullHttpResponse response = (FullHttpResponse)msg;
            try {
                this.completeHandshake(ctx, response);
            }
            finally {
                response.release();
            }
            return;
        }
        super.channelRead(ctx, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeHandshake(ChannelHandlerContext ctx, FullHttpResponse response) {
        WebSocketClientHandshaker h = this.handshaker;
        if (h == null) {
            throw new IllegalStateException("Unexpected http response after http1 websocket handshake completion");
        }
        try {
            h.finishHandshake(ctx.channel(), response);
            this.handshaker = null;
        }
        catch (Exception e) {
            this.handshakeCompleted.tryFailure((Throwable)e);
            if (!(e instanceof WebSocketHandshakeException)) {
                ctx.fireExceptionCaught((Throwable)e);
            }
            ctx.close();
            return;
        }
        finally {
            this.cancelHandshakeTimeout();
        }
        ctx.pipeline().remove((ChannelHandler)this);
        WebSocketCallbacksHandler handler = this.webSocketHandler;
        if (handler != null) {
            WebSocketCallbacksHandler.exchange(ctx, handler);
        }
        this.handshakeCompleted.trySuccess();
        ctx.fireUserEventTriggered((Object)WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_COMPLETE);
    }

    private void startHandshakeTimeout(ChannelHandlerContext ctx, long timeoutMillis) {
        this.handshakeTimeoutFuture = ctx.executor().schedule(() -> {
            this.handshakeTimeoutFuture = null;
            ChannelPromise handshake = this.handshakeCompleted;
            if (!handshake.isDone() && handshake.tryFailure((Throwable)new WebSocketClientHandshakeException("websocket handshake timeout after " + this.handshakeTimeoutMillis + " millis"))) {
                ctx.flush();
                ctx.fireUserEventTriggered((Object)WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_TIMEOUT);
                ctx.close();
            }
        }, timeoutMillis, TimeUnit.MILLISECONDS);
    }

    private void cancelHandshakeTimeout() {
        ScheduledFuture<?> timeoutFuture = this.handshakeTimeoutFuture;
        if (timeoutFuture != null) {
            this.handshakeTimeoutFuture = null;
            timeoutFuture.cancel(true);
        }
    }

    private static URI uri(ChannelHandlerContext ctx, String address, String path) {
        String url;
        String scheme;
        String string = scheme = ctx.pipeline().get(SslHandler.class) != null ? "wss://" : "ws://";
        if (address != null) {
            url = scheme + address;
        } else {
            SocketAddress socketAddress = ctx.channel().remoteAddress();
            if (socketAddress instanceof InetSocketAddress) {
                InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
                url = scheme + inetSocketAddress.getHostString() + ":" + inetSocketAddress.getPort() + path;
            } else {
                throw new IllegalArgumentException("SocketAddress: " + socketAddress + " is not InetSocketAddress");
            }
        }
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("uri syntax error: " + url, e);
        }
    }

    public static final class Builder {
        private static final boolean EXPECT_MASKED_FRAMES = false;
        private String path = "/";
        private String address;
        private String subprotocol;
        private HttpHeaders headers;
        private boolean mask = true;
        private boolean allowMaskMismatch = true;
        private int maxFramePayloadLength = 65535;
        private long handshakeTimeoutMillis = 15000L;
        private WebSocketCallbacksHandler webSocketHandler;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder address(String address) {
            this.address = Objects.requireNonNull(address, "address");
            return this;
        }

        public Builder path(String path) {
            this.path = Objects.requireNonNull(path, "path");
            this.address = null;
            return this;
        }

        public Builder subprotocol(@Nullable String subprotocol) {
            this.subprotocol = subprotocol;
            return this;
        }

        public Builder headers(@Nullable HttpHeaders headers) {
            this.headers = headers;
            return this;
        }

        public Builder mask(boolean mask) {
            this.mask = mask;
            return this;
        }

        public Builder allowMaskMismatch(boolean allowMaskMismatch) {
            this.allowMaskMismatch = allowMaskMismatch;
            return this;
        }

        public Builder maxFramePayloadLength(int maxFramePayloadLength) {
            this.maxFramePayloadLength = Builder.requirePositive(maxFramePayloadLength, "maxFramePayloadLength");
            return this;
        }

        public Builder handshakeTimeoutMillis(long handshakeTimeoutMillis) {
            this.handshakeTimeoutMillis = Builder.requirePositive(handshakeTimeoutMillis, "handshakeTimeoutMillis");
            return this;
        }

        public Builder webSocketHandler(@Nullable WebSocketCallbacksHandler webSocketHandler) {
            this.webSocketHandler = webSocketHandler;
            return this;
        }

        public WebSocketClientProtocolHandler build() {
            int maxPayloadLength = this.maxFramePayloadLength;
            boolean maskMismatch = this.allowMaskMismatch;
            WebSocketProtocol.validateDecoderConfig(maxPayloadLength, false, false, false, maskMismatch);
            return new WebSocketClientProtocolHandler(this.address, this.path, this.subprotocol, this.headers, this.mask, false, maskMismatch, maxPayloadLength, this.handshakeTimeoutMillis, this.webSocketHandler);
        }

        private static int requirePositive(int val, String desc) {
            if (val <= 0) {
                throw new IllegalArgumentException(desc + " must be positive, provided: " + val);
            }
            return val;
        }

        private static long requirePositive(long val, String desc) {
            if (val <= 0L) {
                throw new IllegalArgumentException(desc + " must be positive, provided: " + val);
            }
            return val;
        }
    }
}

