/*
 * Decompiled with CFR 0.152.
 */
package com.jauntsdn.netty.handler.codec.http.websocketx;

import com.jauntsdn.netty.handler.codec.http.websocketx.WebSocketCallbacksFrameDecoder;
import com.jauntsdn.netty.handler.codec.http.websocketx.WebSocketFrameFactory;
import com.jauntsdn.netty.handler.codec.http.websocketx.WebSocketFrameListener;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;

abstract class WebSocketDecoder
implements WebSocketCallbacksFrameDecoder {
    static final int STATE_NON_PARTIAL = 0;
    static final int STATE_PARTIAL_PREFIX = 1;
    static final int STATE_PARTIAL_MASK = 2;
    static final int STATE_PARTIAL_PAYLOAD = 3;
    static final int STATE_CLOSED_INBOUND = 4;
    WebSocketFrameListener webSocketFrameListener;

    WebSocketDecoder() {
    }

    abstract void decode(ChannelHandlerContext var1, ByteBuf var2);

    abstract WebSocketFrameFactory frameFactory();

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        WebSocketFrameListener listener = this.webSocketFrameListener;
        if (listener != null) {
            listener.onClose(ctx);
        }
        ctx.fireChannelInactive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)msg;
            try {
                this.decode(ctx, buf);
            }
            finally {
                buf.release();
            }
            return;
        }
        ctx.fireChannelRead(msg);
    }

    @Override
    public void frameListener(ChannelHandlerContext ctx, WebSocketFrameListener webSocketFrameListener, WebSocketFrameFactory frameFactory) {
        this.webSocketFrameListener = webSocketFrameListener;
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        WebSocketFrameListener listener = this.webSocketFrameListener;
        if (listener != null) {
            listener.onChannelReadComplete(ctx);
        } else {
            ctx.fireChannelReadComplete();
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        WebSocketFrameListener listener = this.webSocketFrameListener;
        if (listener != null) {
            listener.onUserEventTriggered(ctx, evt);
        } else {
            ctx.fireUserEventTriggered(evt);
        }
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) {
        WebSocketFrameListener listener = this.webSocketFrameListener;
        if (listener != null) {
            listener.onChannelWritabilityChanged(ctx);
        } else {
            ctx.fireChannelWritabilityChanged();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        WebSocketFrameListener listener = this.webSocketFrameListener;
        if (listener != null) {
            listener.onExceptionCaught(ctx, cause);
        } else {
            ctx.fireExceptionCaught(cause);
        }
    }

    abstract void closeInbound();

    final void onFrameRead(ChannelHandlerContext ctx, boolean finFlag, int opcode, ByteBuf payload) {
        this.webSocketFrameListener.onChannelRead(ctx, finFlag, 0, opcode, payload);
    }

    public void channelRegistered(ChannelHandlerContext ctx) {
        ctx.fireChannelRegistered();
    }

    public void channelUnregistered(ChannelHandlerContext ctx) {
        ctx.fireChannelUnregistered();
    }

    public void channelActive(ChannelHandlerContext ctx) {
        ctx.fireChannelActive();
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
    }
}

