/*
 * Decompiled with CFR 0.152.
 */
package com.jauntsdn.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.CharsetUtil;

public interface WebSocketFrameListener {
    public void onChannelRead(ChannelHandlerContext var1, boolean var2, int var3, int var4, ByteBuf var5);

    default public void onChannelReadComplete(ChannelHandlerContext ctx) {
        ctx.fireChannelReadComplete();
    }

    default public void onUserEventTriggered(ChannelHandlerContext ctx, Object evt) {
        ctx.fireUserEventTriggered(evt);
    }

    default public void onChannelWritabilityChanged(ChannelHandlerContext ctx) {
        ctx.fireChannelWritabilityChanged();
    }

    default public void onExceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ctx.fireExceptionCaught(cause);
    }

    default public void onOpen(ChannelHandlerContext ctx) {
    }

    default public void onClose(ChannelHandlerContext ctx) {
    }

    public static final class Utf8FrameValidator {
        public static final int UTF8_VALIDATION_ERROR_CODE = 1007;
        public static final String UTF8_VALIDATION_ERROR_MESSAGE = "inbound text frame with non-utf8 contents";
        private static final int UTF8_ACCEPT = 0;
        private static final int UTF8_REJECT = 12;
        private static final byte[] TYPES = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 10, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 11, 6, 6, 6, 5, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
        private static final byte[] STATES = new byte[]{0, 12, 24, 36, 60, 96, 84, 12, 12, 12, 48, 72, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 0, 12, 12, 12, 12, 12, 0, 12, 0, 12, 12, 12, 24, 12, 12, 12, 12, 12, 24, 12, 24, 12, 12, 12, 12, 12, 12, 12, 12, 12, 24, 12, 12, 12, 12, 12, 24, 12, 12, 12, 12, 12, 12, 12, 24, 12, 12, 12, 12, 12, 12, 12, 12, 12, 36, 12, 36, 12, 12, 12, 36, 12, 12, 12, 12, 12, 36, 12, 36, 12, 12, 12, 36, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
        int state = 0;
        int codep;

        private Utf8FrameValidator() {
        }

        public static Utf8FrameValidator create() {
            return new Utf8FrameValidator();
        }

        public boolean validateTextFrame(ByteBuf buffer) {
            this.checkUtf8(buffer);
            int st = this.state;
            this.state = 0;
            this.codep = 0;
            return st == 0;
        }

        public boolean validateTextFragmentStart(ByteBuf buffer) {
            this.checkUtf8(buffer);
            return this.state != 12;
        }

        public boolean validateFragmentContinuation(ByteBuf buffer) {
            return this.validateTextFragmentStart(buffer);
        }

        public boolean validateFragmentEnd(ByteBuf buffer) {
            return this.validateTextFrame(buffer);
        }

        private void checkUtf8(ByteBuf buffer) {
            int readableBytes = buffer.readableBytes();
            int from = buffer.readerIndex();
            int to = from + readableBytes;
            boolean cont = true;
            int step = 8;
            while (to - from >= step) {
                long bytes = buffer.getLong(from);
                if ((bytes & 0x8080808080808080L) != 0L) {
                    byte b;
                    for (int i = 0; i < step && (cont = this.checkUtf8(b = (byte)(bytes >> 8 * (step - (i + 1)) & 0xFFL))); ++i) {
                    }
                }
                from += step;
            }
            if (cont) {
                step = 4;
                while (to - from >= step) {
                    int bytes = buffer.getInt(from);
                    if ((bytes & 0x80808080) != 0) {
                        byte b;
                        for (int i = 0; i < step && (cont = this.checkUtf8(b = (byte)(bytes >> 8 * (step - (i + 1)) & 0xFF))); ++i) {
                        }
                    }
                    from += step;
                }
            }
            if (cont) {
                byte b;
                while (to - from >= 1 && (cont = this.checkUtf8(b = buffer.getByte(from)))) {
                    ++from;
                }
            }
        }

        private boolean checkUtf8(byte bufferByte) {
            byte type = TYPES[bufferByte & 0xFF];
            int st = this.state;
            this.codep = st != 0 ? bufferByte & 0x3F | this.codep << 6 : 255 >> type & bufferByte;
            st = this.state = STATES[st + type];
            return st != 12;
        }
    }

    public static final class CloseFramePayload {
        private CloseFramePayload() {
        }

        public static int statusCode(ByteBuf payload) {
            if (payload.readableBytes() < 2) {
                return -1;
            }
            return payload.getShort(0);
        }

        public static String reason(ByteBuf payload) {
            if (payload.readableBytes() <= 2) {
                return "";
            }
            return payload.toString(2, payload.readableBytes() - 2, CharsetUtil.UTF_8);
        }
    }
}

