/*
 * Decompiled with CFR 0.152.
 */
package com.jauntsdn.netty.handler.codec.http.websocketx;

import com.jauntsdn.netty.handler.codec.http.websocketx.WebSocketCallbacksFrameDecoder;
import com.jauntsdn.netty.handler.codec.http.websocketx.WebSocketCallbacksFrameEncoder;
import com.jauntsdn.netty.handler.codec.http.websocketx.WebSocketDecoder;
import com.jauntsdn.netty.handler.codec.http.websocketx.WebSocketFrameFactory;
import com.jauntsdn.netty.handler.codec.http.websocketx.WebSocketFrameListener;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.CorruptedWebSocketFrameException;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import io.netty.util.concurrent.GenericFutureListener;

public final class WebSocketProtocol {
    public static final byte OPCODE_CONT = 0;
    public static final byte OPCODE_TEXT = 1;
    public static final byte OPCODE_BINARY = 2;
    public static final byte OPCODE_CLOSE = 8;
    public static final byte OPCODE_PING = 9;
    public static final byte OPCODE_PONG = 10;
    static final int VALIDATION_RESULT_INVALID = -128;
    static final int VALIDATION_RESULT_NON_FRAGMENTING = -1;

    static int validate(ChannelHandlerContext ctx, WebSocketDecoder webSocketDecoder, int flags, int code, int frameLength, int fragmentedTotalLength, int maxFramePayloadLength) {
        switch (flags) {
            case 128: {
                if (fragmentedTotalLength >= 0) {
                    if (code > 0 && code < 8) {
                        WebSocketProtocol.close(ctx, webSocketDecoder, WebSocketCloseStatus.PROTOCOL_ERROR, "non-fragmented frame in fragmented sequence");
                        return -128;
                    }
                    if (code == 0) {
                        int newFragmentedTotalLength = fragmentedTotalLength + frameLength;
                        if (newFragmentedTotalLength > maxFramePayloadLength) {
                            WebSocketProtocol.close(ctx, webSocketDecoder, WebSocketCloseStatus.MESSAGE_TOO_BIG, "fragmented frame is too big: " + newFragmentedTotalLength + " exceeds limit: " + maxFramePayloadLength);
                            return -128;
                        }
                        return -1;
                    }
                    if (frameLength <= 125) break;
                    WebSocketProtocol.close(ctx, webSocketDecoder, WebSocketCloseStatus.MESSAGE_TOO_BIG, "control frame " + code + " is too big: " + frameLength + " exceeds limit: 125");
                    return -128;
                }
                if (code == 0) {
                    WebSocketProtocol.close(ctx, webSocketDecoder, WebSocketCloseStatus.PROTOCOL_ERROR, "fragmented frame " + code + " in non-fragmented sequence");
                    return -128;
                }
                if (code >= 8) {
                    if (frameLength <= 125) break;
                    WebSocketProtocol.close(ctx, webSocketDecoder, WebSocketCloseStatus.MESSAGE_TOO_BIG, "control frame " + code + " is too big: " + frameLength + " exceeds limit: 125");
                    return -128;
                }
                if (frameLength <= maxFramePayloadLength) break;
                WebSocketProtocol.close(ctx, webSocketDecoder, WebSocketCloseStatus.MESSAGE_TOO_BIG, "non-fragmented frame is too big: " + frameLength + " exceeds limit: " + maxFramePayloadLength);
                return -128;
            }
            case 0: {
                if (code >= 8) {
                    WebSocketProtocol.close(ctx, webSocketDecoder, WebSocketCloseStatus.PROTOCOL_ERROR, "fragmented control frame: " + code);
                    return -128;
                }
                if (code > 0) {
                    if (fragmentedTotalLength >= 0) {
                        WebSocketProtocol.close(ctx, webSocketDecoder, WebSocketCloseStatus.PROTOCOL_ERROR, "fragmentation start while fragmenting already: " + code);
                        return -128;
                    }
                    if (frameLength > maxFramePayloadLength) {
                        WebSocketProtocol.close(ctx, webSocketDecoder, WebSocketCloseStatus.MESSAGE_TOO_BIG, "non-fragmented frame is too big: " + frameLength + " exceeds limit: " + maxFramePayloadLength);
                        return -128;
                    }
                    return frameLength;
                }
                if (fragmentedTotalLength < 0) {
                    WebSocketProtocol.close(ctx, webSocketDecoder, WebSocketCloseStatus.PROTOCOL_ERROR, "fragmentation continuation while not in fragmenting state: " + code);
                    return -128;
                }
                int newFragmentedLength = fragmentedTotalLength + frameLength;
                if (newFragmentedLength > maxFramePayloadLength) {
                    WebSocketProtocol.close(ctx, webSocketDecoder, WebSocketCloseStatus.MESSAGE_TOO_BIG, "fragmented frame is too big: " + frameLength + " exceeds limit: " + maxFramePayloadLength);
                    return -128;
                }
                return newFragmentedLength;
            }
            default: {
                WebSocketProtocol.close(ctx, webSocketDecoder, WebSocketCloseStatus.PROTOCOL_ERROR, "extensions are not supported: " + Integer.toBinaryString(flags));
                return -128;
            }
        }
        return fragmentedTotalLength;
    }

    static void close(ChannelHandlerContext ctx, WebSocketDecoder webSocketDecoder, WebSocketCloseStatus status, String msg) {
        WebSocketFrameFactory frameFactory = webSocketDecoder.frameFactory();
        WebSocketFrameListener frameListener = webSocketDecoder.webSocketFrameListener;
        ByteBuf closeFrame = frameFactory.mask(frameFactory.createCloseFrame(ctx.alloc(), status.code(), msg));
        ctx.writeAndFlush((Object)closeFrame).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        webSocketDecoder.closeInbound();
        frameListener.onExceptionCaught(ctx, (Throwable)new CorruptedWebSocketFrameException(status, msg));
    }

    public static void validateDecoderConfig(int maxFramePayloadLength, boolean allowExtensions, boolean withUtf8Validator, boolean expectMaskedFrames, boolean allowMaskMismatch) {
        if (maxFramePayloadLength < 125 || maxFramePayloadLength > 65535) {
            throw new IllegalArgumentException("maxFramePayloadLength must be in range [125; 65535]");
        }
        if (allowExtensions) {
            throw new IllegalArgumentException("extensions are not supported");
        }
        if (withUtf8Validator) {
            throw new IllegalArgumentException("text frames UTF8 validation is not suppported");
        }
        if (!allowMaskMismatch) {
            if (expectMaskedFrames) {
                throw new IllegalArgumentException("Enforcing strictly masked frames is not supported");
            }
            if (maxFramePayloadLength > 125) {
                throw new IllegalArgumentException("strictly unmasked frames may be enforced for maxFramePayloadLength<=125 only");
            }
        }
    }

    public static WebSocketDecoderConfig validateDecoderConfig(WebSocketDecoderConfig webSocketDecoderConfig) {
        WebSocketProtocol.validateDecoderConfig(webSocketDecoderConfig.maxFramePayloadLength(), webSocketDecoderConfig.allowExtensions(), webSocketDecoderConfig.withUTF8Validator(), webSocketDecoderConfig.expectMaskedFrames(), webSocketDecoderConfig.allowMaskMismatch());
        return webSocketDecoderConfig;
    }

    private WebSocketProtocol() {
    }

    @Deprecated
    public static WebSocketFrameDecoder frameDecoder(int maxFramePayloadLength, boolean expectMaskedFrames, boolean allowMaskMismatch) {
        return WebSocketCallbacksFrameDecoder.frameDecoder(maxFramePayloadLength, expectMaskedFrames, allowMaskMismatch);
    }

    public static WebSocketFrameDecoder frameDecoder(boolean maskPayload, int maxFramePayloadLength, boolean expectMaskedFrames, boolean allowMaskMismatch) {
        return WebSocketCallbacksFrameDecoder.frameDecoder(maskPayload, maxFramePayloadLength, expectMaskedFrames, allowMaskMismatch);
    }

    public static WebSocketFrameEncoder frameEncoder(boolean expectMaskedFrames) {
        return WebSocketCallbacksFrameEncoder.frameEncoder(expectMaskedFrames);
    }
}

