/*
 * Decompiled with CFR 0.152.
 */
package com.jauntsdn.netty.handler.codec.http.websocketx;

import com.jauntsdn.netty.handler.codec.http.websocketx.WebSocketCallbacksFrameDecoder;
import com.jauntsdn.netty.handler.codec.http.websocketx.WebSocketCallbacksFrameEncoder;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker13;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.ssl.SslHandler;
import java.util.Objects;

public final class WebSocketServerHandshaker
extends WebSocketServerHandshaker13 {
    WebSocketServerHandshaker(String webSocketURL, String subprotocols, WebSocketDecoderConfig webSocketDecoderConfig) {
        super(Objects.requireNonNull(webSocketURL, "webSocketURL"), subprotocols, webSocketDecoderConfig);
    }

    protected WebSocketFrameDecoder newWebsocketDecoder() {
        WebSocketDecoderConfig decoderConfig = this.decoderConfig();
        return WebSocketCallbacksFrameDecoder.frameDecoder(false, decoderConfig.maxFramePayloadLength(), decoderConfig.expectMaskedFrames(), decoderConfig.allowMaskMismatch());
    }

    protected WebSocketFrameEncoder newWebSocketEncoder() {
        return WebSocketCallbacksFrameEncoder.frameEncoder(false);
    }

    public static final class Factory {
        private final String path;
        private final String subprotocols;
        private final WebSocketDecoderConfig decoderConfig;

        Factory(String path, String subprotocols, WebSocketDecoderConfig decoderConfig) {
            this.path = Objects.requireNonNull(path, "path");
            this.subprotocols = subprotocols;
            this.decoderConfig = Objects.requireNonNull(decoderConfig, "decoderConfig");
        }

        public WebSocketServerHandshaker newHandshaker(ChannelHandlerContext ctx, HttpRequest req) {
            String version = req.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION);
            if (version != null && version.equals(WebSocketVersion.V13.toHttpHeaderValue())) {
                return new WebSocketServerHandshaker(Factory.webSocketUrl(ctx.pipeline(), req, this.path), this.subprotocols, this.decoderConfig);
            }
            return null;
        }

        private static String webSocketUrl(ChannelPipeline cp, HttpRequest req, String path) {
            String protocol = "ws";
            if (cp.get(SslHandler.class) != null) {
                protocol = "wss";
            }
            String host = req.headers().get((CharSequence)HttpHeaderNames.HOST);
            return protocol + "://" + host + path;
        }
    }
}

