/*
 * Decompiled with CFR 0.152.
 */
package com.jauntsdn.netty.handler.codec.http.websocketx;

import com.jauntsdn.netty.handler.codec.http.websocketx.WebSocketCallbacksHandler;
import com.jauntsdn.netty.handler.codec.http.websocketx.WebSocketProtocol;
import com.jauntsdn.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.ClosedChannelException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public final class WebSocketServerProtocolHandler
extends ChannelInboundHandlerAdapter {
    private final String path;
    private final String subprotocols;
    private final WebSocketDecoderConfig decoderConfig;
    private final long handshakeTimeoutMillis;
    private final WebSocketCallbacksHandler webSocketHandler;
    private ChannelPromise handshakeCompleted;

    public static Builder create() {
        return Builder.create();
    }

    private WebSocketServerProtocolHandler(String path, String subprotocols, WebSocketDecoderConfig webSocketDecoderConfig, long handshakeTimeoutMillis, @Nullable WebSocketCallbacksHandler webSocketHandler) {
        this.path = path;
        this.subprotocols = subprotocols;
        this.decoderConfig = webSocketDecoderConfig;
        this.handshakeTimeoutMillis = handshakeTimeoutMillis;
        this.webSocketHandler = webSocketHandler;
    }

    public <T extends WebSocketCallbacksHandler> T webSocketHandler() {
        return (T)this.webSocketHandler;
    }

    public ChannelFuture handshakeCompleted() {
        ChannelPromise completed = this.handshakeCompleted;
        if (completed == null) {
            throw new IllegalStateException("handshakeCompleted() must be called after channelRegistered()");
        }
        return completed;
    }

    public boolean isSharable() {
        return false;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.handshakeCompleted = ctx.newPromise();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ChannelPromise completed = this.handshakeCompleted;
        if (!completed.isDone()) {
            completed.tryFailure((Throwable)new ClosedChannelException());
        }
        super.channelInactive(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpRequest) {
            FullHttpRequest request = (FullHttpRequest)msg;
            if (!this.isWebSocketPath((HttpRequest)request)) {
                super.channelRead(ctx, msg);
                return;
            }
            try {
                this.completeHandshake(ctx, (HttpRequest)request);
            }
            finally {
                request.release();
            }
            return;
        }
        super.channelRead(ctx, msg);
    }

    private boolean isWebSocketPath(HttpRequest req) {
        try {
            URI requestUri = new URI(req.uri());
            return this.path.equals(requestUri.getPath());
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    private void completeHandshake(ChannelHandlerContext ctx, HttpRequest request) {
        if (!HttpMethod.GET.equals((Object)request.method())) {
            ctx.writeAndFlush((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST, Unpooled.EMPTY_BUFFER)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        WebSocketServerHandshaker.Factory handshakerFactory = new WebSocketServerHandshaker.Factory(this.path, this.subprotocols, this.decoderConfig);
        WebSocketServerHandshaker handshaker = handshakerFactory.newHandshaker(ctx, request);
        if (handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
        } else {
            ChannelFuture handshakeFuture;
            ChannelPromise handshake = this.handshakeCompleted;
            String uri = request.uri();
            HttpHeaders headers = request.headers();
            try {
                handshakeFuture = handshaker.handshake(ctx.channel(), request);
            }
            catch (Exception e) {
                this.handleHandshakeResult(ctx, handshake, uri, headers, handshaker.selectedSubprotocol(), e);
                return;
            }
            ScheduledFuture<?> timeout = WebSocketServerProtocolHandler.startHandshakeTimeout(ctx, this.handshakeTimeoutMillis, handshake);
            handshakeFuture.addListener(future -> {
                if (timeout != null) {
                    timeout.cancel(true);
                }
                this.handleHandshakeResult(ctx, handshake, uri, headers, handshaker.selectedSubprotocol(), future.cause());
            });
        }
    }

    private void handleHandshakeResult(ChannelHandlerContext ctx, ChannelPromise handshake, String uri, HttpHeaders headers, String subprotocol, Throwable cause) {
        if (cause != null) {
            handshake.tryFailure(cause);
            if (cause instanceof WebSocketHandshakeException) {
                String errorMessage = cause.getMessage();
                ByteBuf errorContent = errorMessage == null || errorMessage.isEmpty() ? Unpooled.EMPTY_BUFFER : ByteBufUtil.writeUtf8((ByteBufAllocator)ctx.alloc(), (CharSequence)errorMessage);
                DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST, errorContent);
                ctx.channel().writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            } else {
                ctx.fireExceptionCaught(cause);
                ctx.close();
            }
        } else {
            WebSocketCallbacksHandler handler = this.webSocketHandler;
            if (handler != null) {
                WebSocketCallbacksHandler.exchange(ctx, handler);
            }
            handshake.trySuccess();
            ChannelPipeline p = ctx.channel().pipeline();
            p.fireUserEventTriggered((Object)WebSocketServerProtocolHandler.ServerHandshakeStateEvent.HANDSHAKE_COMPLETE);
            p.fireUserEventTriggered((Object)new WebSocketServerProtocolHandler.HandshakeComplete(uri, headers, subprotocol));
        }
        ctx.pipeline().remove((ChannelHandler)this);
    }

    static ScheduledFuture<?> startHandshakeTimeout(ChannelHandlerContext ctx, long handshakeTimeoutMillis, ChannelPromise handshake) {
        if (handshakeTimeoutMillis > 0L) {
            return ctx.executor().schedule(() -> {
                if (!handshake.isDone() && handshake.tryFailure((Throwable)new WebSocketServerHandshakeException("websocket handshake timeout after " + handshakeTimeoutMillis + " millis"))) {
                    ctx.flush();
                    ctx.fireUserEventTriggered((Object)WebSocketServerProtocolHandler.ServerHandshakeStateEvent.HANDSHAKE_TIMEOUT);
                    ctx.close();
                }
            }, handshakeTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        return null;
    }

    public static final class Builder {
        private static final WebSocketDecoderConfig DEFAULT_DECODER_CONFIG = WebSocketDecoderConfig.newBuilder().maxFramePayloadLength(65535).allowExtensions(false).expectMaskedFrames(true).allowMaskMismatch(true).withUTF8Validator(false).build();
        private String path = "/";
        private String subprotocols;
        private WebSocketDecoderConfig decoderConfig = DEFAULT_DECODER_CONFIG;
        private WebSocketCallbacksHandler webSocketCallbacksHandler;
        private long handshakeTimeoutMillis;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder path(String path) {
            this.path = Objects.requireNonNull(path, "path");
            return this;
        }

        public Builder subprotocols(@Nullable String subprotocols) {
            this.subprotocols = subprotocols;
            return this;
        }

        public Builder decoderConfig(WebSocketDecoderConfig decoderConfig) {
            this.decoderConfig = WebSocketProtocol.validateDecoderConfig(Objects.requireNonNull(decoderConfig, "decoderConfig"));
            return this;
        }

        public Builder handshakeTimeoutMillis(long handshakeTimeoutMillis) {
            this.handshakeTimeoutMillis = Builder.requirePositive(handshakeTimeoutMillis, "handshakeTimeoutMillis");
            return this;
        }

        public Builder webSocketCallbacksHandler(@Nullable WebSocketCallbacksHandler webSocketHandler) {
            this.webSocketCallbacksHandler = webSocketHandler;
            return this;
        }

        public WebSocketServerProtocolHandler build() {
            return new WebSocketServerProtocolHandler(this.path, this.subprotocols, this.decoderConfig, this.handshakeTimeoutMillis, this.webSocketCallbacksHandler);
        }

        private static long requirePositive(long val, String desc) {
            if (val <= 0L) {
                throw new IllegalArgumentException(desc + " must be positive, provided: " + val);
            }
            return val;
        }
    }
}

