/*
 * Decompiled with CFR 0.152.
 */
package com.javabaas.javasdk;

import com.javabaas.javasdk.JBApp;
import com.javabaas.javasdk.JBConfig;
import com.javabaas.javasdk.JBException;
import com.javabaas.javasdk.JBHttpClient;
import com.javabaas.javasdk.JBStatus;
import com.javabaas.javasdk.JBUtils;
import com.javabaas.javasdk.annotation.HookEvent;
import com.javabaas.javasdk.callback.JBStatusCallback;
import com.javabaas.javasdk.callback.JBUserSessionTokenErrorCallback;
import com.javabaas.javasdk.cloud.CloudListener;
import com.javabaas.javasdk.cloud.CloudRequest;
import com.javabaas.javasdk.cloud.CloudResponse;
import com.javabaas.javasdk.cloud.HookListener;
import com.javabaas.javasdk.cloud.HookRequest;
import com.javabaas.javasdk.cloud.HookResponse;
import com.javabaas.javasdk.cloud.HookSetting;
import com.javabaas.javasdk.cloud.JBRequest;
import com.javabaas.javasdk.cloud.JBResponse;
import com.javabaas.javasdk.cloud.ScannerEngine;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class JB {
    private static final JB INSTANCE = new JB();
    private JBUserSessionTokenErrorCallback jbUserSessionTokenErrorCallback;
    private JBConfig config;
    private final ScannerEngine engine = new ScannerEngine();
    private HashMap<String, CloudListener> cloudListeners = new LinkedHashMap<String, CloudListener>();
    private HashMap<String, HookListener> hookListeners = new LinkedHashMap<String, HookListener>();

    private JB() {
        this.config = new JBConfig();
    }

    public HashMap<String, CloudListener> getCloudListeners() {
        return this.cloudListeners;
    }

    public HashMap<String, HookListener> getHookListeners() {
        return this.hookListeners;
    }

    public static void init(String remote, String appId, String key) {
        JB.initConfig(remote, appId, key, null, null, "cloud");
        JB.updateAdjustTime();
    }

    public static void init(String remote, String appId, String key, String plat) {
        JB.initConfig(remote, appId, key, null, null, plat);
        JB.updateAdjustTime();
    }

    public static void init(String remote, String appId, String key, String plat, JBUserSessionTokenErrorCallback callback) {
        JB.initConfig(remote, appId, key, null, null, plat);
        JB.updateAdjustTime();
        JB.INSTANCE.jbUserSessionTokenErrorCallback = callback;
    }

    public static void initAdmin(String remote, String adminKey) {
        JB.initConfig(remote, null, null, null, adminKey, "cloud");
    }

    public static void initMaster(String remote, String appId, String masterKey) {
        JB.initConfig(remote, appId, null, masterKey, null, "cloud");
    }

    public static void initHttpTimeout(long connectTimeout, long writeTimeout, long readTimeout) {
        connectTimeout = connectTimeout <= 0L ? 10L : connectTimeout;
        writeTimeout = writeTimeout <= 0L ? 10L : writeTimeout;
        readTimeout = readTimeout <= 0L ? 10L : readTimeout;
        JBHttpClient.setTimeout(connectTimeout, writeTimeout, readTimeout);
    }

    public static void useApp(JBApp app) {
        if (app == null) {
            JB.removeAppConfig();
        } else {
            JB.initConfig(null, app.getId(), app.getKey(), app.getMasterKey(), null, "cloud");
            JB.updateAdjustTime();
        }
    }

    public static JB getInstance() {
        return INSTANCE;
    }

    public JBConfig getConfig() {
        return this.config;
    }

    public JBUserSessionTokenErrorCallback getJBUserSessionTokenErrorCallback() {
        return this.jbUserSessionTokenErrorCallback;
    }

    public void addListeners(Object listeners, Class<?> listenersClass) {
        this.engine.scan(INSTANCE, listeners, listenersClass);
    }

    public void addCloudListener(String name, CloudListener listener) {
        this.cloudListeners.put(name, listener);
    }

    public void addHookListener(String name, HookEvent event, HookListener listener) {
        this.hookListeners.put(HookSetting.hookName(name, event), listener);
    }

    public static JBResponse onRequest(String requestType, String body) throws Throwable {
        if (requestType.equals(JBRequest.REQUEST_CLOUD)) {
            CloudRequest cloudRequest = JBUtils.readValue(body, CloudRequest.class);
            return JB.onCloudRequest(cloudRequest);
        }
        if (requestType.equals(JBRequest.REQUEST_HOOK)) {
            HookRequest hookRequest = JBUtils.readValue(body, HookRequest.class);
            return JB.onHookRequest(hookRequest);
        }
        return null;
    }

    private static CloudResponse onCloudRequest(CloudRequest cloudRequest) throws Throwable {
        CloudListener listener = JB.INSTANCE.cloudListeners.get(cloudRequest.getName());
        return listener.onCloud(cloudRequest);
    }

    private static HookResponse onHookRequest(HookRequest hookRequest) throws Throwable {
        HookListener listener = JB.INSTANCE.hookListeners.get(HookSetting.hookName(hookRequest.getName(), hookRequest.getEvent()));
        return listener.onHook(hookRequest);
    }

    private static void initConfig(String remote, String appId, String key, String masterKey, String adminKey, String plat) {
        if (!JBUtils.isEmpty(remote)) {
            String string = JB.INSTANCE.config.remote = remote.endsWith("/") ? remote : remote + "/";
        }
        if (!JBUtils.isEmpty(appId)) {
            JB.INSTANCE.config.appId = appId;
        }
        if (!JBUtils.isEmpty(key)) {
            JB.INSTANCE.config.key = key;
        }
        if (!JBUtils.isEmpty(masterKey)) {
            JB.INSTANCE.config.masterKey = masterKey;
        }
        if (!JBUtils.isEmpty(adminKey)) {
            JB.INSTANCE.config.adminKey = adminKey;
        }
        if (!JBUtils.isEmpty(plat)) {
            JB.INSTANCE.config.plat = plat;
        }
        JB.INSTANCE.config.finishInit = true;
    }

    private static void removeAppConfig() {
        JB.INSTANCE.config.masterKey = null;
        JB.INSTANCE.config.key = null;
        JB.INSTANCE.config.appId = null;
    }

    private static void updateAdjustTime() {
        final long timestamp = System.currentTimeMillis();
        JBStatus.getStatusInBackground(new JBStatusCallback(){

            @Override
            public void done(boolean success, Map<String, Object> status, JBException e) {
                long serverTime;
                if (success && status.get("time") != null && (serverTime = ((Long)status.get("time")).longValue()) > 0L) {
                    ((JB)INSTANCE).config.adjustTime = timestamp - serverTime;
                }
            }
        });
    }
}

