/*
 * Decompiled with CFR 0.152.
 */
package com.javabaas.javasdk;

import com.javabaas.javasdk.JBUser;
import java.util.HashMap;
import java.util.Map;

public class JBAcl {
    private final Map<String, Object> permissionById = new HashMap<String, Object>();
    private static String readTag = "read";
    private static String writeTag = "write";
    private static String publicTag = "*";

    public Map<String, Object> getPermissionById() {
        return this.permissionById;
    }

    public JBAcl() {
    }

    JBAcl(JBAcl right) {
        this.permissionById.putAll(right.permissionById);
    }

    public JBAcl(JBUser user) {
        this.setReadAccess(user, true);
    }

    public void setReadAccess(JBUser user, boolean allowed) {
        this.setReadAccess(user.getObjectId(), allowed);
    }

    public void setReadAccess(String userId, boolean allowed) {
        this.allowRead(allowed, userId);
    }

    public void setWriteAccess(JBUser user, boolean allowed) {
        this.setWriteAccess(user.getObjectId(), allowed);
    }

    public void setWriteAccess(String userId, boolean allowed) {
        this.allowWrite(allowed, userId);
    }

    public boolean getPublicReadAccess() {
        return this.isReadAllowed(publicTag);
    }

    public boolean getPublicWriteAccess() {
        return this.isWriteAllowed(publicTag);
    }

    public boolean getReadAccess(JBUser user) {
        return this.getReadAccess(user.getObjectId());
    }

    public boolean getReadAccess(String userId) {
        return this.isReadAllowed(userId);
    }

    public boolean getWriteAccess(JBUser user) {
        return this.getWriteAccess(user.getObjectId());
    }

    public boolean getWriteAccess(String userId) {
        return this.isWriteAllowed(userId);
    }

    public void setPublicReadAccess(boolean allowed) {
        this.allowRead(allowed, publicTag);
    }

    public void setPublicWriteAccess(boolean allowed) {
        this.allowWrite(allowed, publicTag);
    }

    Map<String, Object> getAclMap() {
        HashMap<String, Object> aclMap = new HashMap<String, Object>();
        aclMap.put("acl", this.getPermissionById());
        return aclMap;
    }

    private void allowRead(boolean allowed, String key) {
        Map<String, Object> map = this.mapForKey(key, allowed);
        if (allowed) {
            map.put(readTag, true);
        } else if (map != null) {
            map.remove(readTag);
        }
    }

    private void allowWrite(boolean allowed, String key) {
        Map<String, Object> map = this.mapForKey(key, allowed);
        if (allowed) {
            map.put(writeTag, allowed);
        } else if (map != null) {
            map.remove(writeTag);
        }
    }

    private Map<String, Object> mapForKey(String key, boolean create) {
        HashMap map = (HashMap)this.permissionById.get(key);
        if (map == null && create) {
            map = new HashMap();
            this.permissionById.put(key, map);
        }
        return map;
    }

    private boolean isReadAllowed(String key) {
        Map<String, Object> map = this.mapForKey(key, false);
        return map != null && map.get(readTag) != null && (Boolean)map.get(readTag) != false;
    }

    private boolean isWriteAllowed(String key) {
        Map<String, Object> map = this.mapForKey(key, false);
        return map != null && map.get(writeTag) != null && (Boolean)map.get(writeTag) != false;
    }
}

