/*
 * Decompiled with CFR 0.152.
 */
package com.javabaas.javasdk;

import com.javabaas.javasdk.JBClazz;
import com.javabaas.javasdk.JBCode;
import com.javabaas.javasdk.JBException;
import com.javabaas.javasdk.JBExceptionHolder;
import com.javabaas.javasdk.JBHttpClient;
import com.javabaas.javasdk.JBHttpMethod;
import com.javabaas.javasdk.JBHttpParams;
import com.javabaas.javasdk.JBResult;
import com.javabaas.javasdk.JBUtils;
import com.javabaas.javasdk.callback.JBApiStatListCallback;
import com.javabaas.javasdk.callback.JBAppExportCallback;
import com.javabaas.javasdk.callback.JBAppListCallback;
import com.javabaas.javasdk.callback.JBBooleanCallback;
import com.javabaas.javasdk.callback.JBGetAppCallback;
import com.javabaas.javasdk.callback.JBGetAppConfigItemsCallback;
import com.javabaas.javasdk.callback.JBGetConfigCallback;
import com.javabaas.javasdk.callback.JBObjectCallback;
import com.javabaas.javasdk.cloud.CloudSetting;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JBApp {
    private String id;
    private String name;
    private String key;
    private String masterKey;
    private CloudSetting cloudSetting;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getMasterKey() {
        return this.masterKey;
    }

    public void setMasterKey(String masterKey) {
        this.masterKey = masterKey;
    }

    public CloudSetting getCloudSetting() {
        return this.cloudSetting;
    }

    public void setCloudSetting(CloudSetting cloudSetting) {
        this.cloudSetting = cloudSetting;
    }

    public void save() throws JBException {
        this.saveAppToJavabaas(true, new JBBooleanCallback(){

            @Override
            public void done(boolean success, JBException e) {
                if (!success) {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
    }

    public void saveInBackground(JBBooleanCallback callback) {
        this.saveAppToJavabaas(false, callback);
    }

    private void saveAppToJavabaas(boolean sync, final JBBooleanCallback callback) {
        if (JBUtils.isEmpty(this.getName())) {
            callback.done(false, new JBException(JBCode.REQUEST_PARAM_ERROR.getCode(), "app\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
            return;
        }
        String path = JBHttpClient.getAdminPath();
        Map<String, Object> body = this.getAppMap();
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.POST, null, body, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                if (result == null || result.get("result") != null) {
                    JBApp.this.copyAppFromMap((Map)result.getData().get("result"));
                }
                if (callback != null) {
                    callback.done(true, null);
                }
            }

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, error);
                }
            }
        });
    }

    public void delete() throws JBException {
        this.deleteAppFromJavabaas(true, new JBBooleanCallback(){

            @Override
            public void done(boolean success, JBException e) {
                if (!success) {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
    }

    public void deleteInBackground(JBBooleanCallback callback) {
        this.deleteAppFromJavabaas(false, callback);
    }

    private void deleteAppFromJavabaas(boolean sync, final JBBooleanCallback callback) {
        if (JBUtils.isEmpty(this.getId())) {
            callback.done(false, new JBException(JBCode.REQUEST_PARAM_ERROR.getCode(), "id\u4e0d\u80fd\u4e3a\u7a7a"));
            return;
        }
        String path = JBHttpClient.getAdminPath(this.getId());
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.DELETE, null, null, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                if (callback != null) {
                    callback.done(true, null);
                }
            }

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, error);
                }
            }
        });
    }

    public static JBApp get(String appId) throws JBException {
        final JBApp[] apps = new JBApp[]{null};
        JBApp.getFromJavabaas(appId, true, new JBGetAppCallback(){

            @Override
            public void done(boolean success, JBApp app, JBException e) {
                if (success) {
                    apps[0] = app;
                } else {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
        return apps[0];
    }

    public static void getInBackground(String appId, JBGetAppCallback callback) {
        JBApp.getFromJavabaas(appId, false, callback);
    }

    private static void getFromJavabaas(String appId, boolean sync, final JBGetAppCallback callback) {
        if (JBUtils.isEmpty(appId)) {
            callback.done(false, null, new JBException(JBCode.REQUEST_PARAM_ERROR.getCode(), "id\u4e0d\u80fd\u4e3a\u7a7a"));
            return;
        }
        String path = JBHttpClient.getAdminPath(appId);
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.GET, null, null, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                if (callback == null) {
                    return;
                }
                if (result.getData() == null || result.getData().get("result") == null) {
                    callback.done(false, null, new JBException(JBCode.APP_NOT_FOUND));
                } else {
                    JBApp app = JBApp.getAppFromMap((Map)result.getData().get("result"));
                    callback.done(true, app, null);
                }
            }

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, null, error);
                }
            }
        });
    }

    public void resetKey(int type) throws JBException {
        this.resetKeyToJavabaas(type, true, new JBBooleanCallback(){

            @Override
            public void done(boolean success, JBException e) {
                if (!success) {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
    }

    public void resetKeyInBackground(int type, JBBooleanCallback callback) {
        this.resetKeyToJavabaas(type, false, callback);
    }

    private void resetKeyToJavabaas(int type, boolean sync, final JBBooleanCallback callback) {
        String extra;
        if (JBUtils.isEmpty(this.getId())) {
            callback.done(false, new JBException(JBCode.REQUEST_PARAM_ERROR.getCode(), "app\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
            return;
        }
        if (type == 1) {
            extra = "resetKey";
        } else if (type == 2) {
            extra = "resetMasterKey";
        } else {
            return;
        }
        String path = JBHttpClient.getAdminPath(this.getId() + "/" + extra);
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.PUT, null, null, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                if (callback != null) {
                    callback.done(true, null);
                }
            }

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, error);
                }
            }
        });
    }

    public static List<JBApp> list() throws JBException {
        final List[] lists = new List[]{null};
        JBApp.listFromJavabaas(true, new JBAppListCallback(){

            @Override
            public void done(boolean success, List<JBApp> list, JBException e) {
                if (success) {
                    lists[0] = list;
                } else {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
        return lists[0];
    }

    public static void listInBackground(JBAppListCallback callback) {
        JBApp.listFromJavabaas(false, callback);
    }

    private static void listFromJavabaas(boolean sync, final JBAppListCallback callback) {
        String path = JBHttpClient.getAdminPath();
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.GET, null, null, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                List list = JBApp.getAppListFromMap(result.getData());
                if (callback != null) {
                    callback.done(true, list, null);
                }
            }

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, null, error);
                }
            }
        });
    }

    public static JBAppExport export(String appId) throws JBException {
        final JBAppExport[] lists = new JBAppExport[]{null};
        JBApp.exportFromJavabaas(true, appId, new JBAppExportCallback(){

            @Override
            public void done(boolean success, JBAppExport appExport, JBException e) {
                if (success) {
                    lists[0] = appExport;
                } else {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
        return lists[0];
    }

    public static void exportInBackground(String appId, JBAppExportCallback callback) {
        JBApp.exportFromJavabaas(false, appId, callback);
    }

    private static void exportFromJavabaas(boolean sync, String appId, final JBAppExportCallback callback) {
        String path = JBHttpClient.getAdminPath(appId + "/export");
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.GET, null, null, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                if (callback == null) {
                    return;
                }
                if (result.getData() == null || result.getData().get("result") == null) {
                    callback.done(false, null, new JBException(JBCode.APP_NOT_FOUND));
                } else {
                    JBAppExport appExport = JBApp.getAppExportFromMap((Map)result.getData().get("result"));
                    callback.done(true, appExport, null);
                }
            }

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, null, error);
                }
            }
        });
    }

    public static void importData(String data) throws JBException {
        JBApp.importDataToJavabaas(true, data, new JBBooleanCallback(){

            @Override
            public void done(boolean success, JBException e) {
                if (!success) {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
    }

    public static void importDataInBackground(String data, JBBooleanCallback callback) {
        JBApp.importDataToJavabaas(false, data, callback);
    }

    private static void importDataToJavabaas(boolean sync, String data, final JBBooleanCallback callback) {
        Map body;
        String path = JBHttpClient.getAdminPath("import");
        try {
            body = JBUtils.readValue(data, Map.class);
        }
        catch (JBException e) {
            body = null;
        }
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.POST, null, body, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                if (callback == null) {
                    return;
                }
                callback.done(true, null);
            }

            @Override
            public void onFailure(JBException error) {
                if (callback == null) {
                    return;
                }
                callback.done(false, error);
            }
        });
    }

    public static List<Long> getApiStat(JBApiStat apiStat) throws JBException {
        final List[] result = new List[]{null};
        JBApp.getApiStatFromJavabaas(true, apiStat, new JBApiStatListCallback(){

            @Override
            public void done(boolean success, List<Long> list, JBException e) {
                if (success) {
                    result[0] = list;
                } else {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
        return result[0];
    }

    public static void getApiStatInBackground(JBApiStat apiStat, JBApiStatListCallback callback) {
        JBApp.getApiStatFromJavabaas(false, apiStat, callback);
    }

    private static void getApiStatFromJavabaas(boolean sync, JBApiStat apiStat, final JBApiStatListCallback callback) {
        String path = JBHttpClient.getApiStatPath();
        JBHttpParams params = JBApp.getParamsFromApiStat(apiStat);
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.GET, params, null, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                List list = JBApp.getApiStatListFromMap(result.getData());
                if (callback != null) {
                    callback.done(true, list, null);
                }
            }

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, null, error);
                }
            }
        });
    }

    public static void updateAppConfig(JBAppConfig config) throws JBException {
        JBApp.updateAppConfigToJavabaas(config, true, new JBBooleanCallback(){

            @Override
            public void done(boolean success, JBException e) {
                if (!success) {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
    }

    public static void updateAppConfigInBackground(JBAppConfig config, JBBooleanCallback callback) {
        JBApp.updateAppConfigToJavabaas(config, false, callback);
    }

    private static void updateAppConfigToJavabaas(JBAppConfig config, boolean sync, final JBBooleanCallback callback) {
        String path = JBHttpClient.getConfigPath("app");
        if (config == null) {
            if (callback != null) {
                callback.done(false, new JBException(JBCode.REQUEST_PARAM_ERROR.getCode(), "Config\u4fe1\u606f\u9519\u8bef"));
            }
            return;
        }
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("key", config.getAppConfigKey().getKey());
        body.put("value", config.getValue());
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.POST, null, body, sync, new JBObjectCallback(){

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, error);
                }
            }

            @Override
            public void onSuccess(JBResult result) {
                if (callback != null) {
                    callback.done(true, null);
                }
            }
        });
    }

    public static List<Map<String, String>> getAppConfigItems() throws JBException {
        final List[] result = new List[]{null};
        JBApp.getAppConfigItemsFromJavaBaas(true, new JBGetAppConfigItemsCallback(){

            @Override
            public void done(boolean success, List<Map<String, String>> list, JBException e) {
                if (!success) {
                    JBExceptionHolder.add(e);
                } else {
                    result[0] = list;
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
        return result[0];
    }

    public static void getAppConfigItemsInBackground(JBGetAppConfigItemsCallback callback) throws JBException {
        JBApp.getAppConfigItemsFromJavaBaas(false, callback);
    }

    private static void getAppConfigItemsFromJavaBaas(boolean sync, final JBGetAppConfigItemsCallback callback) {
        String path = JBHttpClient.getConfigPath("app/configs");
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.GET, null, null, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                if (callback != null && result.getData() != null && result.getData().get("result") != null) {
                    List list = (List)result.getData().get("result");
                    callback.done(true, list, null);
                }
            }

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, null, error);
                }
            }
        });
    }

    public static String getAppConfig(JBAppConfigKey appConfigKey) throws JBException {
        final String[] result = new String[1];
        JBApp.getAppConfigFromJavaBaas(appConfigKey, true, new JBGetConfigCallback(){

            @Override
            public void done(boolean success, String value, JBException e) {
                if (success) {
                    result[0] = value;
                } else {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
        return result[0];
    }

    public static void getAppConfigInBackground(JBAppConfigKey appConfigKey, JBGetConfigCallback callback) {
        JBApp.getAppConfigFromJavaBaas(appConfigKey, false, callback);
    }

    private static void getAppConfigFromJavaBaas(final JBAppConfigKey appConfigKey, boolean sync, final JBGetConfigCallback callback) {
        String path = JBHttpClient.getConfigPath("app");
        JBHttpParams params = new JBHttpParams();
        if (appConfigKey != null) {
            params.put("key", appConfigKey.getKey());
        }
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.GET, params, null, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                if (callback == null) {
                    return;
                }
                if (result.getData() != null && result.getData().get("result") != null) {
                    Map map = (Map)result.getData().get("result");
                    String value = (String)map.get(appConfigKey.getKey());
                    callback.done(true, value, null);
                } else {
                    callback.done(false, null, new JBException(JBCode.INTERNAL_JSON_ERROR));
                }
            }

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, null, error);
                }
            }
        });
    }

    private static List<Long> getApiStatListFromMap(Map<String, Object> map) {
        if (map == null || map.get("result") == null) {
            return new LinkedList<Long>();
        }
        List list = (List)map.get("result");
        return list;
    }

    private static JBHttpParams getParamsFromApiStat(JBApiStat apiStat) {
        JBHttpParams params = new JBHttpParams();
        if (!JBUtils.isEmpty(apiStat.getClazz())) {
            params.put("clazz", apiStat.getClazz());
        }
        if (apiStat.getMethod() != null && !JBUtils.isEmpty(apiStat.getMethod().value)) {
            params.put("method", apiStat.getMethod().value);
        }
        if (!JBUtils.isEmpty(apiStat.getPlat())) {
            params.put("plat", apiStat.getPlat());
        }
        if (!JBUtils.isEmpty(apiStat.getFrom())) {
            params.put("from", apiStat.getFrom());
        }
        if (!JBUtils.isEmpty(apiStat.getTo())) {
            params.put("to", apiStat.getTo());
        }
        return params;
    }

    private static JBAppExport getAppExportFromMap(Map<String, Object> map) {
        try {
            String exportStr = JBUtils.writeValueAsString(map);
            JBAppExport appExport = JBUtils.readValue(exportStr, JBAppExport.class);
            return appExport;
        }
        catch (JBException e) {
            return null;
        }
    }

    private static List<JBApp> getAppListFromMap(LinkedHashMap<String, Object> map) {
        if (map == null || map.get("result") == null) {
            return new LinkedList<JBApp>();
        }
        List maps = (List)map.get("result");
        LinkedList<JBApp> list = new LinkedList<JBApp>();
        for (Map o : maps) {
            list.add(JBApp.getAppFromMap(o));
        }
        return list;
    }

    private void copyAppFromMap(Map<String, Object> map) {
        try {
            String appStr = JBUtils.writeValueAsString(map);
            JBApp app = JBUtils.readValue(appStr, JBApp.class);
            if (app != null) {
                this.setId(app.id);
                this.setName(app.name);
                this.setKey(app.key);
                this.setMasterKey(app.masterKey);
                this.setCloudSetting(app.cloudSetting);
            }
        }
        catch (JBException jBException) {
            // empty catch block
        }
    }

    private static JBApp getAppFromMap(Map<String, Object> map) {
        try {
            String appStr = JBUtils.writeValueAsString(map);
            JBApp app = JBUtils.readValue(appStr, JBApp.class);
            return app;
        }
        catch (JBException e) {
            return null;
        }
    }

    private Map<String, Object> getAppMap() {
        HashMap<String, Object> body = new HashMap<String, Object>();
        if (!JBUtils.isEmpty(this.id)) {
            body.put("id", this.id);
        }
        if (!JBUtils.isEmpty(this.name)) {
            body.put("name", this.name);
        }
        if (!JBUtils.isEmpty(this.key)) {
            body.put("key", this.key);
        }
        if (!JBUtils.isEmpty(this.masterKey)) {
            body.put("masterKey", this.masterKey);
        }
        if (this.cloudSetting != null) {
            body.put("cloudSetting", this.cloudSetting);
        }
        return body;
    }

    public String toString() {
        try {
            return JBUtils.writeValueAsString(this);
        }
        catch (JBException e) {
            return "";
        }
    }

    public static enum JBApiMethod {
        INSERT("insert"),
        UPDATE("update"),
        FIND("find"),
        DELETE("delete");

        private String value;

        private JBApiMethod(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static JBApiMethod get(String value) {
            JBApiMethod[] methods;
            for (JBApiMethod method : methods = (JBApiMethod[])JBApiMethod.class.getEnumConstants()) {
                if (!method.value.equals(value)) continue;
                return method;
            }
            return null;
        }
    }

    public static enum JBAppConfigKey {
        SMS_TRY_LIMIT("baas.sms.tryLimit", "\u91cd\u8bd5\u6b21\u6570", "5"),
        SMS_HANDLER("baas.sms.handler", "\u77ed\u4fe1\u53d1\u9001\u5668", "aliyun"),
        SMS_HANDLER_ALIYUN_KEY("baas.sms.handler.aliyun.key", "\u963f\u91cc\u4e91key", ""),
        SMS_HANDLER_ALIYUN_SECRET("baas.sms.handler.aliyun.secret", "\u963f\u91cc\u4e91secret", ""),
        SMS_CODE_TEMPLATE_ID("baas.sms.codeTemplateId", "\u77ed\u4fe1\u9a8c\u8bc1\u7801\u6a21\u7248id", ""),
        SMS_REGISTER_TEMPLATE_ID("baas.sms.registerTemplateId", "\u767b\u5f55\u6ce8\u518c\u9a8c\u8bc1\u7801\u6a21\u7248id", ""),
        SMS_BIND_TEMPLATE_ID("baas.sms.bindTemplateId", "\u7ed1\u5b9a\u624b\u673a\u53f7\u9a8c\u8bc1\u7801\u6a21\u7248id", ""),
        SMS_SIGN_NAME("baas.sms.signName", "\u77ed\u4fe1\u7b7e\u540d", ""),
        SMS_SEND_INTERVAL("baas.sms.interval", "\u77ed\u4fe1\u53d1\u9001\u95f4\u9694", "60"),
        SMS_REGISTER_SUPER_CODE("baas.sms.register.super.code", "\u767b\u5f55\u6ce8\u518c\u4e07\u80fd\u9a8c\u8bc1\u7801", ""),
        PUSH_HANDLER("baas.push.handler", "\u63a8\u9001\u5904\u7406", "jpush"),
        PUSH_HANDLER_JPUSH_KEY("baas.push.handler.jpush.key", "\u6781\u5149\u63a8\u9001key", ""),
        PUSH_HANDLER_JPUSH_SECRET("baas.push.handler.jpush.secret", "\u6781\u5149\u63a8\u9001secret", ""),
        FILE_HANDLER("baas.file.handler", "\u63a8\u9001\u5904\u7406", "qiniu"),
        FILE_HANDLER_QINIU_AK("baas.file.handler.qiniu.ak", "\u4e03\u725bak", ""),
        FILE_HANDLER_QINIU_SK("baas.file.handler.qiniu.sk", "\u4e03\u725bsk", ""),
        FILE_HANDLER_QINIU_BUCKET("baas.file.handler.qiniu.bucket", "\u4e03\u725bbucket", ""),
        FILE_HANDLER_QINIU_PIPELINE("baas.file.handler.qiniu.pipeline", "\u4e03\u725bpipeline", ""),
        FILE_HANDLER_QINIU_URL("baas.file.handler.qiniu.url", "\u4e03\u725burl", ""),
        FILE_HANDLER_QINIU_ZONE("baas.file.handler.qiniu.zone", "\u4e03\u725bzone", ""),
        WEBAPP_APPID("baas.webapp.appid", "\u5fae\u4fe1\u5c0f\u7a0b\u5e8fappid", ""),
        WEBAPP_SECRET("baas.webapp.secret", "\u5fae\u4fe1\u5c0f\u7a0b\u5e8fsecret", "");

        private String key;
        private String name;
        private String defaultValue;

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public static JBAppConfigKey getConfig(String key) {
            if (JBUtils.isEmpty(key)) {
                return null;
            }
            for (JBAppConfigKey appConfigKey : JBAppConfigKey.values()) {
                if (!key.equals(appConfigKey.getKey())) continue;
                return appConfigKey;
            }
            return null;
        }

        public static String getDefaultValue(String key) {
            JBAppConfigKey config = JBAppConfigKey.getConfig(key);
            if (config != null) {
                return config.getDefaultValue();
            }
            return null;
        }

        private JBAppConfigKey(String key, String name, String defaultValue) {
            this.key = key;
            this.name = name;
            this.defaultValue = defaultValue;
        }
    }

    public static enum HookSettingType {
        BEFOREINSERT,
        AFTERINSERT,
        BEFOREUPDATE,
        AFTERUPDATE,
        BEFOREDELETE,
        AFTERDELETE;

    }

    public static class JBAppConfig {
        private JBAppConfigKey appConfigKey;
        private String value;

        public JBAppConfigKey getAppConfigKey() {
            return this.appConfigKey;
        }

        public void setAppConfigKey(JBAppConfigKey appConfigKey) {
            this.appConfigKey = appConfigKey;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class JBApiStat {
        private String plat;
        private String clazz;
        private JBApiMethod method;
        private String from;
        private String to;

        public JBApiStat(String plat, String clazz, JBApiMethod method, String from, String to) {
            this.plat = plat;
            this.clazz = clazz;
            this.method = method;
            this.from = from;
            this.to = to;
        }

        public JBApiMethod getMethod() {
            return this.method;
        }

        public void setMethod(JBApiMethod method) {
            this.method = method;
        }

        public String getPlat() {
            return this.plat;
        }

        public void setPlat(String plat) {
            this.plat = plat;
        }

        public String getClazz() {
            return this.clazz;
        }

        public void setClazz(String clazz) {
            this.clazz = clazz;
        }

        public String getFrom() {
            return this.from;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public String getTo() {
            return this.to;
        }

        public void setTo(String to) {
            this.to = to;
        }
    }

    public static class JBAppExport {
        private String id;
        private String name;
        private String key;
        private String masterKey;
        private CloudSetting cloudSetting;
        private List<JBClazz.JBClazzExport> clazzs;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getMasterKey() {
            return this.masterKey;
        }

        public void setMasterKey(String masterKey) {
            this.masterKey = masterKey;
        }

        public CloudSetting getCloudSetting() {
            return this.cloudSetting;
        }

        public void setCloudSetting(CloudSetting cloudSetting) {
            this.cloudSetting = cloudSetting;
        }

        public List<JBClazz.JBClazzExport> getClazzs() {
            return this.clazzs;
        }

        public void setClazzs(List<JBClazz.JBClazzExport> clazzs) {
            this.clazzs = clazzs;
        }
    }
}

