/*
 * Decompiled with CFR 0.152.
 */
package com.javabaas.javasdk;

import com.javabaas.javasdk.JBApp;
import com.javabaas.javasdk.JBCode;
import com.javabaas.javasdk.JBException;
import com.javabaas.javasdk.JBExceptionHolder;
import com.javabaas.javasdk.JBField;
import com.javabaas.javasdk.JBHttpClient;
import com.javabaas.javasdk.JBHttpMethod;
import com.javabaas.javasdk.JBResult;
import com.javabaas.javasdk.JBUser;
import com.javabaas.javasdk.JBUtils;
import com.javabaas.javasdk.callback.JBBooleanCallback;
import com.javabaas.javasdk.callback.JBClazzExportCallback;
import com.javabaas.javasdk.callback.JBClazzListCallback;
import com.javabaas.javasdk.callback.JBGetClazzCallback;
import com.javabaas.javasdk.callback.JBObjectCallback;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JBClazz {
    private String id;
    private JBApp app;
    private String name;
    private JBClazzAcl acl;
    private boolean internal;
    private long count;

    public JBClazz() {
    }

    public JBClazz(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public JBApp getApp() {
        return this.app;
    }

    public void setApp(JBApp app) {
        this.app = app;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JBClazzAcl getAcl() {
        return this.acl;
    }

    public void setAcl(JBClazzAcl acl) {
        this.acl = acl;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public void setInternal(boolean internal) {
        this.internal = internal;
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public void save() throws JBException {
        this.saveToJavabaas(true, new JBBooleanCallback(){

            @Override
            public void done(boolean success, JBException e) {
                if (!success) {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
    }

    public void saveInBackdround(JBBooleanCallback callback) {
        this.saveToJavabaas(false, callback);
    }

    private void saveToJavabaas(boolean sync, final JBBooleanCallback callback) {
        String path = JBHttpClient.getClazzPath();
        Map<String, Object> body = this.getClazzMap();
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.POST, null, body, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                if (callback != null) {
                    callback.done(true, null);
                }
            }

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, error);
                }
            }
        });
    }

    public void delete() throws JBException {
        this.deleteClazzFromJavabaas(true, new JBBooleanCallback(){

            @Override
            public void done(boolean success, JBException e) {
                if (!success) {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
    }

    public void deleteInBackground(JBBooleanCallback callback) {
        this.deleteClazzFromJavabaas(false, callback);
    }

    private void deleteClazzFromJavabaas(boolean sync, final JBBooleanCallback callback) {
        if (JBUtils.isEmpty(this.getName())) {
            callback.done(false, new JBException(JBCode.REQUEST_PARAM_ERROR.getCode(), "className\u4e0d\u80fd\u4e3a\u7a7a"));
            return;
        }
        String path = JBHttpClient.getClazzPath(this.getName());
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.DELETE, null, null, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                if (callback != null) {
                    callback.done(true, null);
                }
            }

            @Override
            public void onFailure(JBException error) {
                if (callback == null) {
                    return;
                }
                callback.done(false, error);
            }
        });
    }

    public static JBClazz get(String name) throws JBException {
        final JBClazz[] clazzes = new JBClazz[]{null};
        JBClazz.getFromJavabaas(name, true, new JBGetClazzCallback(){

            @Override
            public void done(boolean success, JBClazz clazz, JBException e) {
                if (success) {
                    clazzes[0] = clazz;
                } else {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
        return clazzes[0];
    }

    public static void getInBackground(String name, JBGetClazzCallback callback) {
        JBClazz.getFromJavabaas(name, false, callback);
    }

    private static void getFromJavabaas(String name, boolean sync, final JBGetClazzCallback callback) {
        if (JBUtils.isEmpty(name)) {
            callback.done(false, null, new JBException(JBCode.REQUEST_PARAM_ERROR.getCode(), "name\u4e0d\u80fd\u4e3a\u7a7a"));
            return;
        }
        String path = JBHttpClient.getClazzPath(name);
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.GET, null, null, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                JBClazz clazz = JBClazz.copyClazzFromResultData(result.getData());
                if (callback != null) {
                    callback.done(true, clazz, null);
                }
            }

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, null, error);
                }
            }
        });
    }

    public void updateClazzAcl() throws JBException {
        this.updateClazzAclToJavabaas(true, new JBBooleanCallback(){

            @Override
            public void done(boolean success, JBException e) {
                if (!success) {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
    }

    public void updateClazzAclInBackground(JBBooleanCallback callback) {
        this.updateClazzAclToJavabaas(false, callback);
    }

    private void updateClazzAclToJavabaas(boolean sync, final JBBooleanCallback callback) {
        if (JBUtils.isEmpty(this.getName())) {
            callback.done(false, new JBException(JBCode.REQUEST_PARAM_ERROR.getCode(), "className\u4e0d\u80fd\u4e3a\u7a7a"));
            return;
        }
        String path = JBHttpClient.getClazzPath(this.getName() + "/acl");
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.POST, null, this.getAcl(), sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                if (callback != null) {
                    callback.done(true, null);
                }
            }

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, error);
                }
            }
        });
    }

    private Map<String, Object> getClazzMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!JBUtils.isEmpty(this.getId())) {
            map.put("id", this.getId());
        }
        if (!JBUtils.isEmpty(this.getName())) {
            map.put("name", this.getName());
        }
        if (this.getAcl() != null) {
            map.put("acl", this.getAcl());
        }
        return map;
    }

    public static List<JBClazz> list() throws JBException {
        final List[] lists = new List[]{null};
        JBClazz.listFromJavabaas(true, new JBClazzListCallback(){

            @Override
            public void done(boolean success, List<JBClazz> list, JBException e) {
                if (success) {
                    lists[0] = list;
                } else {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
        return lists[0];
    }

    public static void listInBackground(JBClazzListCallback callback) {
        JBClazz.listFromJavabaas(false, callback);
    }

    private static void listFromJavabaas(boolean sync, final JBClazzListCallback callback) {
        String path = JBHttpClient.getClazzPath();
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.GET, null, null, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                List list = JBClazz.getClazzListFromMap(result.getData());
                if (callback != null) {
                    callback.done(true, list, null);
                }
            }

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, null, error);
                }
            }
        });
    }

    public static JBClazzExport export(String className) throws JBException {
        final JBClazzExport[] lists = new JBClazzExport[]{null};
        JBClazz.exportFromJavabaas(true, className, new JBClazzExportCallback(){

            @Override
            public void done(boolean success, JBClazzExport clazzExport, JBException e) {
                if (success) {
                    lists[0] = clazzExport;
                } else {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
        return lists[0];
    }

    public static void exportInBackground(String className, JBClazzExportCallback callback) {
        JBClazz.exportFromJavabaas(false, className, callback);
    }

    private static void exportFromJavabaas(boolean sync, String className, final JBClazzExportCallback callback) {
        String path = JBHttpClient.getClazzPath(className + "/export");
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.GET, null, null, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                if (callback == null) {
                    return;
                }
                if (result.getData() == null || result.getData().get("result") == null) {
                    callback.done(false, null, new JBException(JBCode.CLAZZ_NOT_FOUND));
                } else {
                    JBClazzExport clazzExport = JBClazz.getClazzExportFromMap((Map)result.getData().get("result"));
                    callback.done(true, clazzExport, null);
                }
            }

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, null, error);
                }
            }
        });
    }

    public static void importData(String data) throws JBException {
        JBClazz.importDataToJavabaas(true, data, new JBBooleanCallback(){

            @Override
            public void done(boolean success, JBException e) {
                if (!success) {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
    }

    public static void importDataInBackground(String data, JBBooleanCallback callback) {
        JBClazz.importDataToJavabaas(false, data, callback);
    }

    private static void importDataToJavabaas(boolean sync, String data, final JBBooleanCallback callback) {
        String path = JBHttpClient.getClazzPath("import");
        Map body = null;
        try {
            body = JBUtils.readValue(data, Map.class);
        }
        catch (JBException jBException) {
            // empty catch block
        }
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.POST, null, body, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                if (callback != null) {
                    callback.done(true, null);
                }
            }

            @Override
            public void onFailure(JBException error) {
                if (callback == null) {
                    return;
                }
                callback.done(false, error);
            }
        });
    }

    private static JBClazzExport getClazzExportFromMap(Map<String, Object> map) {
        try {
            String exportStr = JBUtils.writeValueAsString(map);
            JBClazzExport clazzExport = JBUtils.readValue(exportStr, JBClazzExport.class);
            return clazzExport;
        }
        catch (JBException e) {
            return null;
        }
    }

    private static List<JBClazz> getClazzListFromMap(LinkedHashMap<String, Object> map) {
        if (map == null || map.get("result") == null) {
            return new LinkedList<JBClazz>();
        }
        List maps = (List)map.get("result");
        LinkedList<JBClazz> list = new LinkedList<JBClazz>();
        for (Map o : maps) {
            list.add(JBClazz.copyClazzFromMap(o));
        }
        return list;
    }

    private static JBClazz copyClazzFromResultData(Map<String, Object> map) {
        if (map == null || map.get("result") == null) {
            return null;
        }
        return JBClazz.copyClazzFromMap((Map)map.get("result"));
    }

    private static JBClazz copyClazzFromMap(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        try {
            String clazzStr = JBUtils.writeValueAsString(map);
            JBClazz clazz = JBUtils.readValue(clazzStr, JBClazz.class);
            return clazz;
        }
        catch (JBException e) {
            return null;
        }
    }

    public static class JBClazzExport {
        private String id;
        private String name;
        private JBClazzAcl acl;
        private boolean internal;
        private List<JBField.JBFieldExport> fields;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public JBClazzAcl getAcl() {
            return this.acl;
        }

        public void setAcl(JBClazzAcl acl) {
            this.acl = acl;
        }

        public boolean isInternal() {
            return this.internal;
        }

        public void setInternal(boolean internal) {
            this.internal = internal;
        }

        public List<JBField.JBFieldExport> getFields() {
            return this.fields;
        }

        public void setFields(List<JBField.JBFieldExport> fields) {
            this.fields = fields;
        }
    }

    public static enum ClazzAclMethod {
        INSERT("insert"),
        UPDATE("update"),
        GET("get"),
        FIND("find"),
        DELETE("delete");

        private String value;

        private ClazzAclMethod(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class JBClazzAcl
    extends LinkedHashMap<String, Object> {
        public void setPublicAccess(ClazzAclMethod method, boolean access) {
            Map<String, Boolean> accessMap = this.getAccessMap("*");
            accessMap.put(method.toString(), access);
            this.put("*", accessMap);
        }

        public void setAccess(ClazzAclMethod method, String userId, boolean access) {
            Map<String, Boolean> accessMap = this.getAccessMap(userId);
            accessMap.put(method.toString(), access);
            this.put(userId, accessMap);
        }

        public boolean hasAccess(ClazzAclMethod method, JBUser user) {
            if (user == null) {
                return this.hasPublicAccess(method);
            }
            return this.hasPublicAccess(method) || this.hasAccess(method, user.getObjectId());
        }

        public boolean hasPublicAccess(ClazzAclMethod method) {
            return this.hasAccess(method, "*");
        }

        public boolean hasAccess(ClazzAclMethod method, String name) {
            Map<String, Boolean> map = this.getAccessMap(name);
            Boolean write = map.get(method.toString());
            if (write == null) {
                return false;
            }
            return write;
        }

        private Map<String, Boolean> getAccessMap(String name) {
            HashMap accessMap = (HashMap)this.get(name);
            if (accessMap == null) {
                accessMap = new HashMap();
            }
            return accessMap;
        }

        @Override
        public String toString() {
            try {
                return JBUtils.writeValueAsString(this);
            }
            catch (JBException e) {
                return "";
            }
        }
    }
}

