/*
 * Decompiled with CFR 0.152.
 */
package com.javabaas.javasdk;

import com.javabaas.javasdk.JBClazz;
import com.javabaas.javasdk.JBCode;
import com.javabaas.javasdk.JBException;
import com.javabaas.javasdk.JBExceptionHolder;
import com.javabaas.javasdk.JBHttpClient;
import com.javabaas.javasdk.JBHttpMethod;
import com.javabaas.javasdk.JBResult;
import com.javabaas.javasdk.JBUtils;
import com.javabaas.javasdk.callback.JBBooleanCallback;
import com.javabaas.javasdk.callback.JBFieldListCallback;
import com.javabaas.javasdk.callback.JBGetFieldCallback;
import com.javabaas.javasdk.callback.JBObjectCallback;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JBField {
    private String id;
    private JBClazz clazz;
    private String name;
    private int type;
    private boolean internal;
    private boolean security;
    private boolean notnull;
    private boolean readonly;

    public JBField() {
    }

    public JBField(int type, String name) {
        this.type = type;
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public JBClazz getClazz() {
        return this.clazz;
    }

    public void setClazz(JBClazz clazz) {
        this.clazz = clazz;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public void setInternal(boolean internal) {
        this.internal = internal;
    }

    public boolean isSecurity() {
        return this.security;
    }

    public void setSecurity(boolean security) {
        this.security = security;
    }

    public boolean isNotnull() {
        return this.notnull;
    }

    public void setNotnull(boolean notnull) {
        this.notnull = notnull;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public void save() throws JBException {
        this.saveToJavabaas(true, new JBBooleanCallback(){

            @Override
            public void done(boolean success, JBException e) {
                if (!success) {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
    }

    public void saveInBackground(JBBooleanCallback callback) {
        this.saveToJavabaas(false, callback);
    }

    private void saveToJavabaas(boolean sync, final JBBooleanCallback callback) {
        if (this.getClazz() == null || JBUtils.isEmpty(this.getName())) {
            callback.done(false, new JBException(JBCode.REQUEST_PARAM_ERROR));
            return;
        }
        String className = this.getClazz().getName();
        String path = JBHttpClient.getFieldPath(className);
        Map<String, Object> body = this.getFieldMap();
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.POST, null, body, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                if (callback == null) {
                    return;
                }
                callback.done(true, null);
            }

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, error);
                }
            }
        });
    }

    public void delete() throws JBException {
        this.deleteFieldFromJavabaas(true, new JBBooleanCallback(){

            @Override
            public void done(boolean success, JBException e) {
                if (!success) {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
    }

    public void deleteInBackground(JBBooleanCallback callback) {
        this.deleteFieldFromJavabaas(false, callback);
    }

    private void deleteFieldFromJavabaas(boolean sync, final JBBooleanCallback callback) {
        if (this.getClazz() == null || JBUtils.isEmpty(this.getName())) {
            callback.done(false, new JBException(JBCode.REQUEST_PARAM_ERROR.getCode(), "class\u6216\u8005field\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"));
            return;
        }
        String path = JBHttpClient.getFieldPath(this.getClazz().getName(), this.getName());
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.DELETE, null, null, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                if (callback == null) {
                    return;
                }
                callback.done(true, null);
            }

            @Override
            public void onFailure(JBException error) {
                if (callback == null) {
                    return;
                }
                callback.done(false, error);
            }
        });
    }

    public void update() throws JBException {
        this.updateFromJavabaas(true, new JBBooleanCallback(){

            @Override
            public void done(boolean success, JBException e) {
                if (!success) {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
    }

    public void updateInBackground(JBBooleanCallback callback) {
        this.updateFromJavabaas(false, callback);
    }

    private void updateFromJavabaas(boolean sync, final JBBooleanCallback callback) {
        if (this.getClazz() == null || JBUtils.isEmpty(this.getName())) {
            callback.done(false, new JBException(JBCode.REQUEST_PARAM_ERROR.getCode(), "class\u6216\u8005field\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"));
            return;
        }
        String path = JBHttpClient.getFieldPath(this.getClazz().getName(), this.getName());
        Map<String, Object> body = this.getFieldMap();
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.PUT, null, body, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                if (callback != null) {
                    callback.done(true, null);
                }
            }

            @Override
            public void onFailure(JBException error) {
                if (callback == null) {
                    return;
                }
                callback.done(false, error);
            }
        });
    }

    public static JBField get(String className, String fieldName) throws JBException {
        final JBField[] fields = new JBField[]{null};
        JBField.getFieldFromJavabaas(className, fieldName, true, new JBGetFieldCallback(){

            @Override
            public void done(boolean success, JBField field, JBException e) {
                if (success) {
                    fields[0] = field;
                } else {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
        return fields[0];
    }

    public static void getInBackground(String className, String fieldName, JBGetFieldCallback callback) {
        JBField.getFieldFromJavabaas(className, fieldName, false, callback);
    }

    private static void getFieldFromJavabaas(String className, String fieldName, boolean sync, final JBGetFieldCallback callback) {
        if (JBUtils.isEmpty(className) || JBUtils.isEmpty(fieldName)) {
            callback.done(false, null, new JBException(JBCode.REQUEST_PARAM_ERROR));
            return;
        }
        String path = JBHttpClient.getFieldPath(className, fieldName);
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.GET, null, null, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                JBField field = JBField.copyFieldFromResultData(result.getData());
                if (callback != null) {
                    callback.done(true, field, null);
                }
            }

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, null, error);
                }
            }
        });
    }

    public static List<JBField> list(String className) throws JBException {
        final List[] lists = new List[]{null};
        JBField.listFromJavabaas(className, true, new JBFieldListCallback(){

            @Override
            public void done(boolean success, List<JBField> list, JBException e) {
                if (success) {
                    lists[0] = list;
                } else {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
        return lists[0];
    }

    public static void listInBackground(String className, JBFieldListCallback callback) {
        JBField.listFromJavabaas(className, false, callback);
    }

    private static void listFromJavabaas(String className, boolean sync, final JBFieldListCallback callback) {
        String path = JBHttpClient.getFieldPath(className);
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.GET, null, null, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                List list = JBField.getFieldListFromMap(result.getData());
                if (callback != null) {
                    callback.done(true, list, null);
                }
            }

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, null, error);
                }
            }
        });
    }

    private static List<JBField> getFieldListFromMap(LinkedHashMap<String, Object> map) {
        if (map == null || map.get("result") == null) {
            return new LinkedList<JBField>();
        }
        List maps = (List)map.get("result");
        LinkedList<JBField> list = new LinkedList<JBField>();
        for (Map objectMap : maps) {
            list.add(JBField.copyFieldFromMap(objectMap));
        }
        return list;
    }

    private static JBField copyFieldFromResultData(Map<String, Object> map) {
        if (map == null || map.get("result") == null) {
            return null;
        }
        return JBField.copyFieldFromMap((Map)map.get("result"));
    }

    private static JBField copyFieldFromMap(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        try {
            String FieldStr = JBUtils.writeValueAsString(map);
            JBField field = JBUtils.readValue(FieldStr, JBField.class);
            return field;
        }
        catch (JBException e) {
            return null;
        }
    }

    private Map<String, Object> getFieldMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!JBUtils.isEmpty(this.getId())) {
            map.put("id", this.getId());
        }
        if (!JBUtils.isEmpty(this.getName())) {
            map.put("name", this.getName());
        }
        if (this.getClazz() != null) {
            map.put("clazz", this.getClazz());
        }
        map.put("type", this.getType());
        map.put("internal", this.isInternal());
        map.put("security", this.isSecurity());
        map.put("notnull", this.isNotnull());
        map.put("readonly", this.isReadonly());
        return map;
    }

    public static class JBFieldExport {
        private String id;
        private String name;
        private int type;
        private boolean internal;
        private boolean security;
        private boolean notnull;
        private boolean readonly;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public boolean isInternal() {
            return this.internal;
        }

        public void setInternal(boolean internal) {
            this.internal = internal;
        }

        public boolean isSecurity() {
            return this.security;
        }

        public void setSecurity(boolean security) {
            this.security = security;
        }

        public boolean isNotnull() {
            return this.notnull;
        }

        public void setNotnull(boolean notnull) {
            this.notnull = notnull;
        }

        public boolean isReadonly() {
            return this.readonly;
        }

        public void setReadonly(boolean readonly) {
            this.readonly = readonly;
        }
    }
}

