/*
 * Decompiled with CFR 0.152.
 */
package com.javabaas.javasdk;

import com.javabaas.javasdk.JBException;
import com.javabaas.javasdk.JBExceptionHolder;
import com.javabaas.javasdk.JBHttpClient;
import com.javabaas.javasdk.JBHttpMethod;
import com.javabaas.javasdk.JBHttpParams;
import com.javabaas.javasdk.JBObject;
import com.javabaas.javasdk.JBResult;
import com.javabaas.javasdk.JBUtils;
import com.javabaas.javasdk.callback.JBFileProcessCallback;
import com.javabaas.javasdk.callback.JBFileSaveCallback;
import com.javabaas.javasdk.callback.JBFileTokenCallback;
import com.javabaas.javasdk.callback.JBObjectCallback;
import java.util.LinkedHashMap;
import java.util.Map;

public final class JBFile
extends JBObject {
    private static final String URL = "url";
    private static final String SIZE = "size";
    private static final String NAME = "name";
    private static final String KEY = "key";
    private static final String MIMETYPE = "mimeType";
    private volatile boolean needFetch = false;

    public String getUrl() {
        return (String)this.get(URL);
    }

    public void setUrl(String url) {
        this.put(URL, url);
    }

    public String getName() {
        return (String)this.get(NAME);
    }

    public void setName(String name) {
        this.put(NAME, name);
    }

    public JBFile() {
        super(JBFile.fileClassName());
    }

    public JBFile(String name, String url) {
        super(JBFile.fileClassName());
        this.setName(name);
        this.setUrl(url);
    }

    public static String fileClassName() {
        return "_File";
    }

    public void needFetchFile(boolean need) {
        this.needFetch = need;
    }

    public static Map<String, Object> getToken(String fileName, String platform, String policy) throws JBException {
        final Map[] result = new Map[]{null};
        JBFile.getTokenFromJavabaas(fileName, platform, policy, true, new JBFileTokenCallback(){

            @Override
            public void done(boolean success, Map<String, Object> data, JBException e) {
                if (success) {
                    result[0] = data;
                } else {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
        return result[0];
    }

    public static void getTokenInBackground(String fileName, String platform, String policy, JBFileTokenCallback callback) {
        JBFile.getTokenFromJavabaas(fileName, platform, policy, false, callback);
    }

    private static void getTokenFromJavabaas(String fileName, String platform, String policy, boolean sync, final JBFileTokenCallback callback) {
        String path = JBHttpClient.getFilePath("getToken");
        JBHttpParams params = new JBHttpParams();
        if (!JBUtils.isEmpty(fileName)) {
            params.put("fileName", fileName);
        }
        if (!JBUtils.isEmpty(platform)) {
            params.put("platform", platform);
        }
        if (!JBUtils.isEmpty(policy)) {
            params.put("policy", policy);
        }
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.GET, params, null, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                if (callback != null) {
                    callback.done(true, result.getData(), null);
                }
            }

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, null, error);
                }
            }
        });
    }

    public void saveFile(String platform, String policy) throws JBException {
        JBFile[] result = new JBFile[]{null};
        this.saveFileToJavabaas(platform, policy, true, new JBFileSaveCallback(){

            @Override
            public void done(boolean success, JBException e) {
                if (!success) {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
    }

    public void saveFileInBackground(String platform, String policy, JBFileSaveCallback callback) {
        this.saveFileToJavabaas(platform, policy, false, callback);
    }

    private void saveFileToJavabaas(String platform, String policy, boolean sync, final JBFileSaveCallback callback) {
        String path = JBHttpClient.getFilePath(null);
        JBHttpParams params = new JBHttpParams();
        if (this.needFetch) {
            params.put("fetch", true);
        }
        if (!JBUtils.isEmpty(platform)) {
            params.put("platform", platform);
        }
        if (!JBUtils.isEmpty(policy)) {
            params.put("policy", policy);
        }
        Map<String, Object> body = this.getObjectForSaveBody();
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.POST, params, body, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                if (callback != null) {
                    LinkedHashMap<String, Object> data = result.getData();
                    JBFile.this.fileFromMap((Map)data.get("file"));
                    callback.done(true, null);
                }
            }

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, error);
                }
            }
        });
    }

    public static JBFile process(String fileId, String platform, Map<String, Object> policy) throws JBException {
        final JBFile[] result = new JBFile[]{null};
        JBFile.processFileWithJavabaas(fileId, platform, policy, true, new JBFileProcessCallback(){

            @Override
            public void done(boolean success, JBFile file, JBException e) {
                if (success) {
                    result[0] = file;
                } else {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
        return result[0];
    }

    public static void processInBackground(String fileId, String platform, Map<String, Object> policy, JBFileProcessCallback callback) {
        JBFile.processFileWithJavabaas(fileId, platform, policy, false, callback);
    }

    private static void processFileWithJavabaas(String fileId, String platform, Map<String, Object> policy, boolean sync, final JBFileProcessCallback callback) {
        String path = JBHttpClient.getFilePath("master/process");
        JBHttpParams params = new JBHttpParams();
        if (!JBUtils.isEmpty(fileId)) {
            params.put("fileId", fileId);
        }
        if (!JBUtils.isEmpty(platform)) {
            params.put("platform", platform);
        }
        if (policy != null) {
            params.put("policy", policy);
        }
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.POST, params, null, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                if (callback != null) {
                    LinkedHashMap<String, Object> data = result.getData();
                    callback.done(true, JBFile.getFileFromMap((Map)data.get("file")), null);
                }
            }

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, null, error);
                }
            }
        });
    }

    private void fileFromMap(Map<String, Object> map) {
        String objectId = (String)map.get("_id");
        String url = (String)map.get(URL);
        String name = (String)map.get(NAME);
        if (!JBUtils.isEmpty(objectId)) {
            this.setObjectId(objectId);
        }
        if (!JBUtils.isEmpty(url)) {
            this.setUrl(url);
        }
        if (!JBUtils.isEmpty(name)) {
            this.setName(name);
        }
    }

    public static JBFile getFileFromMap(Map<String, Object> map) {
        JBFile file = new JBFile();
        String objectId = (String)map.get("_id");
        String url = (String)map.get(URL);
        String name = (String)map.get(NAME);
        if (!JBUtils.isEmpty(objectId)) {
            file.setObjectId(objectId);
        }
        if (!JBUtils.isEmpty(url)) {
            file.setUrl(url);
        }
        if (!JBUtils.isEmpty(name)) {
            file.setName(name);
        }
        return file;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        if (!JBUtils.isEmpty(this.className)) {
            stringBuffer.append("\"className\":\"" + this.className + "\"");
        }
        if (!JBUtils.isEmpty(this.objectId)) {
            stringBuffer.append(", \"objectId\":\"" + this.objectId + "\"");
        }
        if (this.get(URL) != null) {
            stringBuffer.append(", \"url\":\"" + this.get(URL) + "\"");
        }
        if (this.get(NAME) != null) {
            stringBuffer.append(", \"name\":\"" + this.get(NAME) + "\"");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

