/*
 * Decompiled with CFR 0.152.
 */
package com.javabaas.javasdk;

import com.javabaas.javasdk.JB;
import com.javabaas.javasdk.JBCode;
import com.javabaas.javasdk.JBException;
import com.javabaas.javasdk.JBHttpMethod;
import com.javabaas.javasdk.JBHttpParams;
import com.javabaas.javasdk.JBHttpResponseHandler;
import com.javabaas.javasdk.JBPostHttpResponseHandler;
import com.javabaas.javasdk.JBUser;
import com.javabaas.javasdk.JBUtils;
import com.javabaas.javasdk.callback.JBObjectCallback;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class JBHttpClient {
    OkHttpClient client = new OkHttpClient();
    public static final MediaType JSON = MediaType.parse((String)"application/json");
    private static volatile JBHttpClient httpClient;

    public void sendRequest(String url, JBHttpMethod method, JBHttpParams params, Object body, boolean sync, JBObjectCallback callback) {
        RequestBody requestBody;
        Request.Builder builder;
        JBHttpResponseHandler handler = this.createPostHandler(callback);
        try {
            builder = this.getRequestBuilder();
        }
        catch (JBException e) {
            handler.onFailure(e);
            return;
        }
        String wholeUrl = params != null ? params.getWholeUrl(url) : url;
        builder.url(wholeUrl);
        if (body != null) {
            try {
                requestBody = RequestBody.create((MediaType)JSON, (String)JBUtils.writeValueAsString(body));
            }
            catch (JBException e) {
                handler.onFailure(e);
                return;
            }
        } else {
            requestBody = RequestBody.create((MediaType)JSON, (String)"{}");
        }
        switch (method) {
            case GET: {
                break;
            }
            case PUT: {
                if (requestBody == null) break;
                builder.put(requestBody);
                break;
            }
            case POST: {
                if (requestBody == null) break;
                builder.post(requestBody);
                break;
            }
            case DELETE: {
                builder.delete();
                break;
            }
        }
        httpClient.execute(builder.build(), sync, handler);
    }

    private JBHttpResponseHandler createPostHandler(JBObjectCallback callback) {
        JBPostHttpResponseHandler handler = new JBPostHttpResponseHandler(callback);
        return handler;
    }

    public static synchronized JBHttpClient INSTANCE() {
        if (httpClient == null) {
            httpClient = new JBHttpClient();
        }
        return httpClient;
    }

    public static void setTimeout(long connectTimeout, long writeTimeout, long readTimeout) {
        JBHttpClient.INSTANCE().client = new OkHttpClient().newBuilder().connectTimeout(connectTimeout, TimeUnit.SECONDS).writeTimeout(writeTimeout, TimeUnit.SECONDS).readTimeout(readTimeout, TimeUnit.SECONDS).build();
    }

    public void execute(Request request, boolean sync, JBHttpResponseHandler handler) {
        Call call = this.client.newCall(request);
        if (sync) {
            try {
                Response response = call.execute();
                handler.onResponse(call, response, true);
            }
            catch (IOException e) {
                handler.onFailure(call, e, true);
            }
        } else {
            call.enqueue((Callback)handler);
        }
    }

    private Request.Builder getRequestBuilder() throws JBException {
        String adminKey;
        String masterKey;
        String key;
        if (!JB.getInstance().getConfig().finishInit) {
            throw new JBException(JBCode.INTERNAL_ERROR.getCode(), "JBConfig\u672a\u521d\u59cb\u5316");
        }
        long timestamp = System.currentTimeMillis();
        String timestampStr = String.valueOf(timestamp - JB.getInstance().getConfig().adjustTime);
        String nonce = UUID.randomUUID().toString().replace("-", "");
        Request.Builder builder = new Request.Builder();
        builder.addHeader("Content-Type", "application/json");
        builder.addHeader("JB-Plat", JB.getInstance().getConfig().plat);
        builder.addHeader("JB-Timestamp", timestampStr);
        builder.addHeader("JB-Nonce", nonce);
        String appId = JB.getInstance().getConfig().appId;
        if (!JBUtils.isEmpty(appId)) {
            builder.addHeader("JB-AppId", JB.getInstance().getConfig().appId);
        }
        if (!JBUtils.isEmpty(key = JB.getInstance().getConfig().key)) {
            builder.addHeader("JB-Sign", this.getSign(key, timestampStr, nonce));
        }
        if (!JBUtils.isEmpty(masterKey = JB.getInstance().getConfig().masterKey)) {
            builder.addHeader("JB-MasterSign", this.getSign(masterKey, timestampStr, nonce));
        }
        if (!JBUtils.isEmpty(adminKey = JB.getInstance().getConfig().adminKey)) {
            builder.addHeader("JB-AdminSign", this.getSign(adminKey, timestampStr, nonce));
        }
        if (JBUser.getCurrentUser() != null && !JBUtils.isEmpty(JBUser.getCurrentUser().getObjectId())) {
            builder.addHeader("JB-SessionToken", JBUser.getCurrentUser().getSessionToken());
        }
        return builder;
    }

    public String getSign(String key, String timestamp, String nonce) {
        return JBUtils.md5DigestAsHex(key + ":" + timestamp + ":" + nonce);
    }

    public static String getUserPath() {
        return JBHttpClient.getPath("user", null);
    }

    public static String getUserPath(String extra) {
        return JBHttpClient.getPath("user", extra);
    }

    public static String getObjectPath(String className) {
        return JBHttpClient.getPath("object", className);
    }

    public static String getObjectPath(String className, String extra) {
        return JBHttpClient.getPath("object", className + "/" + extra);
    }

    public static String getInstallationPath() {
        return JBHttpClient.getPath("installation", null);
    }

    public static String getAdminPath() {
        return JBHttpClient.getPath("admin/app", null);
    }

    public static String getAdminPath(String extra) {
        return JBHttpClient.getPath("admin/app", extra);
    }

    public static String getClazzPath() {
        return JBHttpClient.getPath("master/clazz", null);
    }

    public static String getClazzPath(String extra) {
        return JBHttpClient.getPath("master/clazz", extra);
    }

    public static String getFieldPath(String className) {
        return JBHttpClient.getPath("master/clazz/" + className + "/field", null);
    }

    public static String getFieldPath(String className, String extra) {
        return JBHttpClient.getPath("master/clazz/" + className + "/field", extra);
    }

    public static String getMasterPath(String extra) {
        return JBHttpClient.getPath("master", extra);
    }

    public static String getFilePath(String extra) {
        return JBHttpClient.getPath("file", extra);
    }

    public static String getCloudPath(String extra) {
        return JBHttpClient.getPath("cloud", extra);
    }

    public static String getCloudDeployPath() {
        return JBHttpClient.getPath("master/cloud", null);
    }

    public static String getConfigPath() {
        return JBHttpClient.getPath("master/config", null);
    }

    public static String getConfigPath(String extra) {
        return JBHttpClient.getPath("master/config", extra);
    }

    public static String getApiStatPath() {
        return JBHttpClient.getPath("master/apiStat", null);
    }

    public static String getAccountPath(int type) {
        return JBHttpClient.getPath("master/account/setAccount", String.valueOf(type));
    }

    public static String getRolePath(String extra) {
        return JBHttpClient.getPath("roles", extra);
    }

    private static String getPath(String domain, String extra) {
        if (JBUtils.isEmpty(JB.getInstance().getConfig().remote)) {
            return null;
        }
        StringBuffer urlPath = new StringBuffer(JB.getInstance().getConfig().remote);
        if (JBUtils.isEmpty(domain)) {
            return null;
        }
        urlPath.append(urlPath.toString().endsWith("/") ? "" : "/");
        urlPath.append(domain).append("/");
        if (!JBUtils.isEmpty(extra)) {
            urlPath.append(extra);
        }
        return urlPath.toString();
    }

    public static String getStatusPath() {
        return JB.getInstance().getConfig().remote;
    }
}

