/*
 * Decompiled with CFR 0.152.
 */
package com.javabaas.javasdk;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import okio.Buffer;

public class JBHttpParams {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static final String QUERY_COMPONENT_ENCODE_SET = " \"':;<=>@[]^`{}|/\\?#&!$(),~";
    Map<String, JBParam> params = new HashMap<String, JBParam>();

    public JBHttpParams() {
    }

    public JBHttpParams(Map<String, ?> params) {
        this();
        if (params != null) {
            for (Map.Entry<String, ?> entry : params.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public void put(String key, Object value) {
        String v;
        block4: {
            try {
                if (value instanceof Map) {
                    ObjectMapper objectMapper = new ObjectMapper();
                    v = objectMapper.writeValueAsString(value);
                    break block4;
                }
                if (value != null) {
                    v = value.toString();
                    break block4;
                }
                return;
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("url\u9519\u8bef");
            }
        }
        this.params.put(JBHttpParams.canonicalize(key, QUERY_COMPONENT_ENCODE_SET, false, true), JBParam.getJBParam(v));
    }

    public String getWholeUrl(String url) {
        if (this.params.isEmpty()) {
            return url;
        }
        StringBuilder stringBuilder = new StringBuilder(url);
        stringBuilder.append("?");
        boolean first = true;
        for (Map.Entry<String, JBParam> entry : this.params.entrySet()) {
            if (!first) {
                stringBuilder.append("&");
            }
            stringBuilder.append(entry.getKey()).append("=").append(entry.getValue().encodedParam);
            first = false;
        }
        return stringBuilder.toString();
    }

    static String canonicalize(String input, int pos, int limit, String encodeSet, boolean alreadyEncoded, boolean query) {
        int codePoint;
        for (int i = pos; i < limit; i += Character.charCount(codePoint)) {
            codePoint = input.codePointAt(i);
            if (codePoint >= 32 && codePoint < 127 && encodeSet.indexOf(codePoint) == -1 && (codePoint != 37 || alreadyEncoded) && (!query || codePoint != 43)) continue;
            Buffer out = new Buffer();
            out.writeUtf8(input, pos, i);
            JBHttpParams.canonicalize(out, input, i, limit, encodeSet, alreadyEncoded, query);
            return out.readUtf8();
        }
        return input.substring(pos, limit);
    }

    static void canonicalize(Buffer out, String input, int pos, int limit, String encodeSet, boolean alreadyEncoded, boolean query) {
        int codePoint;
        Buffer utf8Buffer = null;
        for (int i = pos; i < limit; i += Character.charCount(codePoint)) {
            codePoint = input.codePointAt(i);
            if (alreadyEncoded && (codePoint == 9 || codePoint == 10 || codePoint == 12 || codePoint == 13)) continue;
            if (query && codePoint == 43) {
                out.writeUtf8(alreadyEncoded ? "%20" : "%2B");
                continue;
            }
            if (codePoint < 32 || codePoint >= 127 || encodeSet.indexOf(codePoint) != -1 || codePoint == 37 && !alreadyEncoded) {
                if (utf8Buffer == null) {
                    utf8Buffer = new Buffer();
                }
                utf8Buffer.writeUtf8CodePoint(codePoint);
                while (!utf8Buffer.exhausted()) {
                    int b = utf8Buffer.readByte() & 0xFF;
                    out.writeByte(37);
                    out.writeByte((int)HEX_DIGITS[b >> 4 & 0xF]);
                    out.writeByte((int)HEX_DIGITS[b & 0xF]);
                }
                continue;
            }
            out.writeUtf8CodePoint(codePoint);
        }
    }

    static String canonicalize(String input, String encodeSet, boolean alreadyEncoded, boolean query) {
        return JBHttpParams.canonicalize(input, 0, input.length(), encodeSet, alreadyEncoded, query);
    }

    private static class JBParam {
        String param;
        String encodedParam;

        private JBParam() {
        }

        public String getEncodedParam() {
            return this.encodedParam;
        }

        public String getParam() {
            return this.param;
        }

        public static JBParam getJBParam(String param, String encodedParam) {
            JBParam jbParam = new JBParam();
            jbParam.encodedParam = encodedParam;
            jbParam.param = param;
            return jbParam;
        }

        public static JBParam getJBParam(String param) {
            JBParam jbParam = new JBParam();
            jbParam.param = param;
            jbParam.encodedParam = JBHttpParams.canonicalize(param, JBHttpParams.QUERY_COMPONENT_ENCODE_SET, false, true);
            return jbParam;
        }
    }
}

