/*
 * Decompiled with CFR 0.152.
 */
package com.javabaas.javasdk;

import com.javabaas.javasdk.JB;
import com.javabaas.javasdk.JBCode;
import com.javabaas.javasdk.JBException;
import com.javabaas.javasdk.JBResult;
import com.javabaas.javasdk.JBUtils;
import com.javabaas.javasdk.callback.JBObjectCallback;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;

public abstract class JBHttpResponseHandler
implements Callback {
    protected JBObjectCallback callback;

    public JBHttpResponseHandler(JBObjectCallback callback) {
        this.callback = callback;
    }

    public JBObjectCallback getCallback() {
        return this.callback;
    }

    public void setCallback(JBObjectCallback callback) {
        this.callback = callback;
    }

    public void onFailure(Call call, IOException e) {
        this.onFailure(call, e, false);
    }

    public void onResponse(Call call, Response response) throws IOException {
        this.onResponse(call, response, false);
    }

    public void onFailure(Call call, IOException e, boolean sync) {
        if (!sync) {
            if (this.checkAndroid()) {
                this.androidInvoke(new Runnable(){

                    @Override
                    public void run() {
                        JBHttpResponseHandler.this.onFailure(new JBException(JBCode.OTHER_HTTP_ERROR));
                    }
                });
            } else {
                this.onFailure(new JBException(JBCode.OTHER_HTTP_ERROR));
            }
        } else {
            this.onFailure(new JBException(JBCode.OTHER_HTTP_ERROR));
        }
    }

    public void onResponse(Call call, final Response response, boolean sync) throws IOException {
        final String content = JBUtils.stringFromBytes(response.body().bytes());
        if (!sync) {
            if (this.checkAndroid()) {
                this.androidInvoke(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (response.code() == 200) {
                                JBResult result = JBUtils.readValue(content, JBResult.class);
                                JBHttpResponseHandler.this.onSuccess(result);
                            } else if (response.code() == 400 || response.code() == 500) {
                                JBResult result = JBUtils.readValue(content, JBResult.class);
                                if (result.getCode() == 1310 && JB.getInstance().getJBUserSessionTokenErrorCallback() != null) {
                                    JB.getInstance().getJBUserSessionTokenErrorCallback().done();
                                }
                                JBHttpResponseHandler.this.onFailure(new JBException(result.getCode(), result.getMessage()));
                            } else {
                                JBHttpResponseHandler.this.onFailure(new JBException(JBCode.OTHER_HTTP_ERROR));
                            }
                        }
                        catch (JBException e) {
                            JBHttpResponseHandler.this.onFailure(e);
                        }
                    }
                });
            } else {
                this.response(response, content);
            }
        } else {
            this.response(response, content);
        }
    }

    private void androidInvoke(Runnable runnable) {
        try {
            Class<?> HandlerClass = Class.forName("android.os.Handler");
            Class<?> LopperClass = Class.forName("android.os.Looper");
            Object mainLopper = LopperClass.getMethod("getMainLooper", new Class[0]).invoke(null, new Object[0]);
            Constructor<?> handlerConstructor = HandlerClass.getConstructor(LopperClass);
            Object handler = handlerConstructor.newInstance(mainLopper);
            Method method = HandlerClass.getMethod("post", Runnable.class);
            method.invoke(handler, runnable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void response(Response response, String content) {
        try {
            if (response.code() == 200) {
                JBResult result = JBUtils.readValue(content, JBResult.class);
                this.onSuccess(result);
            } else if (response.code() == 400 || response.code() == 500) {
                JBResult result = JBUtils.readValue(content, JBResult.class);
                if (result.getCode() == 1310 && JB.getInstance().getJBUserSessionTokenErrorCallback() != null) {
                    JB.getInstance().getJBUserSessionTokenErrorCallback().done();
                }
                this.onFailure(new JBException(result.getCode(), result.getMessage()));
            } else {
                this.onFailure(new JBException(JBCode.OTHER_HTTP_ERROR));
            }
        }
        catch (JBException e) {
            this.onFailure(e);
        }
    }

    private boolean checkAndroid() {
        try {
            Class.forName("android.os.Handler");
            return true;
        }
        catch (ClassNotFoundException ignore) {
            return false;
        }
    }

    public abstract void onSuccess(JBResult var1);

    public abstract void onFailure(JBException var1);
}

