/*
 * Decompiled with CFR 0.152.
 */
package com.javabaas.javasdk;

import com.javabaas.javasdk.JBCode;
import com.javabaas.javasdk.JBException;
import com.javabaas.javasdk.JBExceptionHolder;
import com.javabaas.javasdk.JBHttpClient;
import com.javabaas.javasdk.JBHttpMethod;
import com.javabaas.javasdk.JBResult;
import com.javabaas.javasdk.callback.JBInstallationCallback;
import com.javabaas.javasdk.callback.JBObjectCallback;
import java.util.HashMap;

public class JBInstallation {
    public static String registerDevice(String deviceType, String deviceToken) throws JBException {
        final String[] result = new String[]{null};
        JBInstallation.registerDeviceToJavabaas(deviceType, deviceToken, true, new JBInstallationCallback(){

            @Override
            public void done(boolean success, String installationId, JBException e) {
                if (success) {
                    result[0] = installationId;
                } else {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
        return result[0];
    }

    public static void registerDeviceInBackground(String deviceType, String deviceToken, JBInstallationCallback callback) {
        JBInstallation.registerDeviceToJavabaas(deviceType, deviceToken, false, callback);
    }

    private static void registerDeviceToJavabaas(String deviceType, String deviceToken, boolean sync, final JBInstallationCallback callback) {
        String path = JBHttpClient.getInstallationPath();
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("deviceType", deviceType);
        body.put("deviceToken", deviceToken);
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.POST, null, body, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                if (callback == null) {
                    return;
                }
                if (result.getData() != null) {
                    String id = (String)result.getData().get("_id");
                    callback.done(true, id, null);
                } else {
                    callback.done(false, null, new JBException(JBCode.INTERNAL_ERROR.getCode(), "\u8bbe\u5907\u6ce8\u518c\u5931\u8d25"));
                }
            }

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, null, error);
                }
            }
        });
    }
}

