/*
 * Decompiled with CFR 0.152.
 */
package com.javabaas.javasdk;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.javabaas.javasdk.JBAcl;
import com.javabaas.javasdk.JBCode;
import com.javabaas.javasdk.JBException;
import com.javabaas.javasdk.JBExceptionHolder;
import com.javabaas.javasdk.JBFile;
import com.javabaas.javasdk.JBGeoPoint;
import com.javabaas.javasdk.JBHttpClient;
import com.javabaas.javasdk.JBHttpMethod;
import com.javabaas.javasdk.JBHttpParams;
import com.javabaas.javasdk.JBOperator;
import com.javabaas.javasdk.JBOperatorType;
import com.javabaas.javasdk.JBQuery;
import com.javabaas.javasdk.JBResult;
import com.javabaas.javasdk.JBUser;
import com.javabaas.javasdk.JBUtils;
import com.javabaas.javasdk.callback.JBBooleanCallback;
import com.javabaas.javasdk.callback.JBObjectCallback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class JBObject {
    public static final String CREATED_AT = "createdAt";
    public static final String UPDATED_AT = "updatedAt";
    public static final String OBJECT_ID = "_id";
    ReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile boolean fetchWhenSave = false;
    private JBQuery query;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String className;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String objectId = "";
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String updatedAt;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String createdAt;
    protected transient JBAcl acl;
    Map<String, Object> serverData = new HashMap<String, Object>();
    Map<String, Object> saveData = new HashMap<String, Object>();
    Map<String, JBOperator> operationQueue = new HashMap<String, JBOperator>();
    public static final Set<String> INVALID_KEYS = new HashSet<String>();

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public void setQuery(JBQuery query) {
        this.query = query;
    }

    public Map<String, Object> getServerData() {
        return this.serverData;
    }

    public void setServerData(Map<String, Object> serverData) {
        this.serverData = serverData;
    }

    public void setFetchWhenSave(boolean fetchWhenSave) {
        this.fetchWhenSave = fetchWhenSave;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String key) {
        if (CREATED_AT.equals(key)) {
            return this.getCreatedAt();
        }
        if (UPDATED_AT.equals(key)) {
            return this.getUpdatedAt();
        }
        Object value = null;
        try {
            this.lock.readLock().lock();
            value = this.serverData.get(key);
        }
        catch (Exception exception) {
        }
        finally {
            this.lock.readLock().unlock();
        }
        return value;
    }

    public JBAcl getAcl() {
        return this.acl;
    }

    public void setAcl(JBAcl acl) {
        this.acl = acl;
    }

    public JBObject() {
    }

    public JBObject(String theClassName) {
        this();
        JBUtils.checkClassName(theClassName);
        this.className = theClassName;
    }

    public JBObject(JBObject object) {
        this(object.getClassName());
        this.objectId = object.getObjectId();
        if (object.getCreatedAt() != null) {
            this.createdAt = String.valueOf(object.getCreatedAt().getTime());
        }
        if (object.getUpdatedAt() != null) {
            this.updatedAt = String.valueOf(object.getUpdatedAt().getTime());
        }
        JBUtils.copyPropertiesFromMapToJBObject(this, object.getServerData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, Object value) {
        try {
            this.lock.writeLock().lock();
            if (this.checkKey(key)) {
                this.serverData.put(key, value);
                this.updateSaveData(key, value);
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void updateSaveData(String key, Object value) {
        if (value == null) {
            this.saveData.remove(key);
        } else if (value instanceof JBFile || value instanceof JBUser || value instanceof JBObject) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("__type", value instanceof JBFile ? "File" : "Pointer");
            map.put("className", ((JBObject)value).getClassName());
            map.put(OBJECT_ID, ((JBObject)value).getObjectId());
            this.saveData.put(key, map);
        } else if (value instanceof JBGeoPoint) {
            List<Double> list = JBUtils.listFromGeoPoint((JBGeoPoint)value);
            this.saveData.put(key, list);
        } else {
            this.saveData.put(key, value);
        }
    }

    private boolean checkKey(String key) {
        if (JBUtils.isEmpty(key)) {
            throw new IllegalArgumentException("\u5b57\u6bb5\u4e3a\u7a7a");
        }
        if (key.startsWith("_")) {
            throw new IllegalArgumentException("\u5b57\u6bb5\u4e0d\u80fd\u4ee5'_'\u5f00\u5934");
        }
        return !INVALID_KEYS.contains(key);
    }

    public String getString(String key) {
        Object object = this.get(key);
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public int getInt(String key) {
        Number v = (Number)this.get(key);
        if (v != null) {
            return v.intValue();
        }
        return 0;
    }

    public long getLong(String key) {
        Number number = (Number)this.get(key);
        if (number != null) {
            return number.longValue();
        }
        return 0L;
    }

    public double getDouble(String key) {
        Number number = (Number)this.get(key);
        if (number != null) {
            return number.doubleValue();
        }
        return 0.0;
    }

    public boolean getBoolean(String key) {
        Boolean b = (Boolean)this.get(key);
        return b == null ? false : b;
    }

    public JBGeoPoint getJBGeoPoint(String key) {
        if (this.get(key) == null) {
            return null;
        }
        List list = this.getList(key);
        if (list.size() > 1) {
            return new JBGeoPoint(((Number)list.get(1)).doubleValue(), ((Number)list.get(0)).doubleValue());
        }
        return null;
    }

    public <T extends JBObject> T getJBObject(String key) {
        return (T)((JBObject)this.get(key));
    }

    public Date getDate(String key) {
        return JBUtils.dateFromString((String)this.get(key));
    }

    public Date getCreatedAt() {
        return JBUtils.dateFromString(this.createdAt);
    }

    public Date getUpdatedAt() {
        return JBUtils.dateFromString(this.updatedAt);
    }

    public List getList(String key) {
        return (List)this.get(key);
    }

    public <V> Map<String, V> getMap(String key) {
        return (Map)this.get(key);
    }

    public void removeKey(String key) {
        try {
            this.lock.writeLock().lock();
            if (!this.checkKey(key)) {
                return;
            }
            this.operationQueue.put(key, new JBOperator(JBOperatorType.DELETE));
        }
        catch (Exception exception) {
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void increment(String key) {
        this.increment(key, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment(String key, Number amount) {
        try {
            this.lock.writeLock().lock();
            if (!this.checkKey(key)) {
                return;
            }
            JBOperator operator = new JBOperator(JBOperatorType.INCREMENT);
            operator.setAmount(amount.longValue());
            this.operationQueue.put(key, operator);
        }
        catch (Exception exception) {
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void addArray(String key, Object object) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(object);
        this.addArray(key, list);
    }

    public void addArray(String key, Collection<?> list) {
        this.controlObjectToArray(key, list, JBOperatorType.ADD);
    }

    public void addUniqueArray(String key, Collection<?> list) {
        this.controlObjectToArray(key, list, JBOperatorType.ADDUNIQUE);
    }

    public void removeArray(String key, Collection<?> list) {
        this.controlObjectToArray(key, list, JBOperatorType.REMOVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void controlObjectToArray(String key, Collection<?> objects, JBOperatorType operatorType) {
        try {
            this.lock.writeLock().lock();
            if (!this.checkKey(key)) {
                return;
            }
            JBOperator operator = this.operationQueue.get(key);
            if (operator == null || operator != null && operator.getOp() != operatorType) {
                operator = new JBOperator(operatorType);
            }
            List<Object> list = operator.getObjects();
            for (Object o : objects) {
                list.add(o);
            }
            operator.setObjects(list);
            this.operationQueue.put(key, operator);
        }
        catch (Exception exception) {
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void multiply(String key, Number amount) {
        try {
            this.lock.writeLock().lock();
            if (!this.checkKey(key)) {
                return;
            }
            JBOperator operator = new JBOperator(JBOperatorType.MULTIPLY);
            operator.setAmount(amount.longValue());
            this.operationQueue.put(key, operator);
        }
        catch (Exception exception) {
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public static JBObject create(String className) {
        return new JBObject(className);
    }

    public static JBObject createWithoutData(String className, String objectId) {
        JBObject jbObject = new JBObject(className);
        if (JBUtils.isEmpty(objectId)) {
            throw new IllegalArgumentException("objectId \u4e3a\u7a7a");
        }
        jbObject.setObjectId(objectId);
        return jbObject;
    }

    public void save() throws JBException {
        this.saveObjectToJavaBaas(true, new JBBooleanCallback(){

            @Override
            public void done(boolean success, JBException e) {
                if (!success) {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
    }

    public void saveInBackground() {
        this.saveObjectToJavaBaas(false, null);
    }

    public void saveInBackground(JBBooleanCallback callback) {
        this.saveObjectToJavaBaas(false, callback);
    }

    private void saveObjectToJavaBaas(boolean sync, JBBooleanCallback callback) {
        JBHttpParams jbHttpParams;
        String urlPath;
        JBHttpMethod method;
        block5: {
            if (!JBUtils.isEmpty(this.objectId)) {
                method = JBHttpMethod.PUT;
                urlPath = JBHttpClient.getObjectPath(this.className, this.objectId);
            } else {
                method = JBHttpMethod.POST;
                urlPath = JBHttpClient.getObjectPath(this.className);
            }
            jbHttpParams = new JBHttpParams();
            jbHttpParams.put("fetch", this.fetchWhenSave);
            if (this.query != null && this.query.getWhere() != null) {
                this.query.assembleParameters();
                try {
                    jbHttpParams.put("where", JBUtils.writeValueAsString(this.query.getWhere()));
                }
                catch (JBException e) {
                    if (callback == null) break block5;
                    callback.done(false, e);
                }
            }
        }
        Map<String, Object> body = this.getObjectForSaveBody();
        this.saveToJavaBaas(urlPath, method, jbHttpParams, body, sync, callback);
    }

    protected void saveToJavaBaas(String path, JBHttpMethod method, JBHttpParams params, Map<String, Object> body, boolean sync, final JBBooleanCallback callback) {
        JBHttpClient.INSTANCE().sendRequest(path, method, params, body, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                if (result.getData() != null && result.getData().get("result") != null) {
                    JBObject.this.copyFromMap((Map)result.getData().get("result"));
                }
                if (callback != null) {
                    callback.done(true, null);
                }
            }

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, error);
                }
            }
        });
    }

    protected Map<String, Object> getObjectForSaveBody() {
        HashMap<String, Object> body = new HashMap<String, Object>();
        if (this.acl != null) {
            body.putAll(this.acl.getAclMap());
        }
        if (this.saveData.size() > 0) {
            body.putAll(this.saveData);
        }
        if (this.operationQueue.size() > 0) {
            body.putAll(this.operationQueue);
        }
        return body;
    }

    public void delete() throws JBException {
        this.deleteFromJavabaas(true, new JBBooleanCallback(){

            @Override
            public void done(boolean success, JBException e) {
                if (!success) {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
    }

    public void deleteInBackground() {
        this.deleteFromJavabaas(false, null);
    }

    public void deleteInBackground(JBBooleanCallback callback) {
        this.deleteFromJavabaas(false, callback);
    }

    private void deleteFromJavabaas(boolean sync, final JBBooleanCallback callback) {
        if (JBUtils.isEmpty(this.objectId)) {
            callback.done(false, new JBException(JBCode.OBJECT_ID_ERROR));
            return;
        }
        String path = JBHttpClient.getObjectPath(this.className, this.objectId);
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.DELETE, null, null, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                if (callback == null) {
                    return;
                }
                callback.done(true, null);
            }

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, error);
                }
            }
        });
    }

    protected void copyFromMap(Map<String, Object> map) {
        try {
            this.lock.writeLock().lock();
            JBUtils.copyPropertiesFromMapToJBObject(this, map);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Map2JBObject \u9519\u8bef");
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public String toString() {
        String serverDataStr = "";
        try {
            serverDataStr = JBUtils.writeValueAsString(this.serverData);
        }
        catch (JBException jBException) {
            // empty catch block
        }
        return "{\"className\":\"" + this.className + "\", \"objectId\":\"" + this.objectId + "\", \"updatedAt\":\"" + this.updatedAt + "\", \"createdAt\":\"" + this.createdAt + "\", \"serverData\":" + serverDataStr + '}';
    }

    static {
        INVALID_KEYS.add("code");
        INVALID_KEYS.add("className");
        INVALID_KEYS.add("fetchWhenSave");
        INVALID_KEYS.add("running");
        INVALID_KEYS.add("acl");
        INVALID_KEYS.add("ACL");
        INVALID_KEYS.add(CREATED_AT);
        INVALID_KEYS.add(UPDATED_AT);
        INVALID_KEYS.add(OBJECT_ID);
        INVALID_KEYS.add("createdPlat");
        INVALID_KEYS.add("updatedPlat");
        INVALID_KEYS.add("error");
        INVALID_KEYS.add("searchClass");
        INVALID_KEYS.add("searchKey");
        INVALID_KEYS.add("targetClass");
    }
}

