/*
 * Decompiled with CFR 0.152.
 */
package com.javabaas.javasdk;

import com.javabaas.javasdk.JBCode;
import com.javabaas.javasdk.JBException;
import com.javabaas.javasdk.JBExceptionHolder;
import com.javabaas.javasdk.JBHttpClient;
import com.javabaas.javasdk.JBHttpMethod;
import com.javabaas.javasdk.JBHttpParams;
import com.javabaas.javasdk.JBQuery;
import com.javabaas.javasdk.JBResult;
import com.javabaas.javasdk.callback.JBBooleanCallback;
import com.javabaas.javasdk.callback.JBObjectCallback;
import java.util.Map;

public class JBPush {
    private JBPushMessage message;
    private JBPushNotification notification;

    public JBPushMessage getMessage() {
        return this.message;
    }

    public void setMessage(JBPushMessage message) {
        this.message = message;
    }

    public JBPushNotification getNotification() {
        return this.notification;
    }

    public void setNotification(JBPushNotification notification) {
        this.notification = notification;
    }

    public boolean sendPush(JBPushQuery query) throws JBException {
        this.sendPushToJavabaas(query, true, new JBBooleanCallback(){

            @Override
            public void done(boolean success, JBException e) {
                if (!success) {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
        return true;
    }

    public void sendPushInBackground(JBPushQuery query, JBBooleanCallback callback) {
        this.sendPushToJavabaas(query, false, callback);
    }

    private void sendPushToJavabaas(JBPushQuery query, boolean sync, final JBBooleanCallback callback) {
        if (this.message == null && this.notification == null) {
            if (callback != null) {
                callback.done(false, new JBException(JBCode.PUSH_ERROR));
            }
            return;
        }
        String path = JBHttpClient.getMasterPath("push");
        query.assembleParameters();
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.POST, new JBHttpParams(query.getParameters()), this, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                if (callback != null) {
                    callback.done(true, null);
                }
            }

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, error);
                }
            }
        });
    }

    public static class JBPushNotification {
        private String title;
        private String alert;
        private String sound;
        private int badge;
        private Map<String, String> extras;
        private Boolean contentAvailable;
        private Boolean mutableContent;

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getAlert() {
            return this.alert;
        }

        public void setAlert(String alert) {
            this.alert = alert;
        }

        public String getSound() {
            return this.sound;
        }

        public void setSound(String sound) {
            this.sound = sound;
        }

        public int getBadge() {
            return this.badge;
        }

        public void setBadge(int badge) {
            this.badge = badge;
        }

        public Map<String, String> getExtras() {
            return this.extras;
        }

        public void setExtras(Map<String, String> extras) {
            this.extras = extras;
        }

        public Boolean getContentAvailable() {
            return this.contentAvailable;
        }

        public void setContentAvailable(Boolean contentAvailable) {
            this.contentAvailable = contentAvailable;
        }

        public Boolean getMutableContent() {
            return this.mutableContent;
        }

        public void setMutableContent(Boolean mutableContent) {
            this.mutableContent = mutableContent;
        }

        public String toString() {
            return "JBPushNotification{title='" + this.title + '\'' + ", alert='" + this.alert + '\'' + ", sound='" + this.sound + '\'' + ", badge=" + this.badge + ", extras=" + this.extras + ", contentAvailable=" + this.contentAvailable + ", mutableContent=" + this.mutableContent + '}';
        }
    }

    public static class JBPushMessage {
        private String title;
        private String alert;
        private String contentType;
        private Map<String, String> extras;

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getAlert() {
            return this.alert;
        }

        public void setAlert(String alert) {
            this.alert = alert;
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public Map<String, String> getExtras() {
            return this.extras;
        }

        public void setExtras(Map<String, String> extras) {
            this.extras = extras;
        }

        public String toString() {
            return "JBPushMessage{title='" + this.title + '\'' + ", alert='" + this.alert + '\'' + ", contentType='" + this.contentType + '\'' + ", extras=" + this.extras + '}';
        }
    }

    public static class JBPushQuery
    extends JBQuery {
        public JBPushQuery() {
            super("_Installation");
        }
    }
}

