/*
 * Decompiled with CFR 0.152.
 */
package com.javabaas.javasdk;

import com.javabaas.javasdk.JBCode;
import com.javabaas.javasdk.JBException;
import com.javabaas.javasdk.JBExceptionHolder;
import com.javabaas.javasdk.JBGeoPoint;
import com.javabaas.javasdk.JBHttpClient;
import com.javabaas.javasdk.JBHttpMethod;
import com.javabaas.javasdk.JBHttpParams;
import com.javabaas.javasdk.JBObject;
import com.javabaas.javasdk.JBQueryConditions;
import com.javabaas.javasdk.JBQueryOperation;
import com.javabaas.javasdk.JBResult;
import com.javabaas.javasdk.JBUtils;
import com.javabaas.javasdk.callback.JBBooleanCallback;
import com.javabaas.javasdk.callback.JBCountCallback;
import com.javabaas.javasdk.callback.JBFindCallBack;
import com.javabaas.javasdk.callback.JBGetCallback;
import com.javabaas.javasdk.callback.JBObjectCallback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JBQuery<T extends JBObject> {
    private String className;
    private Class<T> clazz;
    private String whereSting;
    private Boolean isRunning;
    JBQueryConditions conditions;

    private JBQuery() {
    }

    public String getClassName() {
        return this.className;
    }

    public JBQuery<T> setClassName(String className) {
        this.className = className;
        return this;
    }

    public Class<T> getClazz() {
        return this.clazz;
    }

    public void setClazz(Class<T> clazz) {
        this.clazz = clazz;
    }

    public Boolean getRunning() {
        return this.isRunning;
    }

    public void setRunning(Boolean running) {
        this.isRunning = running;
    }

    public List<String> getInclude() {
        return this.conditions.getInclude();
    }

    public void setInclude(List<String> include) {
        this.conditions.setInclude(include);
    }

    public Set<String> getSelectedKeys() {
        return this.conditions.getSelectedKeys();
    }

    public void setSelectedKeys(Set<String> selectedKeys) {
        this.conditions.setSelectedKeys(selectedKeys);
    }

    public String getWhereSting() {
        return this.whereSting;
    }

    public void setWhereSting(String whereSting) {
        this.whereSting = whereSting;
    }

    public Map<String, String> getParameters() {
        Map<String, String> map = this.conditions.getParameters();
        if (!JBUtils.isEmpty(this.whereSting)) {
            map.put("where", this.whereSting);
        }
        return map;
    }

    public void setParameters(Map<String, String> parameters) {
        this.conditions.setParameters(parameters);
    }

    public Map<String, List<JBQueryOperation>> getWhere() {
        return this.conditions.getWhere();
    }

    public JBQuery(String className) {
        this(className, null);
    }

    JBQuery(String className, Class<T> clazz) {
        JBUtils.checkClassName(className);
        this.className = className;
        this.clazz = clazz;
        this.conditions = new JBQueryConditions();
    }

    public static JBQuery createQuery(JBObject object) {
        if (!JBUtils.isEmpty(object.getClassName())) {
            return new JBQuery(object.getClassName());
        }
        return null;
    }

    public static <T extends JBObject> JBQuery<T> getQuery(String className) {
        return new JBQuery<T>(className);
    }

    public int getLimit() {
        return this.conditions.getLimit();
    }

    public JBQuery<T> setLimit(int limit) {
        this.conditions.setLimit(limit);
        return this;
    }

    public JBQuery<T> limit(int limit) {
        this.setLimit(limit);
        return this;
    }

    public int getSkip() {
        return this.conditions.getSkip();
    }

    public JBQuery<T> setSkip(int skip) {
        this.conditions.setSkip(skip);
        return this;
    }

    public JBQuery<T> skip(int skip) {
        this.setSkip(skip);
        return this;
    }

    public LinkedHashMap<String, Integer> getOrder() {
        return this.conditions.getOrder();
    }

    public JBQuery<T> setOrder(LinkedHashMap<String, Integer> order) {
        this.conditions.setOrder(order);
        return this;
    }

    public JBQuery<T> order(LinkedHashMap<String, Integer> order) {
        this.setOrder(order);
        return this;
    }

    public JBQuery<T> include(String key) {
        this.conditions.include(key);
        return this;
    }

    public JBQuery<T> addAscendingOrder(String key) {
        this.conditions.addAscendingOrder(key);
        return this;
    }

    public JBQuery<T> addDescendingOrder(String key) {
        this.conditions.addDescendingOrder(key);
        return this;
    }

    public JBQuery<T> selectKeys(Collection<String> keys) {
        this.conditions.selectKeys(keys);
        return this;
    }

    public JBQuery<T> orderByAscending(String key) {
        this.conditions.orderByAscending(key);
        return this;
    }

    public JBQuery<T> orderByDescending(String key) {
        this.conditions.orderByDescending(key);
        return this;
    }

    public JBQuery<T> whereExists(String key) {
        this.conditions.whereExists(key);
        return this;
    }

    public JBQuery<T> whereNotExist(String key) {
        this.conditions.whereNotExist(key);
        return this;
    }

    public JBQuery<T> whereEqualTo(String key, Object value) {
        this.conditions.whereEqualTo(key, value);
        return this;
    }

    public JBQuery<T> whereNotEqualTo(String key, Object value) {
        this.conditions.whereNotEqualTo(key, value);
        return this;
    }

    public JBQuery<T> whereGreaterThanOrEqualTo(String key, Object value) {
        this.conditions.whereGreaterThanOrEqualTo(key, value);
        return this;
    }

    public JBQuery<T> whereGreaterThan(String key, Object value) {
        this.conditions.whereGreaterThan(key, value);
        return this;
    }

    public JBQuery<T> whereLessThan(String key, Object value) {
        this.conditions.whereLessThan(key, value);
        return this;
    }

    public JBQuery<T> whereLessThanOrEqualTo(String key, Object value) {
        this.conditions.whereLessThanOrEqualTo(key, value);
        return this;
    }

    public JBQuery<T> whereContains(String key, String substring) {
        this.conditions.whereContains(key, substring);
        return this;
    }

    public JBQuery<T> whereContainedIn(String key, Collection<? extends Object> values) {
        this.conditions.whereContainedIn(key, values);
        return this;
    }

    public JBQuery<T> whereNotContainedIn(String key, Collection<? extends Object> values) {
        this.conditions.whereNotContainedIn(key, values);
        return this;
    }

    public JBQuery<T> whereStartWith(String key, String prefix) {
        this.conditions.whereStartWith(key, prefix);
        return this;
    }

    public JBQuery<T> whereEndWith(String key, String suffix) {
        this.conditions.whereEndWith(key, suffix);
        return this;
    }

    public JBQuery<T> whereWithinKilometers(String key, JBGeoPoint point, double maxDistance) {
        this.conditions.whereWithinKilometers(key, point, maxDistance);
        return this;
    }

    public JBQuery<T> whereMatches(String key, String regex) {
        this.conditions.whereMatches(key, regex);
        return this;
    }

    public JBQuery<T> whereMatches(String key, String regex, String modifiers) {
        this.conditions.whereMatches(key, regex, modifiers);
        return this;
    }

    private JBQuery<T> addWhereItem(JBQueryOperation op) {
        this.conditions.addWhereItem(op);
        return this;
    }

    private JBQuery<T> addOrItems(JBQueryOperation op) {
        this.conditions.addOrItems(op);
        return this;
    }

    private JBQuery<T> addAndItems(JBQuery query) {
        this.conditions.addAndItems(query.conditions);
        return this;
    }

    protected JBQuery<T> addWhereItem(String key, String op, Object value) {
        this.conditions.addWhereItem(key, op, value);
        return this;
    }

    public JBQuery<T> whereMatchesQuery(String key, JBQuery<?> query) {
        return this.whereMatchesKeyInQuery(key, null, query, null);
    }

    public JBQuery<T> whereMatchesKeyInQuery(String key, String searchKey, JBQuery<?> query, String targetClass) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("searchClass", query.getClassName());
        map.put("where", query.conditions.compileWhereOperationMap());
        if (!JBUtils.isEmpty(searchKey)) {
            map.put("searchKey", searchKey);
        }
        if (!JBUtils.isEmpty(targetClass)) {
            map.put("targetClass", targetClass);
        }
        HashMap<String, HashMap<String, Object>> sub = new HashMap<String, HashMap<String, Object>>();
        sub.put("$sub", map);
        this.conditions.addWhereItem(key, "__eq", sub);
        return this;
    }

    public T get(String objectId) throws JBException {
        if (JBUtils.isEmpty(objectId)) {
            throw new JBException(JBCode.REQUEST_PARAM_ERROR);
        }
        final Object[] result = new Object[]{null};
        this.getFromJavaBaas(objectId, true, new JBGetCallback<T>(){

            @Override
            public void done(boolean success, T object, JBException e) {
                if (success) {
                    result[0] = object;
                } else {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
        return (T)((JBObject)result[0]);
    }

    public void getInBackground(String objectId, JBGetCallback<T> callback) {
        this.getFromJavaBaas(objectId, false, callback);
    }

    private void getFromJavaBaas(String objectId, boolean sync, final JBGetCallback<T> callback) {
        if (JBUtils.isEmpty(objectId)) {
            callback.done(false, null, new JBException(JBCode.REQUEST_PARAM_ERROR));
            return;
        }
        this.assembleParameters();
        String path = JBHttpClient.getObjectPath(this.className, objectId);
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.GET, new JBHttpParams(this.getParameters()), null, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                if (callback == null) {
                    return;
                }
                try {
                    List list = JBQuery.this.processResults(result.getData());
                    if (list.size() > 0) {
                        JBObject o = (JBObject)list.get(0);
                        callback.done(true, o, null);
                    } else {
                        callback.done(false, null, new JBException(JBCode.OBJECT_NOT_EXIST));
                    }
                }
                catch (Exception e) {
                    callback.done(false, null, new JBException(JBCode.INTERNAL_JSON_ERROR));
                }
            }

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, null, error);
                }
            }
        });
    }

    public List<T> find() throws JBException {
        this.assembleParameters();
        String path = JBHttpClient.getObjectPath(this.className);
        final List[] result = new List[]{null};
        this.findFromJavaBaas(true, new JBFindCallBack(){

            public void done(boolean success, List objects, JBException e) {
                if (success) {
                    result[0] = objects;
                } else {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
        return result[0];
    }

    public void findInBackground(JBFindCallBack<T> callBack) {
        this.findFromJavaBaas(false, callBack);
    }

    private void findFromJavaBaas(boolean sync, final JBFindCallBack callback) {
        this.assembleParameters();
        String path = JBHttpClient.getObjectPath(this.className + "/find");
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.POST, null, this.getParameters(), sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                block3: {
                    try {
                        List list = JBQuery.this.processResults(result.getData());
                        if (callback != null) {
                            callback.done(true, list, null);
                        }
                    }
                    catch (Exception e) {
                        if (callback == null) break block3;
                        callback.done(false, null, new JBException(JBCode.INTERNAL_JSON_ERROR));
                    }
                }
            }

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, null, error);
                }
            }
        });
    }

    public int count() throws JBException {
        final int[] value = new int[]{0};
        this.countFromJavabaas(true, new JBCountCallback(){

            @Override
            public void done(boolean success, int count, JBException e) {
                if (success) {
                    value[0] = count;
                } else {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
        return value[0];
    }

    public void countInBackground(JBCountCallback callback) {
        this.countFromJavabaas(false, callback);
    }

    private void countFromJavabaas(boolean sync, final JBCountCallback callback) {
        this.assembleParameters();
        String path = JBHttpClient.getObjectPath(this.className, "count");
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.GET, new JBHttpParams(this.getParameters()), null, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                if (callback == null) {
                    return;
                }
                try {
                    int count = (Integer)result.getData().get("count");
                    callback.done(true, count, null);
                }
                catch (Exception e) {
                    callback.done(false, 0, new JBException(JBCode.INTERNAL_JSON_ERROR));
                }
            }

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, 0, error);
                }
            }
        });
    }

    public void deleteByQuery() throws JBException {
        this.deleteByQueryFromJavabaas(true, new JBBooleanCallback(){

            @Override
            public void done(boolean success, JBException e) {
                if (!success) {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
    }

    public void deleteByQueryInBackground() {
        this.deleteByQueryFromJavabaas(false, null);
    }

    public void deleteByQueryInBackground(JBBooleanCallback callback) {
        this.deleteByQueryFromJavabaas(false, callback);
    }

    private void deleteByQueryFromJavabaas(boolean sync, final JBBooleanCallback callback) {
        this.assembleParameters();
        String path = JBHttpClient.getObjectPath(this.className, "deleteByQuery");
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.DELETE, new JBHttpParams(this.getParameters()), null, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                if (callback != null) {
                    callback.done(true, null);
                }
            }

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, error);
                }
            }
        });
    }

    protected Map<String, String> assembleParameters() {
        return this.conditions.assembleParameters();
    }

    protected List<T> processResults(Map<String, Object> map) throws Exception {
        ArrayList<Map> list;
        if (map == null || map.get("result") == null) {
            return Collections.emptyList();
        }
        LinkedList<JBObject> result = new LinkedList<JBObject>();
        Object o = map.get("result");
        if (o instanceof Map) {
            Map om = (Map)o;
            if (om.size() == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList<Map>();
            list.add(om);
        } else if (o instanceof Collection) {
            list = (ArrayList<Map>)map.get("result");
        } else {
            return Collections.emptyList();
        }
        for (Map object : list) {
            JBObject jbObject = this.clazz != null ? (JBObject)this.clazz.newInstance() : new JBObject(this.className);
            JBUtils.copyPropertiesFromMapToJBObject(jbObject, object);
            result.add(jbObject);
        }
        return result;
    }
}

