/*
 * Decompiled with CFR 0.152.
 */
package com.javabaas.javasdk;

import com.javabaas.javasdk.JBException;
import com.javabaas.javasdk.JBGeoPoint;
import com.javabaas.javasdk.JBObject;
import com.javabaas.javasdk.JBQueryOperation;
import com.javabaas.javasdk.JBUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JBQueryConditions {
    public static final String WHERE = "where";
    public static final String LIMIT = "limit";
    public static final String SKIP = "skip";
    public static final String ORDER = "order";
    public static final String INCLUDE = "include";
    public static final String KEYS = "keys";
    Map<String, List<JBQueryOperation>> where = new HashMap<String, List<JBQueryOperation>>();
    private List<String> include = new LinkedList<String>();
    private Set<String> selectedKeys;
    private int limit;
    private int skip = -1;
    private LinkedHashMap<String, Integer> order;
    private Map<String, String> parameters = new HashMap<String, String>();
    private boolean whereContainsGeo = false;

    public JBQueryConditions() {
        this.order = new LinkedHashMap();
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getSkip() {
        return this.skip;
    }

    public void setSkip(int skip) {
        this.skip = skip;
    }

    public LinkedHashMap<String, Integer> getOrder() {
        return this.order;
    }

    public void setOrder(LinkedHashMap<String, Integer> order) {
        this.order = order;
    }

    public Map<String, List<JBQueryOperation>> getWhere() {
        return this.where;
    }

    public void setWhere(Map<String, List<JBQueryOperation>> where) {
        this.where = where;
    }

    public List<String> getInclude() {
        return this.include;
    }

    public void setInclude(List<String> include) {
        this.include = include;
    }

    public Set<String> getSelectedKeys() {
        return this.selectedKeys;
    }

    public void setSelectedKeys(Set<String> selectedKeys) {
        this.selectedKeys = selectedKeys;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void addAscendingOrder(String key) {
        this.order.remove(key);
        this.order.put(key, 1);
    }

    public void orderByAscending(String key) {
        this.order = new LinkedHashMap();
        this.order.put(key, 1);
    }

    public void orderByGeoPoint() {
        this.whereContainsGeo = true;
    }

    public void addDescendingOrder(String key) {
        this.order.remove(key);
        this.order.put(key, -1);
    }

    public void orderByDescending(String key) {
        this.order = new LinkedHashMap();
        this.order.put(key, -1);
    }

    public void include(String key) {
        this.include.add(key);
    }

    public void selectKeys(Collection<String> keys) {
        if (this.selectedKeys == null) {
            this.selectedKeys = new HashSet<String>();
        }
        this.selectedKeys.addAll(keys);
    }

    public Map<String, Object> compileWhereOperationMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        block4: for (Map.Entry<String, List<JBQueryOperation>> entry : this.where.entrySet()) {
            Object opList;
            if (entry.getKey().equals("$or")) {
                opList = new ArrayList();
                for (JBQueryOperation op : entry.getValue()) {
                    opList.add(op.toResult());
                }
                List existsOr = (List)result.get("$or");
                if (existsOr != null) {
                    existsOr.addAll(opList);
                    continue;
                }
                result.put("$or", opList);
                continue;
            }
            if (entry.getKey().equals("$and")) {
                opList = new ArrayList();
                for (JBQueryOperation op : entry.getValue()) {
                    opList.add(op.getValue());
                }
                List existsAnd = (List)result.get("$and");
                if (existsAnd != null) {
                    existsAnd.addAll(opList);
                    continue;
                }
                result.put("$and", opList);
                continue;
            }
            switch (entry.getValue().size()) {
                case 0: {
                    break;
                }
                case 1: {
                    for (JBQueryOperation op : entry.getValue()) {
                        result.put(entry.getKey(), op.toResult());
                    }
                    continue block4;
                }
                default: {
                    opList = new ArrayList();
                    HashMap opMap = new HashMap();
                    boolean[] hasEqual = new boolean[]{false};
                    for (JBQueryOperation op : entry.getValue()) {
                        opList.add(op.toResult(entry.getKey()));
                        if ("__eq".equals(op.getOp())) {
                            hasEqual[0] = true;
                        }
                        if (hasEqual[0]) continue;
                        opMap.putAll((Map)op.toResult());
                    }
                    if (hasEqual[0]) {
                        List existsAnd = (List)result.get("$and");
                        if (existsAnd != null) {
                            existsAnd.addAll(opList);
                            break;
                        }
                        result.put("$and", opList);
                        break;
                    }
                    result.put(entry.getKey(), opMap);
                }
            }
        }
        return result;
    }

    public Map<String, String> assembleParameters() {
        if (this.where.size() > 0) {
            try {
                this.parameters.put(WHERE, JBUtils.writeValueAsString(this.compileWhereOperationMap()));
            }
            catch (JBException jBException) {
                // empty catch block
            }
        }
        if (this.limit > 0) {
            this.parameters.put(LIMIT, String.valueOf(this.limit));
        }
        if (this.skip > 0) {
            this.parameters.put(SKIP, String.valueOf(this.skip));
        }
        if (this.order.size() > 0) {
            try {
                this.parameters.put(ORDER, JBUtils.writeValueAsString(this.order));
            }
            catch (JBException jBException) {}
        } else if (this.whereContainsGeo) {
            this.parameters.put(ORDER, "{}");
        }
        if (this.include != null && this.include.size() > 0) {
            this.parameters.put(INCLUDE, this.join(this.include, ","));
        }
        if (this.selectedKeys != null && this.selectedKeys.size() > 0) {
            this.parameters.put(KEYS, this.join(new ArrayList<String>(this.selectedKeys), ","));
        }
        return this.parameters;
    }

    private String join(List<String> list, String conjunction) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String item : list) {
            if (first) {
                first = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public void addWhereItem(JBQueryOperation op) {
        List<JBQueryOperation> ops = this.where.get(op.getKey());
        if (ops == null) {
            ops = new LinkedList<JBQueryOperation>();
            this.where.put(op.getKey(), ops);
        }
        this.removeSameOperation(ops, op);
        ops.add(op);
    }

    public void addWhereItem(String key, String op, Object value) {
        this.addWhereItem(new JBQueryOperation(key, value, op));
    }

    public void addOrItems(JBQueryOperation op) {
        List<JBQueryOperation> ops = this.where.get("$or");
        if (ops == null) {
            ops = new LinkedList<JBQueryOperation>();
            this.where.put("$or", ops);
        }
        this.removeSameOperation(ops, op);
        ops.add(op);
    }

    public void addAndItems(JBQueryConditions conditions) {
        Map<String, Object> queryOperationMap = conditions.compileWhereOperationMap();
        JBQueryOperation op = new JBQueryOperation("$and", queryOperationMap, "$and");
        List<JBQueryOperation> ops = this.where.get("$and");
        if (ops == null) {
            ops = new LinkedList<JBQueryOperation>();
            this.where.put("$and", ops);
        }
        this.removeSameOperation(ops, op);
        ops.add(op);
    }

    private void removeSameOperation(List<JBQueryOperation> ops, JBQueryOperation op) {
        Iterator<JBQueryOperation> iterator = ops.iterator();
        while (iterator.hasNext()) {
            JBQueryOperation operation = iterator.next();
            if (!operation.sameOp(op)) continue;
            iterator.remove();
        }
    }

    public void whereEqualTo(String key, Object value) {
        if (value instanceof JBObject) {
            JBObject object = (JBObject)value;
            if (!JBUtils.isEmpty(object.className) && !JBUtils.isEmpty(object.objectId)) {
                LinkedHashMap<String, String> pointer = new LinkedHashMap<String, String>();
                pointer.put("__type", "Pointer");
                pointer.put("className", object.className);
                pointer.put("_id", object.objectId);
                this.addWhereItem(key, "__eq", pointer);
            }
        } else {
            this.addWhereItem(key, "__eq", value);
        }
    }

    public void whereNotEqualTo(String key, Object value) {
        this.addWhereItem(key, "$ne", value);
    }

    public void whereExists(String key) {
        this.addWhereItem(key, "$exists", true);
    }

    public void whereNotExist(String key) {
        this.addWhereItem(key, "$exists", false);
    }

    public void whereGreaterThanOrEqualTo(String key, Object value) {
        this.addWhereItem(key, "$gte", value);
    }

    public void whereGreaterThan(String key, Object value) {
        this.addWhereItem(key, "$gt", value);
    }

    public void whereLessThan(String key, Object value) {
        this.addWhereItem(key, "$lt", value);
    }

    public void whereLessThanOrEqualTo(String key, Object value) {
        this.addWhereItem(key, "$lte", value);
    }

    public void whereContainedIn(String key, Collection<? extends Object> values) {
        this.addWhereItem(key, "$in", values);
    }

    public void whereNotContainedIn(String key, Collection<? extends Object> values) {
        this.addWhereItem(key, "$nin", values);
    }

    public void whereStartWith(String key, String prefix) {
        this.whereMatches(key, String.format("^%s.*", prefix));
    }

    public void whereEndWith(String key, String suffix) {
        this.whereMatches(key, String.format(".*%s$", suffix));
    }

    public void whereWithinKilometers(String key, JBGeoPoint point, double maxDistance) {
        HashMap<String, Object> geometry = new HashMap<String, Object>(16);
        geometry.put("type", "Point");
        geometry.put("coordinates", JBUtils.listFromGeoPoint(point));
        Map<String, Object> nearSphere = JBUtils.createMap("$geometry", geometry);
        nearSphere.put("$maxDistance", maxDistance);
        Map<String, Object> map = JBUtils.createMap("$nearSphere", nearSphere);
        this.addWhereItem(key, null, map);
        this.orderByGeoPoint();
    }

    public void whereContains(String key, String substring) {
        this.whereMatches(key, String.format(".*%s.*", substring));
    }

    public void whereMatches(String key, String regex) {
        this.addWhereItem(key, "$regex", regex);
    }

    public void whereMatches(String key, String regex, String modifiers) {
        this.addWhereItem(key, "$regex", regex);
        this.addWhereItem(key, "$options", modifiers);
    }
}

