/*
 * Decompiled with CFR 0.152.
 */
package com.javabaas.javasdk;

import com.javabaas.javasdk.JBUtils;
import java.util.HashMap;

public class JBQueryOperation {
    public static final String EQUAL_OP = "__eq";
    public static final String OR_OP = "$or";
    public static final String AND_OP = "$and";
    private String key;
    private Object value;
    private String op;

    public JBQueryOperation(String key, Object value, String op) {
        this.key = key;
        this.value = value;
        this.op = op;
    }

    public String getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    public String getOp() {
        return this.op;
    }

    public Object toResult() {
        if (this.op == null || this.op.equals(EQUAL_OP) || this.op.equals(OR_OP)) {
            return this.value;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(this.op, this.value);
        return map;
    }

    public Object toResult(String key) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(key, this.toResult());
        return map;
    }

    public boolean sameOp(JBQueryOperation other) {
        return JBUtils.equals(this.key, other.key) && JBUtils.equals(this.op, other.op);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.op == null ? 0 : this.op.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JBQueryOperation other = (JBQueryOperation)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.op == null ? other.op != null : !this.op.equals(other.op)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

