/*
 * Decompiled with CFR 0.152.
 */
package com.javabaas.javasdk;

import com.javabaas.javasdk.JBCode;
import com.javabaas.javasdk.JBException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class JBResult
extends HashMap<String, Object> {
    public static int SUCCESS = 0;

    public static JBResult success() {
        return new JBResult(JBCode.SUCCESS);
    }

    public static JBResult error(int code) {
        return new JBResult(code, "");
    }

    private JBResult() {
    }

    public JBResult(JBCode simpleCode) {
        this(simpleCode.getCode(), simpleCode.getMessage());
    }

    public JBResult(int code, String message) {
        this.put("data", new LinkedHashMap());
        this.setCode(code);
        this.setMessage(message);
    }

    public JBResult(String message, Map<? extends String, ?> map) {
        this.setCode(JBCode.SUCCESS.getCode());
        this.setMessage(message);
        this.put("data", new LinkedHashMap());
        this.putDataAll(map);
    }

    public static JBResult fromError(JBException e) {
        return new JBResult(e.getCode(), e.getMessage());
    }

    public int getCode() {
        if (this.get("code") != null) {
            return (Integer)this.get("code");
        }
        return 0;
    }

    public void setCode(int code) {
        this.put("code", code);
    }

    public String getMessage() {
        return (String)this.get("message");
    }

    public void setMessage(String message) {
        this.put("message", message);
    }

    public JBResult putData(String key, Object value) {
        ((LinkedHashMap)this.get("data")).put(key, value);
        return this;
    }

    public Object getData(String key) {
        return ((LinkedHashMap)this.get("data")).get(key);
    }

    public LinkedHashMap<String, Object> getData() {
        return (LinkedHashMap)this.get("data");
    }

    public JBResult putDataAll(Map<? extends String, ?> map) {
        ((LinkedHashMap)this.get("data")).putAll(map);
        return this;
    }
}

