/*
 * Decompiled with CFR 0.152.
 */
package com.javabaas.javasdk;

import com.javabaas.javasdk.JBAcl;
import com.javabaas.javasdk.JBException;
import com.javabaas.javasdk.JBExceptionHolder;
import com.javabaas.javasdk.JBHttpClient;
import com.javabaas.javasdk.JBHttpMethod;
import com.javabaas.javasdk.JBObject;
import com.javabaas.javasdk.JBUser;
import com.javabaas.javasdk.callback.JBBooleanCallback;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class JBRole
extends JBObject {
    private static final String USERS = "users";
    private static final String ROLES = "roles";

    public String getName() {
        return this.getString("name");
    }

    public void setName(String name) {
        this.put("name", name);
    }

    public List<String> getRoles() {
        return this.getList(ROLES);
    }

    public List<String> getUsers() {
        return this.getList(USERS);
    }

    public JBRole() {
        super(JBRole.roleClassName());
    }

    public JBRole(String name) {
        super(JBRole.roleClassName());
        this.setName(name);
    }

    public JBRole(String name, JBAcl acl) {
        super(JBRole.roleClassName());
        this.setName(name);
        this.setAcl(acl);
    }

    public static String roleClassName() {
        return "_Role";
    }

    public void addUser(JBUser user) {
        ArrayList<String> userIds = new ArrayList<String>();
        userIds.add(user.getObjectId());
        super.addUniqueArray(USERS, userIds);
    }

    public void addUsers(List<JBUser> users) {
        ArrayList<String> userIds = new ArrayList<String>();
        for (JBUser user : users) {
            userIds.add(user.getObjectId());
        }
        super.addUniqueArray(USERS, userIds);
    }

    public void removeUser(JBUser user) {
        ArrayList<String> userIds = new ArrayList<String>();
        userIds.add(user.getObjectId());
        super.removeArray(USERS, userIds);
    }

    public void removeUsers(List<JBUser> users) {
        ArrayList<String> userIds = new ArrayList<String>();
        for (JBUser user : users) {
            userIds.add(user.getObjectId());
        }
        super.removeArray(USERS, userIds);
    }

    public void addRole(JBRole role) {
        ArrayList<String> roleIds = new ArrayList<String>();
        roleIds.add(role.getObjectId());
        super.addUniqueArray(ROLES, roleIds);
    }

    public void addRoles(List<JBRole> roles) {
        ArrayList<String> roleIds = new ArrayList<String>();
        for (JBRole role : roles) {
            roleIds.add(role.getObjectId());
        }
        super.addUniqueArray(ROLES, roles);
    }

    public void removeRole(JBRole role) {
        ArrayList<String> roleIds = new ArrayList<String>();
        roleIds.add(role.getObjectId());
        super.removeArray(ROLES, roleIds);
    }

    public void removeRoles(List<JBRole> roles) {
        ArrayList<String> roleIds = new ArrayList<String>();
        for (JBRole role : roles) {
            roleIds.add(role.getObjectId());
        }
        super.removeArray(ROLES, roleIds);
    }

    @Override
    public void save() throws JBException {
        this.saveRoleToJavaBaas(true, new JBBooleanCallback(){

            @Override
            public void done(boolean success, JBException e) {
                if (!success) {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
    }

    @Override
    public void saveInBackground() {
        this.saveRoleToJavaBaas(false, null);
    }

    @Override
    public void saveInBackground(JBBooleanCallback callback) {
        this.saveRoleToJavaBaas(false, callback);
    }

    private void saveRoleToJavaBaas(boolean sync, JBBooleanCallback callback) {
        String path = JBHttpClient.getRolePath(null);
        Map<String, Object> body = this.getObjectForSaveBody();
        this.saveToJavaBaas(path, JBHttpMethod.POST, null, body, sync, callback);
    }
}

