/*
 * Decompiled with CFR 0.152.
 */
package com.javabaas.javasdk;

import com.javabaas.javasdk.JBException;
import com.javabaas.javasdk.JBExceptionHolder;
import com.javabaas.javasdk.JBHttpClient;
import com.javabaas.javasdk.JBHttpMethod;
import com.javabaas.javasdk.JBHttpParams;
import com.javabaas.javasdk.JBResult;
import com.javabaas.javasdk.callback.JBBooleanCallback;
import com.javabaas.javasdk.callback.JBObjectCallback;
import java.util.LinkedHashMap;
import java.util.Map;

public class JBSms {
    public static void send(String phone, String templateId, Map<String, Object> params) throws JBException {
        JBSms.sendToJavabaas(phone, templateId, params, true, new JBBooleanCallback(){

            @Override
            public void done(boolean success, JBException e) {
                if (!success) {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
    }

    public static void sendInBackground(String phone, String templateId, Map<String, Object> params, JBBooleanCallback callback) {
        JBSms.sendToJavabaas(phone, templateId, params, false, callback);
    }

    private static void sendToJavabaas(String phone, String templateId, Map<String, Object> body, boolean sync, JBBooleanCallback callback) {
        String path = JBHttpClient.getMasterPath("sms");
        JBHttpParams params = new JBHttpParams();
        params.put("phone", phone);
        params.put("templateId", templateId);
        JBSms.sendSms(path, params, body, sync, callback);
    }

    public static void sendSmsCode(String phone, long expiresTime, Map<String, Object> params) throws JBException {
        JBSms.sendSmsCodeToJavabaas(phone, expiresTime, params, true, new JBBooleanCallback(){

            @Override
            public void done(boolean success, JBException e) {
                if (!success) {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
    }

    public static void sendSmsCodeInBackground(String phone, long expiresTime, Map<String, Object> params, JBBooleanCallback callback) {
        JBSms.sendSmsCodeToJavabaas(phone, expiresTime, params, false, callback);
    }

    private static void sendSmsCodeToJavabaas(String phone, long expiresTime, Map<String, Object> body, boolean sync, JBBooleanCallback callback) {
        String path = JBHttpClient.getMasterPath("sms/smsCode");
        JBHttpParams params = new JBHttpParams();
        params.put("phone", phone);
        params.put("ttl", expiresTime);
        JBSms.sendSms(path, params, body, sync, callback);
    }

    private static void sendSms(String path, JBHttpParams params, Object body, boolean sync, final JBBooleanCallback callback) {
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.POST, params, body, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                if (callback == null) {
                    return;
                }
                callback.done(true, null);
            }

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, error);
                }
            }
        });
    }

    public static boolean validateSmsCode(String phone, String code) throws JBException {
        final boolean[] result = new boolean[]{false};
        JBSms.validateSmsCodeFromJavabaas(phone, code, true, new JBBooleanCallback(){

            @Override
            public void done(boolean success, JBException e) {
                result[0] = success;
                if (e != null) {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
        return result[0];
    }

    public static void validateSmsCodeInBackground(String phone, String code, JBBooleanCallback callback) {
        JBSms.validateSmsCodeFromJavabaas(phone, code, false, callback);
    }

    private static void validateSmsCodeFromJavabaas(String phone, String code, boolean sync, final JBBooleanCallback callback) {
        String path = JBHttpClient.getMasterPath("sms/verifyCode");
        JBHttpParams params = new JBHttpParams();
        params.put("phone", phone);
        params.put("code", code);
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.GET, params, null, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                if (callback == null) {
                    return;
                }
                boolean success = false;
                LinkedHashMap<String, Object> data = result.getData();
                if (data != null && data.get("verifyResult") != null) {
                    success = (Boolean)data.get("verifyResult");
                }
                callback.done(success, null);
            }

            @Override
            public void onFailure(JBException error) {
                callback.done(false, error);
            }
        });
    }
}

