/*
 * Decompiled with CFR 0.152.
 */
package com.javabaas.javasdk;

import com.javabaas.javasdk.JBAuth;
import com.javabaas.javasdk.JBCode;
import com.javabaas.javasdk.JBException;
import com.javabaas.javasdk.JBExceptionHolder;
import com.javabaas.javasdk.JBHttpClient;
import com.javabaas.javasdk.JBHttpMethod;
import com.javabaas.javasdk.JBHttpParams;
import com.javabaas.javasdk.JBObject;
import com.javabaas.javasdk.JBQuery;
import com.javabaas.javasdk.JBResult;
import com.javabaas.javasdk.JBSnsType;
import com.javabaas.javasdk.JBUtils;
import com.javabaas.javasdk.callback.JBBooleanCallback;
import com.javabaas.javasdk.callback.JBLoginCallback;
import com.javabaas.javasdk.callback.JBObjectCallback;
import com.javabaas.javasdk.callback.JBUpdatePasswordCallback;
import java.util.HashMap;
import java.util.Map;

public class JBUser
extends JBObject {
    private static final String SESSIONTOKEN = "sessionToken";
    private static final String USERNAME = "username";
    private static final String EMAIL = "email";
    private static final String PASSWORD = "password";
    private static final String PHONE = "phone";
    private static final String CODE = "code";
    private static final String AUTH = "auth";
    private static JBUser currentUser;

    public static JBUser getCurrentUser() {
        return currentUser;
    }

    public static void updateCurrentUser(JBUser user) {
        currentUser = user;
    }

    public String getSessionToken() {
        return (String)this.get(SESSIONTOKEN);
    }

    public void setSessionToken(String sessionToken) {
        this.put(SESSIONTOKEN, sessionToken);
    }

    public String getUsername() {
        return (String)this.get(USERNAME);
    }

    public void setUsername(String username) {
        this.put(USERNAME, username);
    }

    public String getEmail() {
        return (String)this.get(EMAIL);
    }

    public void setEmail(String email) {
        this.put(EMAIL, email);
    }

    public void setPassword(String password) {
        this.put(PASSWORD, password);
    }

    public String getPhone() {
        return (String)this.get(PHONE);
    }

    public void setPhone(String phone) {
        this.put(PHONE, phone);
    }

    public JBUser() {
        super(JBUser.userClassName());
    }

    public static String userClassName() {
        return "_User";
    }

    public static JBQuery<JBUser> getQuery() {
        return new JBQuery<JBUser>(JBUser.userClassName(), JBUser.class);
    }

    public void signUp() throws JBException {
        this.signUpFromJavabaas(true, new JBBooleanCallback(){

            @Override
            public void done(boolean success, JBException e) {
                if (!success) {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
    }

    public void signUpInBackground(JBBooleanCallback callback) {
        this.signUpFromJavabaas(false, callback);
    }

    private void signUpFromJavabaas(boolean sync, JBBooleanCallback callback) {
        String path = JBHttpClient.getUserPath();
        Map<String, Object> body = this.getObjectForSaveBody();
        this.saveToJavaBaas(path, JBHttpMethod.POST, null, body, sync, callback);
    }

    public static void getSmsCode(String phone) throws JBException {
        JBUser.getSmsCodeFromJavabaas(phone, true, new JBBooleanCallback(){

            @Override
            public void done(boolean success, JBException e) {
                if (!success) {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
    }

    public static void getSmsCodeInBackground(String phone, JBBooleanCallback callback) {
        JBUser.getSmsCodeFromJavabaas(phone, false, callback);
    }

    private static void getSmsCodeFromJavabaas(String phone, boolean sync, final JBBooleanCallback callback) {
        if (JBUtils.isEmpty(phone)) {
            callback.done(false, new JBException(JBCode.REQUEST_PARAM_ERROR));
            return;
        }
        String path = JBHttpClient.getUserPath("getSmsCode/" + phone);
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.GET, null, null, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                if (callback != null) {
                    callback.done(true, null);
                }
            }

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, error);
                }
            }
        });
    }

    public void signUpWithSns(JBAuth auth, JBSnsType type) throws JBException {
        this.signUpWithSnsFromJavabaas(auth, type, true, new JBBooleanCallback(){

            @Override
            public void done(boolean success, JBException e) {
                if (!success) {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
    }

    public void signUpWithSnsInBackground(JBAuth auth, JBSnsType type, JBBooleanCallback callback) {
        this.signUpWithSnsFromJavabaas(auth, type, false, callback);
    }

    private void signUpWithSnsFromJavabaas(JBAuth auth, JBSnsType type, boolean sync, JBBooleanCallback callback) {
        String path = JBHttpClient.getUserPath("registerWithSns/" + type.getCode());
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put(AUTH, auth);
        body.put("user", this.getObjectForSaveBody());
        this.saveToJavaBaas(path, JBHttpMethod.POST, null, body, sync, callback);
    }

    public static JBUser login(String username, String password) throws JBException {
        final JBUser[] users = new JBUser[]{null};
        JBUser.loginFromJavabaas(username, password, true, new JBLoginCallback(){

            @Override
            public void done(boolean success, JBUser user, JBException e) {
                if (success) {
                    users[0] = user;
                } else {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
        return users[0];
    }

    public static void loginInBackground(String username, String password, JBLoginCallback callback) {
        JBUser.loginFromJavabaas(username, password, false, callback);
    }

    private static void loginFromJavabaas(String username, String password, boolean sync, final JBLoginCallback callback) {
        if (JBUtils.isEmpty(username) || JBUtils.isEmpty(password)) {
            callback.done(false, null, new JBException(JBCode.REQUEST_PARAM_ERROR));
            return;
        }
        String path = JBHttpClient.getUserPath("login");
        JBHttpParams params = new JBHttpParams();
        params.put(USERNAME, username);
        params.put(PASSWORD, password);
        final JBUser user = new JBUser();
        user.setUsername(username);
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.GET, params, null, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                if (callback == null) {
                    return;
                }
                JBUser.processResult(user, result.getData());
                callback.done(true, user, null);
            }

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, null, error);
                }
            }
        });
    }

    public static JBUser loginWithPhone(String phone, String code) throws JBException {
        final JBUser[] users = new JBUser[]{null};
        JBUser.loginWithPhoneFromJavabaas(phone, code, true, new JBLoginCallback(){

            @Override
            public void done(boolean success, JBUser user, JBException e) {
                if (success) {
                    users[0] = user;
                } else {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
        return users[0];
    }

    public static void loginWithPhoneInBackground(String phone, String code, JBLoginCallback callback) {
        JBUser.loginWithPhoneFromJavabaas(phone, code, false, callback);
    }

    private static void loginWithPhoneFromJavabaas(String phone, String code, boolean sync, JBLoginCallback callback) {
        if (JBUtils.isEmpty(phone) || JBUtils.isEmpty(code)) {
            callback.done(false, null, new JBException(JBCode.REQUEST_PARAM_ERROR));
            return;
        }
        String path = JBHttpClient.getUserPath("loginWithPhone");
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put(PHONE, phone);
        body.put(CODE, code);
        JBUser.sendRequestForLogin(path, body, sync, callback);
    }

    public static JBUser loginWithSns(JBAuth auth, JBSnsType type) throws JBException {
        final JBUser[] users = new JBUser[]{null};
        JBUser.loginWithSnsFromJavabaas(auth, type, true, new JBLoginCallback(){

            @Override
            public void done(boolean success, JBUser user, JBException e) {
                if (!success) {
                    JBExceptionHolder.add(e);
                } else {
                    users[0] = user;
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
        return users[0];
    }

    public static void loginWithSnsInBackground(JBAuth auth, JBSnsType type, JBLoginCallback callback) {
        JBUser.loginWithSnsFromJavabaas(auth, type, false, callback);
    }

    private static void loginWithSnsFromJavabaas(JBAuth auth, JBSnsType type, boolean sync, JBLoginCallback callback) {
        String path = JBHttpClient.getUserPath("loginWithSns/" + type.getCode());
        JBUser.sendRequestForLogin(path, auth, sync, callback);
    }

    private static void sendRequestForLogin(String path, Map<String, Object> body, boolean sync, final JBLoginCallback callback) {
        final JBUser user = new JBUser();
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.POST, null, body, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                if (callback == null) {
                    return;
                }
                JBUser.processResult(user, result.getData());
                callback.done(true, user, null);
            }

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, null, error);
                }
            }
        });
    }

    public static void getBindCode(String phone) throws JBException {
        JBUser.getBindCodeFromJavabaas(phone, true, new JBBooleanCallback(){

            @Override
            public void done(boolean success, JBException e) {
                if (!success) {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
    }

    public static void getBindCodeInBackground(String phone, JBBooleanCallback callback) {
        JBUser.getBindCodeFromJavabaas(phone, false, callback);
    }

    private static void getBindCodeFromJavabaas(String phone, boolean sync, final JBBooleanCallback callback) {
        if (JBUtils.isEmpty(phone)) {
            callback.done(false, new JBException(JBCode.REQUEST_PARAM_ERROR));
            return;
        }
        String path = JBHttpClient.getUserPath("getBindCode/" + phone);
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.GET, null, null, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                if (callback != null) {
                    callback.done(true, null);
                }
            }

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, error);
                }
            }
        });
    }

    public static void bindPhone(String phone, String code) throws JBException {
        JBUser.bindPhoneWithJavabaas(phone, code, true, new JBBooleanCallback(){

            @Override
            public void done(boolean success, JBException e) {
                if (!success) {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
    }

    public static void bindPhoneInBackground(String phone, String code, JBBooleanCallback callback) {
        JBUser.bindPhoneWithJavabaas(phone, code, false, callback);
    }

    private static void bindPhoneWithJavabaas(String phone, String code, boolean sync, final JBBooleanCallback callback) {
        if (JBUtils.isEmpty(phone) || JBUtils.isEmpty(code)) {
            callback.done(false, new JBException(JBCode.REQUEST_PARAM_ERROR));
            return;
        }
        String path = JBHttpClient.getUserPath("bindPhone");
        HashMap<String, String> body = new HashMap<String, String>();
        body.put(PHONE, phone);
        body.put(CODE, code);
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.POST, null, body, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                if (callback != null) {
                    callback.done(true, null);
                }
            }

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, error);
                }
            }
        });
    }

    private static void resetSessionToken(String userId) throws JBException {
        String path = JBHttpClient.getUserPath(userId + "/resetSessionToken");
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.PUT, null, null, true, new JBObjectCallback(){

            @Override
            public void onFailure(JBException error) {
                JBExceptionHolder.add(error);
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
    }

    public String updatePassword(String oldPassword, String newPassword) throws JBException {
        String sessionToken = null;
        this.updatePasswordFromJavabaas(oldPassword, newPassword, true, new JBUpdatePasswordCallback(){

            @Override
            public void done(boolean success, String sessionToken, JBException e) {
                block0: {
                    if (success) break block0;
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
        return sessionToken;
    }

    public void updatePasswordInBackground(String oldPassword, String newPassword, JBUpdatePasswordCallback callback) {
        this.updatePasswordFromJavabaas(oldPassword, newPassword, false, callback);
    }

    private void updatePasswordFromJavabaas(String oldPassword, String newPassword, boolean sync, final JBUpdatePasswordCallback callback) {
        String userId = this.getObjectId();
        if (JBUtils.isEmpty(userId)) {
            callback.done(false, null, new JBException(JBCode.USER_NOT_LOGIN));
            return;
        }
        String path = JBHttpClient.getUserPath(userId + "/updatePassword");
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("oldPassword", oldPassword);
        body.put("newPassword", newPassword);
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.PUT, null, body, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                if (callback == null) {
                    return;
                }
                if (result.getData().get(JBUser.SESSIONTOKEN) == null) {
                    callback.done(false, null, new JBException(JBCode.INTERNAL_ERROR.getCode(), "\u672a\u80fd\u83b7\u53d6sessionToken"));
                } else {
                    String sessionToken = (String)result.getData().get(JBUser.SESSIONTOKEN);
                    callback.done(true, sessionToken, null);
                }
            }

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, null, error);
                }
            }
        });
    }

    public void update() throws JBException {
        this.updateFromJavabaas(true, new JBBooleanCallback(){

            @Override
            public void done(boolean success, JBException e) {
                if (!success) {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
    }

    public void updateInBackground(JBBooleanCallback callback) {
        this.updateFromJavabaas(false, callback);
    }

    private void updateFromJavabaas(boolean sync, final JBBooleanCallback callback) {
        String userId = this.getObjectId();
        if (JBUtils.isEmpty(userId)) {
            callback.done(false, new JBException(JBCode.USER_NOT_LOGIN));
            return;
        }
        String path = JBHttpClient.getUserPath(userId);
        Map<String, Object> body = this.getObjectForSaveBody();
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.PUT, null, body, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                if (callback != null) {
                    callback.done(true, null);
                }
            }

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, error);
                }
            }
        });
    }

    protected static void processResult(JBUser user, Map<String, Object> map) {
        if (map == null || map.get("result") == null) {
            return;
        }
        Object o = map.get("result");
        if (o instanceof Map) {
            JBUtils.copyPropertiesFromMapToJBObject(user, (Map)o);
        }
    }
}

