/*
 * Decompiled with CFR 0.152.
 */
package com.javabaas.javasdk.annotation;

import com.javabaas.javasdk.annotation.JBCloudAnnotation;
import com.javabaas.javasdk.annotation.JBHookAnnotation;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.ReflectionUtils;

public class JBAnnotationScanner
implements BeanPostProcessor {
    public static Set<Class> classSet;
    private Class originalBeanClass;
    private static final List<Class<? extends Annotation>> annotationsClasses;

    public Object postProcessBeforeInitialization(Object o, String s) throws BeansException {
        final AtomicBoolean add = new AtomicBoolean();
        ReflectionUtils.doWithMethods(o.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException {
                add.set(true);
            }
        }, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

            public boolean matches(Method method) {
                for (Class aClass : annotationsClasses) {
                    if (!method.isAnnotationPresent(aClass)) continue;
                    return true;
                }
                return false;
            }
        });
        if (add.get()) {
            this.originalBeanClass = o.getClass();
        }
        return o;
    }

    public Object postProcessAfterInitialization(Object o, String s) throws BeansException {
        if (this.originalBeanClass != null) {
            if (classSet == null) {
                classSet = new HashSet<Class>();
            }
            classSet.add(this.originalBeanClass);
            this.originalBeanClass = null;
        }
        return o;
    }

    static {
        annotationsClasses = Arrays.asList(JBCloudAnnotation.class, JBHookAnnotation.class);
    }
}

