/*
 * Decompiled with CFR 0.152.
 */
package com.javabaas.javasdk.annotation;

import com.javabaas.javasdk.JB;
import com.javabaas.javasdk.annotation.OnCloud;
import com.javabaas.javasdk.annotation.OnHook;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.ReflectionUtils;

public class SpringAnnotationScanner
implements BeanPostProcessor {
    private static final List<Class<? extends Annotation>> annotations = Arrays.asList(OnCloud.class, OnHook.class);
    private final JB jb;
    private Class originalBeanClass;

    public SpringAnnotationScanner(JB jb) {
        this.jb = jb;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (this.originalBeanClass != null) {
            this.jb.addListeners(bean, this.originalBeanClass);
            this.originalBeanClass = null;
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        final AtomicBoolean add = new AtomicBoolean();
        ReflectionUtils.doWithMethods(bean.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException {
                add.set(true);
            }
        }, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

            public boolean matches(Method method) {
                for (Class annotationClass : annotations) {
                    if (!method.isAnnotationPresent(annotationClass)) continue;
                    return true;
                }
                return false;
            }
        });
        if (add.get()) {
            this.originalBeanClass = bean.getClass();
        }
        return bean;
    }
}

