/*
 * Decompiled with CFR 0.152.
 */
package com.javabaas.javasdk.annotation.scanner;

import com.javabaas.javasdk.JB;
import com.javabaas.javasdk.JBException;
import com.javabaas.javasdk.annotation.OnCloud;
import com.javabaas.javasdk.annotation.scanner.AnnotationScanner;
import com.javabaas.javasdk.cloud.CloudListener;
import com.javabaas.javasdk.cloud.CloudRequest;
import com.javabaas.javasdk.cloud.CloudResponse;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class OnCloudScanner
implements AnnotationScanner {
    @Override
    public Class<? extends Annotation> getScanAnnotation() {
        return OnCloud.class;
    }

    @Override
    public void addListener(JB jb, final Object object, final Method method, Annotation annot) {
        OnCloud annotation = (OnCloud)annot;
        String name = annotation.value();
        if (name.trim().length() == 0) {
            throw new IllegalArgumentException("OnCloud\u6ce8\u89e3\u5fc5\u987b\u6307\u5b9a\u4e91\u65b9\u6cd5\u540d!");
        }
        final int cloudRequestIndex = this.paramIndex(method, CloudRequest.class);
        jb.addCloudListener(name, new CloudListener(){

            @Override
            public CloudResponse onCloud(CloudRequest request) throws Throwable {
                Object[] args = new Object[method.getParameterTypes().length];
                if (cloudRequestIndex != -1) {
                    args[cloudRequestIndex] = request;
                }
                try {
                    return (CloudResponse)method.invoke(object, args);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    if (e.getCause() instanceof JBException) {
                        CloudResponse response = new CloudResponse();
                        response.setCode(((JBException)e.getCause()).getCode());
                        response.setMessage(e.getCause().getMessage());
                        return response;
                    }
                    throw e.getCause();
                }
            }
        });
    }

    @Override
    public void validate(Method method, Class<?> clazz) {
        if (!CloudResponse.class.equals(method.getReturnType())) {
            throw new IllegalArgumentException("\u4e91\u65b9\u6cd5\u8fd4\u56de\u7c7b\u578b\u9519\u8bef \u8fd4\u56de\u7c7b\u578b\u5fc5\u987b\u4e3aCloudResponse " + clazz + "." + method.getName());
        }
    }

    private int paramIndex(Method method, Class<?> clazz) {
        int index = 0;
        for (Class<?> type : method.getParameterTypes()) {
            if (type.equals(clazz)) {
                return index;
            }
            ++index;
        }
        return -1;
    }
}

