/*
 * Decompiled with CFR 0.152.
 */
package com.javabaas.javasdk.cloud;

import com.javabaas.javasdk.JBCode;
import com.javabaas.javasdk.JBException;
import com.javabaas.javasdk.JBUtils;
import com.javabaas.javasdk.cloud.JBRequest;
import java.util.Map;
import java.util.Optional;

public class CloudRequest
extends JBRequest {
    private String name;
    private Map<String, String> params;
    private String body;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Optional<String> getOptionalParam(String key) {
        return this.getParams() == null ? null : Optional.ofNullable(this.getParams().get(key));
    }

    public String getRequiredParam(String key) throws JBException {
        if (this.getParams() == null) {
            throw new JBException(JBCode.REQUEST_PARAM_ERROR);
        }
        String value = this.getParams().get(key);
        if (JBUtils.isEmpty(value)) {
            throw new JBException(JBCode.REQUEST_PARAM_ERROR);
        }
        return value;
    }

    public int getRequiredIntParam(String key) throws JBException {
        if (this.getParams() == null) {
            throw new JBException(JBCode.REQUEST_PARAM_ERROR);
        }
        String value = this.getParams().get(key);
        if (JBUtils.isEmpty(value)) {
            throw new JBException(JBCode.REQUEST_PARAM_ERROR);
        }
        try {
            int num = Integer.parseInt(value);
            return num;
        }
        catch (NumberFormatException e) {
            throw new JBException(JBCode.REQUEST_PARAM_ERROR);
        }
    }

    public boolean getRequiredBooleanParam(String key) throws JBException {
        if (this.getParams() == null) {
            throw new JBException(JBCode.REQUEST_PARAM_ERROR);
        }
        String value = this.getParams().get(key);
        if (JBUtils.isEmpty(value)) {
            throw new JBException(JBCode.REQUEST_PARAM_ERROR);
        }
        try {
            boolean bool = Boolean.parseBoolean(value);
            return bool;
        }
        catch (NumberFormatException e) {
            throw new JBException(JBCode.REQUEST_PARAM_ERROR);
        }
    }

    @Override
    public String requestType() {
        return JBRequest.REQUEST_CLOUD;
    }
}

