/*
 * Decompiled with CFR 0.152.
 */
package com.javabaas.javasdk.cloud;

import com.javabaas.javasdk.JB;
import com.javabaas.javasdk.JBException;
import com.javabaas.javasdk.JBExceptionHolder;
import com.javabaas.javasdk.JBHttpClient;
import com.javabaas.javasdk.JBHttpMethod;
import com.javabaas.javasdk.JBHttpParams;
import com.javabaas.javasdk.JBResult;
import com.javabaas.javasdk.JBUtils;
import com.javabaas.javasdk.annotation.HookEvent;
import com.javabaas.javasdk.callback.JBCloudCallback;
import com.javabaas.javasdk.callback.JBObjectCallback;
import com.javabaas.javasdk.cloud.CloudSetting;
import com.javabaas.javasdk.cloud.HookSetting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class JBCloud {
    public static boolean deploy(String callbackUrl) throws JBException {
        CloudSetting cloudSetting = JBCloud.getCloudSetting(callbackUrl);
        JBCloud.deployToJavabaas(cloudSetting, true, new JBCloudCallback(){

            @Override
            public void done(boolean success, Map<String, Object> data, JBException e) {
                if (!success) {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
        return true;
    }

    public static void deployInBackground(String callbackUrl, JBCloudCallback callback) {
        CloudSetting cloudSetting = JBCloud.getCloudSetting(callbackUrl);
        JBCloud.deployToJavabaas(cloudSetting, false, callback);
    }

    public static boolean deploy(CloudSetting setting) throws JBException {
        JBCloud.deployToJavabaas(setting, true, new JBCloudCallback(){

            @Override
            public void done(boolean success, Map<String, Object> data, JBException e) {
                if (!success) {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
        return true;
    }

    public static void deployInBackground(CloudSetting setting, JBCloudCallback callback) {
        JBCloud.deployToJavabaas(setting, false, callback);
    }

    private static void deployToJavabaas(CloudSetting setting, boolean sync, final JBCloudCallback callback) {
        String path = JBHttpClient.getCloudDeployPath();
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.POST, null, setting, true, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                if (callback != null) {
                    callback.done(true, result.getData(), null);
                }
            }

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, null, error);
                }
            }
        });
    }

    private static CloudSetting getCloudSetting(String remote) {
        CloudSetting cloudSetting = new CloudSetting();
        if (!JBUtils.isEmpty(remote)) {
            cloudSetting.setCustomerHost(remote.endsWith("/") ? remote : remote + "/");
        }
        Set<String> clouds = JB.getInstance().getCloudListeners().keySet();
        ArrayList<String> cloudFunctions = new ArrayList<String>(clouds);
        cloudSetting.setCloudFunctions(cloudFunctions);
        HashMap<String, HookSetting> hookSettings = new HashMap<String, HookSetting>();
        Set<String> hooks = JB.getInstance().getHookListeners().keySet();
        for (String hookName : hooks) {
            String clazzName = HookSetting.hookClazzName(hookName);
            HookEvent event = HookSetting.hookEvent(hookName);
            if (clazzName == null || event == null) continue;
            HookSetting hookSetting = (HookSetting)hookSettings.get(clazzName);
            if (hookSetting == null) {
                hookSetting = new HookSetting();
            }
            switch (event) {
                case BEFORE_INSERT: {
                    hookSetting.setBeforeInsert(true);
                    break;
                }
                case AFTER_INSERT: {
                    hookSetting.setAfterInsert(true);
                    break;
                }
                case BEFORE_UPDATE: {
                    hookSetting.setBeforeUpdate(true);
                    break;
                }
                case AFTER_UPDATE: {
                    hookSetting.setAfterUpdate(true);
                    break;
                }
                case BEFORE_DELETE: {
                    hookSetting.setBeforeDelete(true);
                    break;
                }
                case AFTER_DELETE: {
                    hookSetting.setAfterDelete(true);
                }
            }
            hookSettings.put(clazzName, hookSetting);
            cloudSetting.setHookSettings(hookSettings);
        }
        return cloudSetting;
    }

    public static boolean delete() throws JBException {
        JBCloud.deleteFromJavabaas(true, new JBCloudCallback(){

            @Override
            public void done(boolean success, Map<String, Object> data, JBException e) {
                if (!success) {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
        return true;
    }

    public static void deleteInBackground(JBCloudCallback callback) {
        JBCloud.deleteFromJavabaas(false, callback);
    }

    private static void deleteFromJavabaas(boolean sync, final JBCloudCallback callback) {
        String path = JBHttpClient.getCloudDeployPath();
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.DELETE, null, null, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                if (callback != null) {
                    callback.done(true, result.getData(), null);
                }
            }

            @Override
            public void onFailure(JBException error) {
                if (callback == null) {
                    return;
                }
                callback.done(false, null, error);
            }
        });
    }

    public static Map<String, Object> cloud(String cloudName, Map<String, Object> params, Map<String, Object> body) throws JBException {
        final Map[] result = new Map[]{null};
        JBCloud.cloudFromJavabaas(cloudName, params, body, true, new JBCloudCallback(){

            @Override
            public void done(boolean success, Map<String, Object> data, JBException e) {
                if (success) {
                    result[0] = data;
                } else {
                    JBExceptionHolder.add(e);
                }
            }
        });
        if (JBExceptionHolder.exists()) {
            throw JBExceptionHolder.remove();
        }
        return result[0];
    }

    public static void cloudInBackground(String cloudName, Map<String, Object> params, Map<String, Object> body, JBCloudCallback callback) {
        JBCloud.cloudFromJavabaas(cloudName, params, body, false, callback);
    }

    private static void cloudFromJavabaas(String cloudName, Map<String, Object> params, Map<String, Object> body, boolean sync, final JBCloudCallback callback) {
        String path = JBHttpClient.getCloudPath(cloudName);
        JBHttpParams jbHttpParams = new JBHttpParams(params);
        JBHttpClient.INSTANCE().sendRequest(path, JBHttpMethod.POST, jbHttpParams, body, sync, new JBObjectCallback(){

            @Override
            public void onSuccess(JBResult result) {
                if (callback == null) {
                    return;
                }
                callback.done(true, result.getData(), null);
            }

            @Override
            public void onFailure(JBException error) {
                if (callback != null) {
                    callback.done(false, null, error);
                }
            }
        });
    }
}

