/*
 * Decompiled with CFR 0.152.
 */
package com.javabaas.javasdk.cloud;

import com.javabaas.javasdk.JB;
import com.javabaas.javasdk.annotation.scanner.AnnotationScanner;
import com.javabaas.javasdk.annotation.scanner.OnCloudScanner;
import com.javabaas.javasdk.annotation.scanner.OnHookScanner;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;

public class ScannerEngine {
    private static final List<? extends AnnotationScanner> annotations = Arrays.asList(new OnCloudScanner(), new OnHookScanner());

    public void scan(JB jb, Object object, Class<?> clazz) throws IllegalArgumentException {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            for (AnnotationScanner annotationScanner : annotations) {
                Annotation ann = method.getAnnotation(annotationScanner.getScanAnnotation());
                if (ann == null) continue;
                annotationScanner.validate(method, clazz);
                this.makeAccessible(method);
                annotationScanner.addListener(jb, object, method, ann);
            }
        }
    }

    private boolean isEquals(Method method1, Method method2) {
        return method1.getName().equals(method2.getName()) && method1.getReturnType().equals(method2.getReturnType()) && Arrays.equals(method1.getParameterTypes(), method2.getParameterTypes());
    }

    private void makeAccessible(Method method) {
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
            method.setAccessible(true);
        }
    }
}

