/*
 * Decompiled with CFR 0.152.
 */
package com.javadocmd.simplelatlng.window;

import com.javadocmd.simplelatlng.LatLng;
import com.javadocmd.simplelatlng.LatLngTool;
import com.javadocmd.simplelatlng.util.LatLngConfig;
import com.javadocmd.simplelatlng.util.LengthUnit;
import com.javadocmd.simplelatlng.window.LatLngWindow;

public class RectangularWindow
extends LatLngWindow<RectangularWindow> {
    private long latitudeDelta;
    private long longitudeDelta;
    private long minLatitude;
    private long maxLatitude;
    private long minLongitude;
    private long maxLongitude;
    private boolean crosses180thMeridian;
    private LatLng center;

    public RectangularWindow(LatLng center, double deltaLat, double deltaLng) {
        this.setWindow(center, deltaLat, deltaLng);
    }

    public RectangularWindow(LatLng center, double width, double height, LengthUnit unit) {
        double deltaLat = LatLngWindow.lengthToLatitudeDelta(height, unit);
        double deltaLng = LatLngWindow.lengthToLongitudeDelta(width, unit, deltaLat);
        this.setWindow(center, deltaLat, deltaLng);
    }

    public void setWindow(LatLng center, double deltaLat, double deltaLng) {
        if (center == null) {
            throw new IllegalArgumentException("Invalid center point.");
        }
        if (Double.isNaN(deltaLat) || Double.isInfinite(deltaLat)) {
            throw new IllegalArgumentException("Invalid latitude delta.");
        }
        if (Double.isNaN(deltaLng) || Double.isInfinite(deltaLng)) {
            throw new IllegalArgumentException("Invalid longitude delta.");
        }
        double dlat = Math.min(Math.abs(deltaLat), 180.0);
        this.setLatWindow(center.getLatitude(), dlat);
        double dlng = Math.min(Math.abs(deltaLng), 360.0);
        this.setLngWindow(center.getLongitude(), dlng);
        this.center = center;
    }

    private void setLatWindow(double centerLat, double deltaLat) {
        double lat1 = LatLngTool.normalizeLatitude(centerLat + deltaLat / 2.0);
        double lat2 = LatLngTool.normalizeLatitude(centerLat - deltaLat / 2.0);
        this.maxLatitude = LatLngConfig.doubleToLong(Math.max(lat1, lat2));
        this.minLatitude = LatLngConfig.doubleToLong(Math.min(lat1, lat2));
        this.latitudeDelta = LatLngConfig.doubleToLong(deltaLat);
    }

    private void setLngWindow(double centerLng, double deltaLng) {
        double lng1 = centerLng + deltaLng / 2.0;
        double lng2 = centerLng - deltaLng / 2.0;
        this.crosses180thMeridian = lng1 > 180.0 || lng2 < -180.0;
        lng1 = LatLngTool.normalizeLongitude(lng1);
        lng2 = LatLngTool.normalizeLongitude(lng2);
        this.maxLongitude = LatLngConfig.doubleToLong(Math.max(lng1, lng2));
        this.minLongitude = LatLngConfig.doubleToLong(Math.min(lng1, lng2));
        this.longitudeDelta = LatLngConfig.doubleToLong(deltaLng);
    }

    @Override
    public boolean contains(LatLng point) {
        if (point.getLatitudeInternal() > this.maxLatitude || point.getLatitudeInternal() < this.minLatitude) {
            return false;
        }
        return !(this.crosses180thMeridian ? point.getLongitudeInternal() < this.maxLongitude && point.getLongitudeInternal() > this.minLongitude : point.getLongitudeInternal() > this.maxLongitude || point.getLongitudeInternal() < this.minLongitude);
    }

    @Override
    public boolean overlaps(RectangularWindow window) {
        if (window.getMaxLatitude() < (double)this.minLatitude || window.getMinLatitude() > (double)this.maxLatitude) {
            return false;
        }
        return !(this.crosses180thMeridian ? window.maxLongitude > this.minLongitude || window.minLongitude < this.maxLongitude : window.maxLongitude < this.minLongitude || window.minLongitude > this.maxLongitude);
    }

    public double getHeight(LengthUnit unit) {
        return LatLngWindow.latitudeDeltaToLength(LatLngConfig.longToDouble(this.latitudeDelta), unit);
    }

    public double getWidth(LengthUnit unit) {
        return LatLngWindow.longitudeDeltaToLength(LatLngConfig.longToDouble(this.longitudeDelta), unit, this.center.getLatitude());
    }

    @Override
    public LatLng getCenter() {
        return this.center;
    }

    public boolean crosses180thMeridian() {
        return this.crosses180thMeridian;
    }

    public double getLatitudeDelta() {
        return LatLngConfig.longToDouble(this.latitudeDelta);
    }

    public double getLongitudeDelta() {
        return LatLngConfig.longToDouble(this.longitudeDelta);
    }

    public double getMinLatitude() {
        return LatLngConfig.longToDouble(this.minLatitude);
    }

    public double getMaxLatitude() {
        return LatLngConfig.longToDouble(this.maxLatitude);
    }

    public double getMinLongitude() {
        return LatLngConfig.longToDouble(this.minLongitude);
    }

    public double getMaxLongitude() {
        return LatLngConfig.longToDouble(this.maxLongitude);
    }
}

