/*
 * Decompiled with CFR 0.152.
 */
package com.javadocmd.simplelatlng.window;

import com.javadocmd.simplelatlng.LatLng;
import com.javadocmd.simplelatlng.LatLngTool;
import com.javadocmd.simplelatlng.util.LatLngConfig;
import com.javadocmd.simplelatlng.util.LengthUnit;
import com.javadocmd.simplelatlng.window.LatLngWindow;

public class RectangularWindow
extends LatLngWindow<RectangularWindow> {
    private long latitudeDelta;
    private long longitudeDelta;
    private long minLatitude;
    private long maxLatitude;
    private long leftLongitude;
    private long rightLongitude;
    private boolean crosses180thMeridian;
    private LatLng center;

    public RectangularWindow(LatLng center, double deltaLat, double deltaLng) {
        this.setWindow(center, deltaLat, deltaLng);
    }

    public RectangularWindow(LatLng northeast, LatLng southwest) {
        if (northeast.isPolar() || southwest.isPolar()) {
            throw new IllegalArgumentException("Window constructor is not valid for polar coordinates.");
        }
        if (northeast.getLatitudeInternal() < southwest.getLatitudeInternal()) {
            throw new IllegalArgumentException("Provided northeast point is not north of provided southwest point.");
        }
        double deltaLat = northeast.getLatitude() - southwest.getLatitude();
        double deltaLng = northeast.getLongitude() - southwest.getLongitude();
        if (northeast.getLongitude() < southwest.getLongitude()) {
            deltaLng += 360.0;
        }
        double centerLat = southwest.getLatitude() + deltaLat / 2.0;
        double centerLng = southwest.getLongitude() + deltaLng / 2.0;
        this.setWindow(new LatLng(centerLat, centerLng), deltaLat, deltaLng);
    }

    public RectangularWindow(LatLng center, double width, double height, LengthUnit unit) {
        double deltaLat = LatLngWindow.lengthToLatitudeDelta(height, unit);
        double deltaLng = LatLngWindow.lengthToLongitudeDelta(width, unit, center.getLatitude());
        this.setWindow(center, deltaLat, deltaLng);
    }

    public RectangularWindow(LatLng center, double widthHeight, LengthUnit unit) {
        this(center, widthHeight, widthHeight, unit);
    }

    public void setWindow(LatLng center, double deltaLat, double deltaLng) {
        if (center == null) {
            throw new IllegalArgumentException("Invalid center point.");
        }
        if (Double.isNaN(deltaLat) || Double.isInfinite(deltaLat)) {
            throw new IllegalArgumentException("Invalid latitude delta.");
        }
        if (Double.isNaN(deltaLng) || Double.isInfinite(deltaLng)) {
            throw new IllegalArgumentException("Invalid longitude delta.");
        }
        double dlat = Math.min(Math.abs(deltaLat), 180.0);
        this.setLatWindow(center.getLatitude(), dlat);
        double dlng = Math.min(Math.abs(deltaLng), 360.0);
        this.setLngWindow(center.getLongitude(), dlng);
        this.center = center;
    }

    private void setLatWindow(double centerLat, double deltaLat) {
        double lat1 = LatLngTool.normalizeLatitude(centerLat + deltaLat / 2.0);
        double lat2 = LatLngTool.normalizeLatitude(centerLat - deltaLat / 2.0);
        this.maxLatitude = LatLngConfig.doubleToLong(Math.max(lat1, lat2));
        this.minLatitude = LatLngConfig.doubleToLong(Math.min(lat1, lat2));
        this.latitudeDelta = LatLngConfig.doubleToLong(deltaLat);
    }

    private void setLngWindow(double centerLng, double deltaLng) {
        double left = centerLng - deltaLng / 2.0;
        double right = centerLng + deltaLng / 2.0;
        this.crosses180thMeridian = LatLngConfig.doubleToLong(right) > 180000000L || LatLngConfig.doubleToLong(left) < -180000000L;
        left = LatLngTool.normalizeLongitude(left);
        right = LatLngTool.normalizeLongitude(right);
        this.leftLongitude = LatLngConfig.doubleToLong(left);
        this.rightLongitude = LatLngConfig.doubleToLong(right);
        this.longitudeDelta = LatLngConfig.doubleToLong(deltaLng);
    }

    @Override
    public boolean contains(LatLng point) {
        if (point.getLatitudeInternal() > this.maxLatitude || point.getLatitudeInternal() < this.minLatitude) {
            return false;
        }
        long longitude = point.getLongitudeInternal();
        if (this.crosses180thMeridian) {
            if (longitude < 0L && longitude > this.rightLongitude) {
                return false;
            }
            if (longitude >= 0L && longitude < this.leftLongitude) {
                return false;
            }
        } else if (longitude > this.rightLongitude || longitude < this.leftLongitude) {
            return false;
        }
        return true;
    }

    @Override
    public boolean overlaps(RectangularWindow window) {
        if (window.maxLatitude < this.minLatitude || window.minLatitude > this.maxLatitude) {
            return false;
        }
        long thisLeft = this.leftLongitude;
        long thisRight = this.rightLongitude;
        long thatLeft = window.leftLongitude;
        long thatRight = window.rightLongitude;
        if (thisRight < thisLeft) {
            thisRight += 360000000L;
        }
        if (thatRight < thatLeft) {
            thatRight += 360000000L;
        }
        return thisRight >= thatLeft && thisLeft <= thatRight;
    }

    public double getHeight(LengthUnit unit) {
        return LatLngWindow.latitudeDeltaToLength(LatLngConfig.longToDouble(this.latitudeDelta), unit);
    }

    public double getWidth(LengthUnit unit) {
        return LatLngWindow.longitudeDeltaToLength(LatLngConfig.longToDouble(this.longitudeDelta), unit, this.center.getLatitude());
    }

    @Override
    public LatLng getCenter() {
        return this.center;
    }

    public boolean crosses180thMeridian() {
        return this.crosses180thMeridian;
    }

    public double getLatitudeDelta() {
        return LatLngConfig.longToDouble(this.latitudeDelta);
    }

    public double getLongitudeDelta() {
        return LatLngConfig.longToDouble(this.longitudeDelta);
    }

    public double getMinLatitude() {
        return LatLngConfig.longToDouble(this.minLatitude);
    }

    public double getMaxLatitude() {
        return LatLngConfig.longToDouble(this.maxLatitude);
    }

    public double getLeftLongitude() {
        return LatLngConfig.longToDouble(this.leftLongitude);
    }

    public double getRightLongitude() {
        return LatLngConfig.longToDouble(this.rightLongitude);
    }

    public String toString() {
        return String.format("center: %s; lat range: [%s,%s]; lng range: [%s,%s]; meridian? %s", this.getCenter().toString(), LatLngConfig.DEGREE_FORMAT.format(this.getMinLatitude()), LatLngConfig.DEGREE_FORMAT.format(this.getMaxLatitude()), LatLngConfig.DEGREE_FORMAT.format(this.getLeftLongitude()), LatLngConfig.DEGREE_FORMAT.format(this.getRightLongitude()), Boolean.toString(this.crosses180thMeridian()));
    }
}

