/*
 * Decompiled with CFR 0.152.
 */
package com.javadocmd.simplelatlng;

import com.javadocmd.simplelatlng.LatLng;
import com.javadocmd.simplelatlng.util.LatLngConfig;
import com.javadocmd.simplelatlng.util.LengthUnit;

public class LatLngTool {
    public static double distance(LatLng point1, LatLng point2, LengthUnit unit) {
        return LatLngTool.distanceInRadians(point1, point2) * LatLngConfig.getEarthRadius(unit);
    }

    public static double distanceInRadians(LatLng point1, LatLng point2) {
        double lat1R = Math.toRadians(point1.getLatitude());
        double lat2R = Math.toRadians(point2.getLatitude());
        double dLatR = Math.abs(lat2R - lat1R);
        double dLngR = Math.abs(Math.toRadians(point2.getLongitude() - point1.getLongitude()));
        double a = Math.sin(dLatR / 2.0) * Math.sin(dLatR / 2.0) + Math.cos(lat1R) * Math.cos(lat2R) * Math.sin(dLngR / 2.0) * Math.sin(dLngR / 2.0);
        return 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
    }

    public static double initialBearing(LatLng start, LatLng end) {
        return LatLngTool.normalizeBearing(Math.toDegrees(LatLngTool.initialBearingInRadians(start, end)));
    }

    public static double initialBearingInRadians(LatLng start, LatLng end) {
        double lat1R = Math.toRadians(start.getLatitude());
        double lat2R = Math.toRadians(end.getLatitude());
        double dLngR = Math.toRadians(end.getLongitude() - start.getLongitude());
        double a = Math.sin(dLngR) * Math.cos(lat2R);
        double b = Math.cos(lat1R) * Math.sin(lat2R) - Math.sin(lat1R) * Math.cos(lat2R) * Math.cos(dLngR);
        return Math.atan2(a, b);
    }

    public static LatLng travel(LatLng start, double initialBearing, double distance, LengthUnit unit) {
        double bR = Math.toRadians(initialBearing);
        double lat1R = Math.toRadians(start.getLatitude());
        double lon1R = Math.toRadians(start.getLongitude());
        double dR = distance / LatLngConfig.getEarthRadius(unit);
        double a = Math.sin(dR) * Math.cos(lat1R);
        double lat2 = Math.asin(Math.sin(lat1R) * Math.cos(dR) + a * Math.cos(bR));
        double lon2 = lon1R + Math.atan2(Math.sin(bR) * a, Math.cos(dR) - Math.sin(lat1R) * Math.sin(lat2));
        return new LatLng(Math.toDegrees(lat2), Math.toDegrees(lon2));
    }

    public static double normalizeLatitude(double latitude) {
        if (Double.isNaN(latitude)) {
            return Double.NaN;
        }
        if (latitude > 0.0) {
            return Math.min(latitude, 90.0);
        }
        return Math.max(latitude, -90.0);
    }

    public static double normalizeLongitude(double longitude) {
        if (Double.isNaN(longitude) || Double.isInfinite(longitude)) {
            return Double.NaN;
        }
        double longitudeResult = longitude % 360.0;
        if (longitudeResult > 180.0) {
            double diff = longitudeResult - 180.0;
            longitudeResult = -180.0 + diff;
        } else if (longitudeResult < -180.0) {
            double diff = longitudeResult + 180.0;
            longitudeResult = 180.0 + diff;
        }
        return longitudeResult;
    }

    public static double normalizeBearing(double bearing) {
        if (Double.isNaN(bearing) || Double.isInfinite(bearing)) {
            return Double.NaN;
        }
        double bearingResult = bearing % 360.0;
        if (bearingResult < 0.0) {
            bearingResult += 360.0;
        }
        return bearingResult;
    }

    private LatLngTool() {
    }

    public static class Bearing {
        public static final double NORTH = 0.0;
        public static final double NORTH_EAST = 45.0;
        public static final double EAST = 90.0;
        public static final double SOUTH_EAST = 135.0;
        public static final double SOUTH = 180.0;
        public static final double SOUTH_WEST = 225.0;
        public static final double WEST = 270.0;
        public static final double NORTH_WEST = 315.0;

        private Bearing() {
        }
    }
}

