/*
 * Decompiled with CFR 0.152.
 */
package com.javadocmd.simplelatlng.util;

public enum LengthUnit {
    MILE(0.6213712),
    NAUTICAL_MILE(0.5399568),
    ROD(0.0050292),
    KILOMETER(1.0),
    METER(1000.0);

    public static final LengthUnit PRIMARY;
    private double scaleFactor;

    private LengthUnit(double scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    public double convertTo(LengthUnit toUnit, double value) {
        double _value = value;
        if (this == PRIMARY) {
            if (toUnit == PRIMARY) {
                return value;
            }
        } else {
            _value = value / this.scaleFactor;
        }
        return _value * toUnit.scaleFactor;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    static {
        PRIMARY = KILOMETER;
    }
}

