/*
 * Decompiled with CFR 0.152.
 */
package com.javadocmd.simplelatlng.util;

import com.javadocmd.simplelatlng.util.LengthUnit;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;

public class LatLngConfig {
    public static final double DEGREE_TOLERANCE = 1.0E-6;
    private static ThreadLocal<NumberFormat> DEGREE_FORMAT;
    public static final double EARTH_MEAN_RADIUS_KILOMETERS = 6371.009;
    private static double[] EARTH_RADIUS;

    public static NumberFormat getDegreeFormat() {
        return DEGREE_FORMAT.get();
    }

    public static synchronized void setDegreeFormat(ThreadLocal<NumberFormat> formatThreadLocal) {
        DEGREE_FORMAT = formatThreadLocal;
    }

    public static double getEarthRadius(LengthUnit unit) {
        return EARTH_RADIUS[unit.ordinal()];
    }

    public static synchronized void setEarthRadius(double radius, LengthUnit unit) {
        EARTH_RADIUS = new double[LengthUnit.values().length];
        for (LengthUnit toUnit : LengthUnit.values()) {
            LatLngConfig.EARTH_RADIUS[toUnit.ordinal()] = unit.convertTo(toUnit, radius);
        }
    }

    private LatLngConfig() {
    }

    public static long doubleToLong(double value) {
        return (long)(value / 1.0E-6);
    }

    public static double longToDouble(long value) {
        return (double)value * 1.0E-6;
    }

    static {
        LatLngConfig.setDegreeFormat(new ThreadLocal<NumberFormat>(){

            @Override
            protected NumberFormat initialValue() {
                return new DecimalFormat("0.000000", DecimalFormatSymbols.getInstance(Locale.US));
            }
        });
        LatLngConfig.setEarthRadius(6371.009, LengthUnit.KILOMETER);
    }
}

