/*
 * Decompiled with CFR 0.152.
 */
package com.javadocmd.simplelatlng.util;

public enum LengthUnit {
    MILE(0.6213712),
    NAUTICAL_MILE(0.5399568),
    ROD(198.8387815),
    KILOMETER(1.0),
    METER(1000.0);

    public static final LengthUnit PRIMARY;
    private double scaleFactor;

    private LengthUnit(double scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    public double convertTo(LengthUnit toUnit, double value) {
        if (this == toUnit) {
            return value;
        }
        double _value = value;
        if (this != PRIMARY) {
            _value /= this.scaleFactor;
        }
        if (toUnit != PRIMARY) {
            _value *= toUnit.scaleFactor;
        }
        return _value;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    static {
        PRIMARY = KILOMETER;
    }
}

