/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.anno.fun.parse;

import com.javaoffers.brief.modelhelper.anno.ColName;
import com.javaoffers.brief.modelhelper.anno.fun.noneparam.math.Rand;
import com.javaoffers.brief.modelhelper.anno.fun.noneparam.time.Curdate;
import com.javaoffers.brief.modelhelper.anno.fun.noneparam.time.CurrentDate;
import com.javaoffers.brief.modelhelper.anno.fun.noneparam.time.CurrentTime;
import com.javaoffers.brief.modelhelper.anno.fun.noneparam.time.Curtime;
import com.javaoffers.brief.modelhelper.anno.fun.noneparam.time.Now;
import com.javaoffers.brief.modelhelper.anno.fun.noneparam.time.UnixTimestamp;
import com.javaoffers.brief.modelhelper.anno.fun.params.CaseWhen;
import com.javaoffers.brief.modelhelper.anno.fun.params.If;
import com.javaoffers.brief.modelhelper.anno.fun.params.IfEq;
import com.javaoffers.brief.modelhelper.anno.fun.params.IfGt;
import com.javaoffers.brief.modelhelper.anno.fun.params.IfGte;
import com.javaoffers.brief.modelhelper.anno.fun.params.IfLt;
import com.javaoffers.brief.modelhelper.anno.fun.params.IfLte;
import com.javaoffers.brief.modelhelper.anno.fun.params.IfNeq;
import com.javaoffers.brief.modelhelper.anno.fun.params.IfNotNull;
import com.javaoffers.brief.modelhelper.anno.fun.params.IfNull;
import com.javaoffers.brief.modelhelper.anno.fun.params.Left;
import com.javaoffers.brief.modelhelper.anno.fun.params.Right;
import com.javaoffers.brief.modelhelper.anno.fun.params.math.Abs;
import com.javaoffers.brief.modelhelper.anno.fun.params.math.Ceil;
import com.javaoffers.brief.modelhelper.anno.fun.params.math.Floor;
import com.javaoffers.brief.modelhelper.anno.fun.params.math.Mod;
import com.javaoffers.brief.modelhelper.anno.fun.params.math.Round;
import com.javaoffers.brief.modelhelper.anno.fun.params.math.Truncate;
import com.javaoffers.brief.modelhelper.anno.fun.params.time.DateFormat;
import com.javaoffers.brief.modelhelper.anno.fun.params.time.Dayname;
import com.javaoffers.brief.modelhelper.anno.fun.params.time.FromDays;
import com.javaoffers.brief.modelhelper.anno.fun.params.time.Hour;
import com.javaoffers.brief.modelhelper.anno.fun.params.time.Makedate;
import com.javaoffers.brief.modelhelper.anno.fun.params.time.Maketime;
import com.javaoffers.brief.modelhelper.anno.fun.params.time.Minute;
import com.javaoffers.brief.modelhelper.anno.fun.params.time.Month;
import com.javaoffers.brief.modelhelper.anno.fun.params.time.Monthname;
import com.javaoffers.brief.modelhelper.anno.fun.params.time.SecToTime;
import com.javaoffers.brief.modelhelper.anno.fun.params.time.StrToDate;
import com.javaoffers.brief.modelhelper.anno.fun.params.time.TimeFormat;
import com.javaoffers.brief.modelhelper.anno.fun.params.time.TimeToSec;
import com.javaoffers.brief.modelhelper.anno.fun.params.time.ToDays;
import com.javaoffers.brief.modelhelper.anno.fun.params.time.Week;
import com.javaoffers.brief.modelhelper.anno.fun.params.time.Weekday;
import com.javaoffers.brief.modelhelper.anno.fun.params.time.Year;
import com.javaoffers.brief.modelhelper.anno.fun.params.varchar.CharLength;
import com.javaoffers.brief.modelhelper.anno.fun.params.varchar.Concat;
import com.javaoffers.brief.modelhelper.anno.fun.params.varchar.ConcatWs;
import com.javaoffers.brief.modelhelper.anno.fun.params.varchar.GroupConcat;
import com.javaoffers.brief.modelhelper.anno.fun.params.varchar.LTrim;
import com.javaoffers.brief.modelhelper.anno.fun.params.varchar.Length;
import com.javaoffers.brief.modelhelper.anno.fun.params.varchar.Lower;
import com.javaoffers.brief.modelhelper.anno.fun.params.varchar.RTrim;
import com.javaoffers.brief.modelhelper.anno.fun.params.varchar.Repeat;
import com.javaoffers.brief.modelhelper.anno.fun.params.varchar.Replace;
import com.javaoffers.brief.modelhelper.anno.fun.params.varchar.Strcmp;
import com.javaoffers.brief.modelhelper.anno.fun.params.varchar.SubString;
import com.javaoffers.brief.modelhelper.anno.fun.params.varchar.Trim;
import com.javaoffers.brief.modelhelper.anno.fun.params.varchar.Upper;
import com.javaoffers.brief.modelhelper.anno.fun.parse.ParseSqlFunResult;
import com.javaoffers.brief.modelhelper.utils.Assert;
import com.javaoffers.brief.modelhelper.utils.TableInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class FunAnnoParser {
    public static final String DEFAULT_VALUE = "";

    public static ParseSqlFunResult parse(TableInfo tableInfo, Class modelClass, Field field, String defaultColName) {
        Assert.isTrue(field != null, "the field is null");
        Annotation[] allAnno = field.getDeclaredAnnotations();
        if (allAnno == null || allAnno.length == 0) {
            return null;
        }
        Appender appender = new Appender(modelClass, field, defaultColName);
        ColName colNameAnno = null;
        String coreSql = null;
        boolean isFunSql = false;
        boolean isExcludeColAll = false;
        CaseWhen caseWhen = null;
        for (Annotation anno : allAnno) {
            if (anno instanceof ColName) {
                colNameAnno = (ColName)anno;
                isExcludeColAll = colNameAnno.excludeColAll();
                continue;
            }
            if (anno instanceof GroupConcat) {
                isExcludeColAll = ((GroupConcat)anno).excludeColAll();
            } else if (anno instanceof CaseWhen) {
                caseWhen = (CaseWhen)anno;
                isFunSql = true;
                continue;
            }
            isFunSql = FunAnnoParser.parseParamCommon(appender, anno) || FunAnnoParser.parseParamVarchar(appender, anno) || FunAnnoParser.parseParamTime(appender, anno) || FunAnnoParser.parseParamMath(appender, anno) || FunAnnoParser.parseNoneParamTime(appender, anno) || FunAnnoParser.parseNoneParamMath(appender, anno) || isFunSql;
        }
        if (caseWhen != null) {
            Assert.isTrue(colNameAnno == null, "@CaseWhen and @ColName cannot be used together ");
            Assert.isTrue(!appender.isNoneParam, "@CaseWhen and " + appender.getNoParamFunName() + " cannot be used together");
            CaseWhen.When[] whens = caseWhen.whens();
            StringBuilder caseWhenStr = new StringBuilder("(CASE");
            for (CaseWhen.When when : whens) {
                String whenExp = when.when();
                String then = when.then();
                caseWhenStr.append(" WHEN ");
                caseWhenStr.append(whenExp);
                caseWhenStr.append(" THEN ");
                caseWhenStr.append(then);
            }
            CaseWhen.Else elseEnd = caseWhen.elseEnd();
            caseWhenStr.append(" ELSE ");
            caseWhenStr.append(elseEnd.value());
            caseWhenStr.append(" END)");
            coreSql = caseWhenStr.toString();
        }
        if (colNameAnno != null) {
            coreSql = colNameAnno.value();
            Assert.isTrue(colNameAnno != null && !appender.isNoneParam, "@ColName and " + appender.getNoParamFunName() + " cannot be used together");
        }
        if (isFunSql && tableInfo.getColNames().containsKey(coreSql)) {
            coreSql = tableInfo.getTableName() + "." + coreSql;
        }
        String finishSql = appender.toSqlString(coreSql);
        if (!isFunSql && !tableInfo.getColNames().containsKey(finishSql)) {
            isFunSql = true;
        }
        return new ParseSqlFunResult(finishSql, isFunSql, isExcludeColAll);
    }

    private static boolean parseNoneParamMath(Appender appender, Annotation anno) {
        boolean status = false;
        if (anno instanceof Rand) {
            appender.appenderNoneParam("RAND");
            status = true;
        }
        return status;
    }

    private static boolean parseNoneParamTime(Appender appender, Annotation anno) {
        boolean status = false;
        if (anno instanceof CurrentDate) {
            appender.appenderNoneParam("CURRENT_DATE");
            status = true;
        } else if (anno instanceof Curdate) {
            appender.appenderNoneParam("CURDATE");
            status = true;
        } else if (anno instanceof CurrentTime) {
            appender.appenderNoneParam("CURRENT_TIME");
            status = true;
        } else if (anno instanceof Curtime) {
            appender.appenderNoneParam("CURTIME");
            status = true;
        } else if (anno instanceof Now) {
            appender.appenderNoneParam("NOW");
            status = true;
        } else if (anno instanceof UnixTimestamp) {
            appender.appender("UNIX_TIMESTAMP", new Object[0]);
            status = true;
        }
        return status;
    }

    private static boolean parseParamMath(Appender appender, Annotation anno) {
        boolean status = false;
        if (anno instanceof Abs) {
            Abs abs = (Abs)anno;
            appender.appender("ABS", new Object[0]);
            status = true;
        } else if (anno instanceof Ceil) {
            Ceil ceil = (Ceil)anno;
            appender.appender("CEIL", new Object[0]);
            status = true;
        } else if (anno instanceof Floor) {
            Floor floor = (Floor)anno;
            appender.appender("FLOOR", new Object[0]);
            status = true;
        } else if (anno instanceof Mod) {
            Mod mod = (Mod)anno;
            int value = mod.value();
            appender.appender("MOD", value);
            status = true;
        } else if (anno instanceof Round) {
            Round round = (Round)anno;
            appender.appender("ROUND", round.precision());
            status = true;
        } else if (anno instanceof Truncate) {
            Truncate truncate = (Truncate)anno;
            appender.appender("TRUNCATE", truncate.value());
            status = true;
        }
        return status;
    }

    private static boolean parseParamTime(Appender appender, Annotation anno) {
        boolean status = false;
        if (anno instanceof DateFormat) {
            DateFormat dateFormat = (DateFormat)anno;
            String format = dateFormat.value();
            appender.appender("DATE_FORMAT", format);
            status = true;
        } else if (anno instanceof Dayname) {
            Dayname dayname = (Dayname)anno;
            appender.appender("DAYNAME", new Object[0]);
            status = true;
        } else if (anno instanceof FromDays) {
            appender.appender("FROM_DAYS", new Object[0]);
            status = true;
        } else if (anno instanceof Hour) {
            Hour hour = (Hour)anno;
            appender.appender("HOUR", new Object[0]);
            status = true;
        } else if (anno instanceof Maketime) {
            int ep1 = ((Maketime)anno).ep1();
            int ep2 = ((Maketime)anno).ep2();
            appender.appender("MAKETIME", ep1, ep2);
            status = true;
        } else if (anno instanceof Makedate) {
            int value = ((Makedate)anno).value();
            appender.appender("MAKEDATE", value);
            status = true;
        } else if (anno instanceof Minute) {
            Minute minute = (Minute)anno;
            appender.appender("MINUTE", new Object[0]);
            status = true;
        } else if (anno instanceof Month) {
            Month month = (Month)anno;
            appender.appender("MONTH", new Object[0]);
            status = true;
        } else if (anno instanceof Monthname) {
            Monthname monthname = (Monthname)anno;
            appender.appender("MONTHNAME", new Object[0]);
            status = true;
        } else if (anno instanceof SecToTime) {
            appender.appender("SEC_TO_TIME", new Object[0]);
            status = true;
        } else if (anno instanceof StrToDate) {
            String format = ((StrToDate)anno).value();
            appender.appender("STR_TO_DATE", format);
            status = true;
        } else if (anno instanceof TimeFormat) {
            TimeFormat timeFormat = (TimeFormat)anno;
            String format = timeFormat.value();
            appender.appender("TIME_FORMAT", format);
            status = true;
        } else if (anno instanceof ToDays) {
            appender.appender("TO_DAYS", new Object[0]);
            status = true;
        } else if (anno instanceof TimeToSec) {
            appender.appender("TIME_TO_SEC", new Object[0]);
            status = true;
        } else if (anno instanceof Week) {
            Week week = (Week)anno;
            appender.appender("WEEK", new Object[0]);
            status = true;
        } else if (anno instanceof Weekday) {
            Weekday weekday = (Weekday)anno;
            appender.appender("WEEKDAY", new Object[0]);
            status = true;
        } else if (anno instanceof Year) {
            Year year = (Year)anno;
            appender.appender("YEAR", new Object[0]);
            status = true;
        }
        return status;
    }

    private static boolean parseParamVarchar(Appender appender, Annotation anno) {
        boolean status = false;
        if (anno instanceof CharLength) {
            CharLength charLength = (CharLength)anno;
            appender.appender("CHAR_LENGTH", new Object[0]);
            status = true;
        } else if (anno instanceof Concat) {
            Concat concat = (Concat)anno;
            appender.appenderPosition("CONCAT", concat.position(), concat.value());
            status = true;
        } else if (anno instanceof ConcatWs) {
            ConcatWs concat = (ConcatWs)anno;
            String separator = concat.separator();
            String[] value = concat.value();
            LinkedList<Object> params = new LinkedList<Object>();
            for (String conc : value) {
                params.add(conc);
            }
            params.addFirst(separator);
            appender.appenderPosition("CONCAT_WS", concat.position() + 1, params);
            status = true;
        } else if (anno instanceof GroupConcat) {
            String separator;
            GroupConcat groupConcat = (GroupConcat)anno;
            boolean distinct = groupConcat.distinct();
            String distinctKeyWord = distinct ? " distinct " : " ";
            GroupConcat.OrderBy orderBy = groupConcat.orderBy();
            String orderByColName = orderBy.colName();
            GroupConcat.Sort sort = orderBy.sort();
            String groupConcatStatment = DEFAULT_VALUE;
            if (StringUtils.isNotBlank((CharSequence)orderByColName)) {
                groupConcatStatment = " order by " + orderByColName + " " + sort.name();
            }
            if (StringUtils.isNotBlank((CharSequence)(separator = groupConcat.separator()))) {
                groupConcatStatment = groupConcatStatment + " separator '" + separator + "'";
            }
            appender.appenderParamNotSeparatorComma("GROUP_CONCAT", distinctKeyWord, groupConcatStatment);
            status = true;
        } else if (anno instanceof Length) {
            Length length = (Length)anno;
            appender.appender("LENGTH", new Object[0]);
            status = true;
        } else if (anno instanceof Lower) {
            Lower lower = (Lower)anno;
            appender.appender("LOWER", new Object[0]);
            status = true;
        } else if (anno instanceof LTrim) {
            LTrim lTrim = (LTrim)anno;
            appender.appender("LTRIM", new Object[0]);
            status = true;
        } else if (anno instanceof Repeat) {
            Repeat repeat = (Repeat)anno;
            int value = repeat.value();
            appender.appender("REPEAT", value);
            status = true;
        } else if (anno instanceof Replace) {
            Replace replace = (Replace)anno;
            String ep1 = replace.ep1();
            String ep2 = replace.ep2();
            appender.appender("REPLACE", ep1, ep2);
            status = true;
        } else if (anno instanceof RTrim) {
            RTrim rTrim = (RTrim)anno;
            appender.appender("RTRIM", new Object[0]);
            status = true;
        } else if (anno instanceof Strcmp) {
            Strcmp strcmp = (Strcmp)anno;
            appender.appender("STRCMP", strcmp.value());
            status = true;
        } else if (anno instanceof SubString) {
            SubString subString = (SubString)anno;
            String ep1 = subString.ep1();
            String ep2 = subString.ep2();
            appender.appender("SUBSTRING", ep1, ep2);
            status = true;
        } else if (anno instanceof Trim) {
            Trim trim = (Trim)anno;
            appender.appender("TRIM", new Object[0]);
            status = true;
        } else if (anno instanceof Upper) {
            Upper upper = (Upper)anno;
            appender.appender("UPPER", new Object[0]);
            status = true;
        }
        return status;
    }

    private static boolean parseParamCommon(Appender appender, Annotation anno) {
        boolean status = false;
        if (anno instanceof Left) {
            Left left = (Left)anno;
            int value = left.value();
            appender.appender("LEFT", value);
            status = true;
        } else if (anno instanceof Right) {
            Right right = (Right)anno;
            int value = right.value();
            appender.appender("RIGHT", value);
            status = true;
        } else if (anno instanceof IfNull) {
            IfNull ifNull = (IfNull)anno;
            String value = ifNull.value();
            appender.appender("IFNULL", value);
            status = true;
        } else if (anno instanceof If) {
            If if_ = (If)anno;
            String expr1 = if_.ep1();
            String expr2 = if_.ep2();
            appender.appender("IF", expr1, expr2);
            status = true;
        } else if (anno instanceof IfEq) {
            IfEq ifEq = (IfEq)anno;
            String ep1 = ifEq.ep1();
            String ep2 = ifEq.ep2();
            String eq = ifEq.eq();
            appender.appenderExpr("IF", " = " + eq, ep1, ep2);
            status = true;
        } else if (anno instanceof IfGt) {
            IfGt ifGt = (IfGt)anno;
            String ep1 = ifGt.ep1();
            String ep2 = ifGt.ep2();
            String gt = ifGt.gt();
            appender.appenderExpr("IF", " > " + gt, ep1, ep2);
            status = true;
        } else if (anno instanceof IfGte) {
            IfGte ifEq = (IfGte)anno;
            String ep1 = ifEq.ep1();
            String ep2 = ifEq.ep2();
            String gte = ifEq.gte();
            appender.appenderExpr("IF", " >= " + gte, ep1, ep2);
            status = true;
        } else if (anno instanceof IfLt) {
            IfLt ifEq = (IfLt)anno;
            String ep1 = ifEq.ep1();
            String ep2 = ifEq.ep2();
            String lt = ifEq.lt();
            appender.appenderExpr("IF", " < " + lt, ep1, ep2);
            status = true;
        } else if (anno instanceof IfLte) {
            IfLte ifEq = (IfLte)anno;
            String ep1 = ifEq.ep1();
            String ep2 = ifEq.ep2();
            String lte = ifEq.lte();
            appender.appenderExpr("IF", " <= " + lte, ep1, ep2);
            status = true;
        } else if (anno instanceof IfNeq) {
            IfNeq ifEq = (IfNeq)anno;
            String ep1 = ifEq.ep1();
            String ep2 = ifEq.ep2();
            String neq = ifEq.neq();
            appender.appenderExpr("IF", " != " + neq, ep1, ep2);
            status = true;
        } else if (anno instanceof IfNotNull) {
            IfNotNull ifNotNull = (IfNotNull)anno;
            String value = ifNotNull.value();
            String ifNullValue = ifNotNull.ifNull();
            appender.appenderExpr("IF", " is not null ", value, ifNullValue);
            status = true;
        }
        return status;
    }

    static class Appender {
        private Class modelClass;
        private Field field;
        private String fieldName;
        private String colName;
        private StringBuilder appenderLeft = new StringBuilder();
        private StringBuilder appenderRight = new StringBuilder();
        private boolean isNoneParam = false;
        private String noParamFunName;

        public Appender appender(String funName, Object ... param) {
            List collect;
            StringBuilder appenderLeftOut = new StringBuilder();
            appenderLeftOut.append(funName);
            appenderLeftOut.append("(");
            appenderLeftOut.append((CharSequence)this.appenderLeft);
            if (param != null && (collect = Arrays.stream(param).filter(Objects::nonNull).map(String::valueOf).collect(Collectors.toList())) != null && collect.size() > 0) {
                String join = String.join((CharSequence)",", collect);
                this.appenderRight.append(",");
                this.appenderRight.append(join);
            }
            this.appenderRight.append(")");
            this.appenderLeft = appenderLeftOut;
            return this;
        }

        public Appender appenderParamNotSeparatorComma(String funName, String expr, Object ... param) {
            List collect;
            StringBuilder appenderLeftOut = new StringBuilder();
            appenderLeftOut.append(funName);
            appenderLeftOut.append("(");
            appenderLeftOut.append(expr);
            appenderLeftOut.append((CharSequence)this.appenderLeft);
            if (param != null && (collect = Arrays.stream(param).filter(Objects::nonNull).map(String::valueOf).collect(Collectors.toList())) != null && collect.size() > 0) {
                String join = String.join((CharSequence)" ", collect);
                this.appenderRight.append(" ");
                this.appenderRight.append(join);
            }
            this.appenderRight.append(")");
            this.appenderLeft = appenderLeftOut;
            return this;
        }

        public Appender appenderPosition(String funName, int position, Object ... param) {
            StringBuilder appenderLeftOut = new StringBuilder();
            appenderLeftOut.append(funName);
            appenderLeftOut.append("(");
            if (param != null) {
                String join;
                List collect = Arrays.stream(param).filter(Objects::nonNull).map(String::valueOf).collect(Collectors.toList());
                if (position < 0) {
                    position = collect.size() + position + 1;
                }
                Assert.isTrue(position <= collect.size() && position >= 0, funName + " position out of bounds");
                List left = collect.subList(0, position);
                List right = collect.subList(position, collect.size());
                if (left != null && left.size() > 0) {
                    join = String.join((CharSequence)",", left);
                    appenderLeftOut.append(join);
                    appenderLeftOut.append(",");
                }
                if (right != null && right.size() > 0) {
                    join = String.join((CharSequence)",", right);
                    this.appenderRight.append(",");
                    this.appenderRight.append(join);
                }
            }
            appenderLeftOut.append((CharSequence)this.appenderLeft);
            this.appenderRight.append(")");
            this.appenderLeft = appenderLeftOut;
            return this;
        }

        public Appender appenderPosition(String funName, int position, List<Object> param) {
            StringBuilder appenderLeftOut = new StringBuilder();
            appenderLeftOut.append(funName);
            appenderLeftOut.append("(");
            if (param != null) {
                String join;
                List collect = param.stream().filter(Objects::nonNull).map(String::valueOf).collect(Collectors.toList());
                if (position < 0) {
                    position = collect.size() + position + 1;
                }
                Assert.isTrue(position <= collect.size() && position >= 0, funName + " position out of bounds");
                List left = collect.subList(0, position);
                List right = collect.subList(position, collect.size());
                if (left != null && left.size() > 0) {
                    join = String.join((CharSequence)",", left);
                    appenderLeftOut.append(join);
                    appenderLeftOut.append(",");
                }
                if (right != null && right.size() > 0) {
                    join = String.join((CharSequence)",", right);
                    this.appenderRight.append(",");
                    this.appenderRight.append(join);
                }
            }
            appenderLeftOut.append((CharSequence)this.appenderLeft);
            this.appenderRight.append(")");
            this.appenderLeft = appenderLeftOut;
            return this;
        }

        public Appender appenderExpr(String funName, String expr, Object ... param) {
            List collect;
            StringBuilder appenderLeftOut = new StringBuilder();
            appenderLeftOut.append(funName);
            appenderLeftOut.append("(");
            appenderLeftOut.append((CharSequence)this.appenderLeft);
            if (param != null && (collect = Arrays.stream(param).filter(Objects::nonNull).map(String::valueOf).collect(Collectors.toList())) != null && collect.size() > 0) {
                String join = String.join((CharSequence)",", collect);
                this.appenderRight.append(expr);
                this.appenderRight.append(",");
                this.appenderRight.append(join);
            }
            this.appenderRight.append(")");
            this.appenderLeft = appenderLeftOut;
            return this;
        }

        public Appender appenderNoneParam(String funName) {
            Assert.isTrue(this.appenderLeft.length() == 0, "The sql function without parameters is only allowed to appear at the top position when used.");
            this.appenderLeft.append(funName);
            this.appenderLeft.append("()");
            this.isNoneParam = true;
            this.noParamFunName = "@" + funName;
            return this;
        }

        public String toSqlString(String coreSql) {
            if (this.isNoneParam) {
                return this.appenderLeft.append((CharSequence)this.appenderRight).toString();
            }
            if (StringUtils.isBlank((CharSequence)coreSql)) {
                coreSql = this.colName;
            }
            this.appenderLeft.append(coreSql);
            this.appenderLeft.append((CharSequence)this.appenderRight);
            return this.appenderLeft.toString();
        }

        public Appender(Class modelClass, Field field, String colName) {
            this.modelClass = modelClass;
            this.field = field;
            this.fieldName = field.getName();
            this.colName = colName;
        }

        public boolean isNoneParam() {
            return this.isNoneParam;
        }

        public String getNoParamFunName() {
            return this.noParamFunName;
        }
    }
}

