/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.core.gkey;

import com.javaoffers.brief.modelhelper.core.gkey.TimeSeq;
import com.javaoffers.brief.modelhelper.utils.Assert;
import java.util.concurrent.atomic.AtomicReference;

class WorkSeq {
    static final int mv = 10;
    static final int max = 1023;
    int seq;
    AtomicReference<TimeSeq> timeSeq;

    public WorkSeq(int seq) {
        this.seq = seq;
        Assert.isTrue(this.seq < 1023);
        this.timeSeq = new AtomicReference<TimeSeq>(new TimeSeq());
    }

    public long next() {
        while (true) {
            long nowMil = System.currentTimeMillis();
            TimeSeq timeSeq = this.timeSeq.get();
            if (nowMil <= timeSeq.seq) {
                int next = timeSeq.atoSeq.next();
                if (next <= 0) continue;
                long build = this.build(this.seq, timeSeq.seq, next);
                return build;
            }
            this.timeSeq.compareAndSet(timeSeq, new TimeSeq(nowMil));
        }
    }

    public long build(long workSeq, long timeSeq, long atoSeq) {
        long len = 63L;
        long key = workSeq << (int)(len -= 10L);
        key |= timeSeq << (int)(len -= 41L);
        return key |= atoSeq << (int)(len - 12L);
    }
}

