/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.utils;

import com.javaoffers.brief.modelhelper.anno.derive.Blur;
import com.javaoffers.brief.modelhelper.anno.derive.EmailBlur;
import com.javaoffers.brief.modelhelper.anno.derive.IdCardBlur;
import com.javaoffers.brief.modelhelper.anno.derive.PhoneNumBlur;
import com.javaoffers.brief.modelhelper.anno.derive.StringBlur;
import com.javaoffers.brief.modelhelper.utils.SoftCache;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class BlurUtils {
    static final Set<Class> blurCLASS = new HashSet<Class>();
    static SoftCache<Field, Boolean> isBlurField = SoftCache.getInstance();

    public static boolean containsBlurAnno(Field field) {
        Annotation[] declaredAnnotations;
        Boolean isBlurField = BlurUtils.isBlurField.get(field);
        if (isBlurField != null) {
            return isBlurField;
        }
        for (Annotation annotation : declaredAnnotations = field.getDeclaredAnnotations()) {
            if (!BlurUtils.isBlurAnno(annotation.annotationType())) continue;
            BlurUtils.isBlurField.put(field, true);
            return true;
        }
        BlurUtils.isBlurField.put(field, false);
        return false;
    }

    public static boolean isBlurAnno(Class clazz) {
        return blurCLASS.contains(clazz);
    }

    public static String processDeriveAnno(Annotation blurAnno, String orgValue) {
        double percent;
        Blur blur;
        if (StringUtils.isBlank((CharSequence)orgValue)) {
            return orgValue;
        }
        if (blurAnno instanceof EmailBlur) {
            EmailBlur emailBlur = (EmailBlur)blurAnno;
            blur = emailBlur.blur();
            double percent2 = emailBlur.percent();
            String blurTag = emailBlur.blurTag();
            String[] email = orgValue.split("@");
            String emailContent = email[0];
            String emilSuffix = email.length == 2 ? "@" + email[1] : (email.length == 1 ? "" : orgValue.substring(orgValue.indexOf("@")));
            orgValue = BlurUtils.processDeriveAnno(blur, percent2, emailContent, blurTag) + emilSuffix;
        }
        if (blurAnno instanceof IdCardBlur) {
            IdCardBlur idCardBlur = (IdCardBlur)blurAnno;
            blur = idCardBlur.blur();
            String blurTag = idCardBlur.blurTag();
            percent = idCardBlur.percent();
            orgValue = BlurUtils.processDeriveAnno(blur, percent, orgValue, blurTag);
        }
        if (blurAnno instanceof PhoneNumBlur) {
            PhoneNumBlur phoneNumBlur = (PhoneNumBlur)blurAnno;
            blur = phoneNumBlur.blur();
            String blurTag = phoneNumBlur.blurTag();
            percent = phoneNumBlur.percent();
            orgValue = orgValue.charAt(0) == '+' && orgValue.length() > 1 ? "+" + BlurUtils.processDeriveAnno(blur, percent, orgValue.substring(1), blurTag) : BlurUtils.processDeriveAnno(blur, percent, orgValue, blurTag);
        }
        if (blurAnno instanceof StringBlur) {
            StringBlur stringBlur = (StringBlur)blurAnno;
            blur = stringBlur.blur();
            String blurTag = stringBlur.blurTag();
            percent = stringBlur.percent();
            orgValue = BlurUtils.processDeriveAnno(blur, percent, orgValue, blurTag);
        }
        return orgValue;
    }

    private static String processDeriveAnno(Blur blur, double percent, String orgValue, String blurTag) {
        if (StringUtils.isBlank((CharSequence)orgValue)) {
            return orgValue;
        }
        String value = orgValue;
        int len = orgValue.length();
        int blurStrLen = (int)Math.ceil((double)len * percent);
        StringBuilder appender = new StringBuilder();
        if (blurStrLen >= len) {
            for (int i = 0; i < len; ++i) {
                appender.append(blurTag);
            }
            return appender.toString();
        }
        for (int i = 0; i < blurStrLen; ++i) {
            appender.append(blurTag);
        }
        int lefLen = 0;
        switch (blur) {
            case POST_BLUR: {
                lefLen = len - blurStrLen;
                value = value.substring(0, lefLen) + appender.toString();
                break;
            }
            case FRONT_BLUR: {
                value = appender.toString() + value.substring(blurStrLen, len);
                break;
            }
            case MIDDLE_BLUR: {
                lefLen = (len - blurStrLen) / 2;
                value = value.substring(0, lefLen) + appender.toString() + value.substring(blurStrLen + lefLen, len);
            }
        }
        return value;
    }

    static {
        blurCLASS.add(EmailBlur.class);
        blurCLASS.add(IdCardBlur.class);
        blurCLASS.add(PhoneNumBlur.class);
        blurCLASS.add(StringBlur.class);
    }
}

