/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.utils;

import com.javaoffers.brief.modelhelper.exception.GetColValueException;
import com.javaoffers.brief.modelhelper.utils.BlurUtils;
import com.javaoffers.brief.modelhelper.utils.ColumnInfo;
import com.javaoffers.brief.modelhelper.utils.TableHelper;
import com.javaoffers.brief.modelhelper.utils.TableInfo;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ColNameAndColValueUtils {
    public static <T> Map<String, Object> parseUniqueCoNameAndUniqueColValue(T model, Class modelClass) {
        HashMap<String, Object> colNameAndColValues = new HashMap<String, Object>();
        TableInfo tableInfo = TableHelper.getTableInfo(modelClass);
        Map<String, ColumnInfo> primaryColNames = tableInfo.getPrimaryColNames();
        Map<String, List<Field>> colNameOfModelField = tableInfo.getColNameAndFieldOfModel();
        primaryColNames.forEach((colName, colInfo) -> {
            List fields = (List)colNameOfModelField.get(colName);
            Object o = null;
            for (Field field : fields) {
                try {
                    if (BlurUtils.containsBlurAnno(field) || (o = field.get(model)) == null) continue;
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new GetColValueException(e.getMessage());
                }
            }
            if (o != null) {
                colNameAndColValues.put((String)colName, o);
            }
        });
        return colNameAndColValues;
    }

    public static <T> Map<String, Object> parseColNameAndColValue(T model, Class modelClass) {
        TableInfo tableInfo = TableHelper.getTableInfo(modelClass);
        Map<String, List<Field>> colNameOfModelField = tableInfo.getColNameAndFieldOfModel();
        HashMap<String, Object> colNameAndColValues = new HashMap<String, Object>();
        if (colNameOfModelField != null && colNameOfModelField.size() > 0) {
            colNameOfModelField.forEach((colName, fields) -> {
                Object o = null;
                try {
                    for (int i = 0; fields != null && i < fields.size(); ++i) {
                        Field field = (Field)fields.get(i);
                        if (BlurUtils.containsBlurAnno(field)) continue;
                        o = field.get(model);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (o != null) {
                    colNameAndColValues.put((String)colName, o);
                }
            });
        }
        return colNameAndColValues;
    }
}

