/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.utils;

import com.javaoffers.brief.modelhelper.anno.derive.JsonColumn;
import com.javaoffers.brief.modelhelper.anno.derive.flag.Version;
import com.javaoffers.brief.modelhelper.core.Id;
import com.javaoffers.brief.modelhelper.filter.JqlMetaInfo;
import com.javaoffers.brief.modelhelper.fun.ConditionTag;
import com.javaoffers.brief.modelhelper.utils.EnumValueUtils;
import com.javaoffers.brief.modelhelper.utils.GsonUtils;
import java.util.Date;
import org.apache.commons.lang3.time.DateFormatUtils;

public enum DBType {
    MYSQL{

        @Override
        public boolean isSupportDuplicateModify() {
            return true;
        }

        @Override
        public String getQuote() {
            return ConditionTag.QUOTE.getTag();
        }
    }
    ,
    H2{

        @Override
        public boolean isSupportDuplicateModify() {
            return true;
        }

        @Override
        public String getQuote() {
            return ConditionTag.QUOTE.getTag();
        }
    }
    ,
    ORACLE{

        @Override
        public boolean isSupportDuplicateModify() {
            return true;
        }

        @Override
        public String getQuote() {
            return ConditionTag.QUOTE.getTag();
        }
    }
    ,
    SQL_SERVER{

        @Override
        public String toString() {
            return "sqlserver";
        }

        @Override
        public boolean isSupportDuplicateModify() {
            return true;
        }
    }
    ,
    CLICK_HOUSE{

        @Override
        public String toString() {
            return "ch";
        }

        @Override
        public int getAutoGeneratedKeys() {
            return 2;
        }

        @Override
        public Object processingTranslation(JqlMetaInfo jqlMetaInfo, String key, Object value) {
            Object object = super.processingTranslation(jqlMetaInfo, key, value);
            if (object instanceof Date) {
                return DateFormatUtils.format((Date)((Date)object), (String)"yyyy-MM-dd HH:mm:ss");
            }
            return object;
        }
    }
    ,
    CLICKHOUSE{

        @Override
        public String toString() {
            return "clickhouse";
        }

        @Override
        public int getAutoGeneratedKeys() {
            return 2;
        }

        @Override
        public Object processingTranslation(JqlMetaInfo jqlMetaInfo, String key, Object value) {
            Object object = super.processingTranslation(jqlMetaInfo, key, value);
            if (object instanceof Date) {
                return DateFormatUtils.format((Date)((Date)object), (String)"yyyy-MM-dd HH:mm:ss");
            }
            return object;
        }
    }
    ,
    POSTGRESQL{

        @Override
        public boolean isSupportDuplicateModify() {
            return true;
        }
    }
    ,
    SQLITE{

        @Override
        public boolean isSupportDuplicateModify() {
            return true;
        }
    };


    public Object processingTranslation(JqlMetaInfo jqlMetaInfo, String key, Object value) {
        if (value instanceof Id) {
            value = ((Id)value).value();
        } else if (value instanceof Enum) {
            value = EnumValueUtils.getEnumValue((Enum)value);
        } else if (value instanceof Version) {
            value = ((Version)value).longValue();
        } else if (value instanceof JsonColumn) {
            value = GsonUtils.gson.toJson(value);
        }
        return value;
    }

    public boolean isSupportDuplicateModify() {
        return false;
    }

    public int getAutoGeneratedKeys() {
        return 1;
    }

    public String toString() {
        return this.name();
    }

    public String getQuote() {
        return "";
    }
}

