/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.utils;

import com.javaoffers.brief.modelhelper.anno.derive.flag.DeriveFlag;
import com.javaoffers.brief.modelhelper.anno.derive.flag.DeriveInfo;
import com.javaoffers.brief.modelhelper.anno.derive.flag.IsDel;
import com.javaoffers.brief.modelhelper.anno.derive.flag.RowStatus;
import com.javaoffers.brief.modelhelper.anno.derive.flag.Version;
import com.javaoffers.brief.modelhelper.context.BriefContext;
import com.javaoffers.brief.modelhelper.context.BriefContextAware;
import com.javaoffers.brief.modelhelper.context.DeriveProcess;
import com.javaoffers.brief.modelhelper.utils.Assert;
import com.javaoffers.brief.modelhelper.utils.TableInfo;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DeriveProcessFire
implements BriefContextAware {
    public static List<DeriveProcess> deriveProcess = null;

    public static void processDerive(TableInfo tableInfo, Field colF, String colName) {
        Assert.isTrue(tableInfo != null, "tableInfo is null");
        Assert.isTrue(colF != null, "colF is null");
        Assert.isTrue(StringUtils.isNotBlank((CharSequence)colName), "colName is null");
        DeriveInfo deriveInfo = new DeriveInfo(colName, colF);
        Class<?> type = colF.getType();
        if (type != null && Version.class.isAssignableFrom(type)) {
            tableInfo.putDeriveColName(DeriveFlag.VERSION, deriveInfo);
            Assert.isTrue(Number.class.isAssignableFrom(colF.getType()), "version col name " + colF.getDeclaringClass() + "." + colF.getName() + " must be Number");
        }
        if (IsDel.class.isAssignableFrom(colF.getType())) {
            Assert.isTrue(tableInfo.getDeriveColName(DeriveFlag.IS_DEL) == null, "Repeated tombstone fields, IsDel or RowStatus cannot be used multiple times at the same time, and cannot be reused");
            tableInfo.putDeriveColName(DeriveFlag.IS_DEL, deriveInfo);
        }
        if (RowStatus.class.isAssignableFrom(colF.getType())) {
            Assert.isTrue(tableInfo.getDeriveColName(DeriveFlag.IS_DEL) == null, "Repeated tombstone fields, IsDel or RowStatus cannot be used multiple times at the same time, and cannot be reused");
            tableInfo.putDeriveColName(DeriveFlag.IS_DEL, deriveInfo);
        }
        deriveProcess.forEach(dp -> dp.processDerive(tableInfo, colF, colName));
    }

    @Override
    public void setBriefContext(BriefContext briefContext) {
        deriveProcess = briefContext.getDeriveProcess();
    }
}

