/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.utils;

import com.javaoffers.brief.modelhelper.anno.EnumValue;
import com.javaoffers.brief.modelhelper.exception.EnumValueException;
import com.javaoffers.brief.modelhelper.utils.SoftCache;
import java.lang.reflect.Field;
import java.util.LinkedList;

public class EnumValueUtils {
    private static final SoftCache<Class, Field> SOFT_CACHE = SoftCache.getInstance();

    public static Field getEnumValueFields(Class desClass) {
        Field field = SOFT_CACHE.get(desClass);
        if (field != null) {
            return field;
        }
        Field[] declaredFields = desClass.getDeclaredFields();
        if (declaredFields == null || declaredFields.length == 0) {
            return null;
        }
        LinkedList<Field> fields = new LinkedList<Field>();
        for (Field f : declaredFields) {
            EnumValue enumValueAnno = f.getDeclaredAnnotation(EnumValue.class);
            if (enumValueAnno == null) continue;
            fields.add(f);
        }
        if (fields.size() == 0) {
            return null;
        }
        if (fields.size() > 1) {
            throw new EnumValueException("@ Enum Value cannot be in the same enumeration class on multiple attributes used at the same time. Only mark in one of the attributes and have unique characteristics");
        }
        Field enumValueField = (Field)fields.get(0);
        enumValueField.setAccessible(true);
        SOFT_CACHE.put(desClass, enumValueField);
        return enumValueField;
    }

    public static Object getEnumValue(Enum eun) {
        Field enumValueField = EnumValueUtils.getEnumValueFields(eun.getClass());
        if (enumValueField == null) {
            return eun.ordinal();
        }
        try {
            return enumValueField.get(eun);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }
}

