/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.utils;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class FutureLock<T> {
    TimeOutLockSupport<T> timeOutLockSupport;
    private long nanos = -1L;
    private AtomicLong windowOffset;

    public FutureLock(TimeUnit timeUnit, long timeLong) {
        if (timeLong < 0L) {
            timeLong = -1L;
        }
        this.nanos = timeUnit.toNanos(timeLong);
        this.windowOffset = new AtomicLong(System.nanoTime() / this.nanos * this.nanos);
        this.timeOutLockSupport = new TimeOutLockSupport();
    }

    public FutureLock() {
        this.timeOutLockSupport = new TimeOutLockSupport();
    }

    public boolean tryLock() {
        boolean status = false;
        if (this.nanos == -1L) {
            status = this.timeOutLockSupport.tryLock();
        } else {
            long oldWO;
            long cwo = System.nanoTime() / this.nanos * this.nanos;
            if (cwo > (oldWO = this.windowOffset.get()) && this.windowOffset.compareAndSet(oldWO, cwo) && this.isDone()) {
                this.reset();
            }
            status = this.timeOutLockSupport.tryLock();
        }
        return status;
    }

    public void unlock(T t) {
        this.timeOutLockSupport.unlock(t);
    }

    public void unlockAsyn(T t) {
        this.timeOutLockSupport.unlockAsyn(t);
    }

    public T get() {
        return this.timeOutLockSupport.get();
    }

    public T getOrOld() {
        return this.timeOutLockSupport.getOrOld();
    }

    public T get(long timeout, TimeUnit unit) throws InterruptedException {
        return this.timeOutLockSupport.get(timeout, unit);
    }

    public T getOrOld(long timeout, TimeUnit unit) throws InterruptedException {
        return this.timeOutLockSupport.getOrOld(timeout, unit);
    }

    public boolean isDone() {
        return this.timeOutLockSupport.isDone();
    }

    public void reset() {
        this.timeOutLockSupport.reset();
    }

    static class TimeOutLockSupport<T>
    extends AbstractQueuedSynchronizer {
        private volatile T future;
        private volatile T resetFuture;
        private volatile boolean isDone = false;
        private static final int openState = 1;
        private static final int closeState = 0;
        private static final int asynState = 0;
        private static final int futureState = -1;

        public boolean tryLock() {
            if (this.isDone) {
                return false;
            }
            boolean lockState = false;
            if (this.compareAndSetState(0, 1)) {
                this.acquire(1);
                lockState = true;
                if (this.isDone) {
                    this.release(0);
                    lockState = false;
                }
            }
            return lockState;
        }

        public void unlock(T t) {
            if (this.getExclusiveOwnerThread() != Thread.currentThread() || this.isDone) {
                throw new IllegalMonitorStateException();
            }
            this.future = t;
            this.resetFuture = t;
            this.isDone = true;
            this.release(0);
        }

        public synchronized void unlockAsyn(T t) {
            if (!this.isDone) {
                this.future = t;
                this.resetFuture = t;
                this.isDone = true;
                this.release(0);
            }
        }

        @Override
        protected boolean tryAcquire(int arg) {
            boolean state = false;
            if (arg == 1) {
                Thread thread = Thread.currentThread();
                this.setExclusiveOwnerThread(thread);
                state = true;
            } else if (!this.hasQueuedPredecessors()) {
                state = this.compareAndSetState(0, -1);
            }
            return state;
        }

        @Override
        protected boolean tryRelease(int arg) {
            if (arg == 0 && Thread.currentThread() == this.getExclusiveOwnerThread() || arg == 0) {
                return this.compareAndSetState(1, 0);
            }
            return this.compareAndSetState(-1, 0);
        }

        public T get() {
            if (!this.isDone) {
                this.acquire(-1);
                this.release(-1);
            }
            return this.future;
        }

        public T getOrOld() {
            if (!this.isDone) {
                this.acquire(-1);
                this.release(-1);
            }
            return this.resetFuture;
        }

        T get(long timeout, TimeUnit unit) throws InterruptedException {
            if (!this.isDone && this.tryAcquireNanos(-1, unit.toNanos(timeout))) {
                this.release(-1);
            }
            return this.future;
        }

        T getOrOld(long timeout, TimeUnit unit) throws InterruptedException {
            if (!this.isDone && this.tryAcquireNanos(-1, unit.toNanos(timeout))) {
                this.release(-1);
            }
            return this.resetFuture;
        }

        boolean isDone() {
            return this.isDone;
        }

        public void reset() {
            if (this.isDone) {
                this.acquire(-1);
                this.setExclusiveOwnerThread(null);
                this.isDone = false;
                this.future = null;
                this.release(-1);
            }
        }
    }
}

